// -*- C++ -*-
#include "sort.h"
#include "trvgen.h" 
#include "gen.h"
#include <cilktools/cilkview.h>
#include <cstdlib>
#include <ctime> 

using namespace std;
// #define cilk_sync
// #define cilk_spawn 
// #define cilk_for for

/**
 * cilk_main:
 * method = argc[1] :
 *
 * method = 0 =====> random input
 * ne :: argv[2],  
 * nv :: argv[3] nodes. the number of nodes should be a multiple of 32,
 * otherwise need to modify a bit "generate_rand"
 * Example: main 0 5 32
 
 * method = 1 =====> enumeration problem 
 * nv :: argv2, r :: argv3, ne :: argv4
 * Example: main 1 40 10 847660528
 
 * method = 2 =====> lovasz hypergraph of rank r
 * r :: argv2
 * Example: main 2 6

 * method = 3 =====> read files from Kavvadias and Elias
 **/

int main(int argc, char **argv)
{ 

  int nv, elem_size;
  long long ne;
  int method = atoi(argv[1]);
  sfixn *edges;
  int r;

  // generate input hypergraphs according to different input methods
  if(method == 0){
    ne = atoi(argv[2]);
    nv = atoi(argv[3]);
    edges = generate_rand(elem_size, nv, ne);

  }else if(method == 1){
    nv = atoi(argv[2]);
    r  = atoi(argv[3]);
    ne  = atoll(argv[4]);

    if( nv <= 0 )
      elem_size = 1;
    else if( (nv % WORDSIZE) == 0 )
      elem_size = nv/WORDSIZE;
    else
      elem_size = nv/WORDSIZE + 1;
    ++elem_size; // one more unsigned to mark its status
    
    int *comb = (int *)calloc(r, sizeof(int));
    edges = (unsigned *)calloc(ne * elem_size, sizeof(unsigned));
    
    generate_enum(edges, comb, elem_size, nv, r);

    free(comb);

  }else if(method == 2){
    r = atoi(argv[2]);
    edges = gen_lovasz(ne, elem_size, nv, r);

  }else if(method == 3){
    FILE *fp;
    if((fp = fopen(argv[2], "r")) == NULL)
      return -1;
    cout << "reading file" << endl;
    edges = read_files(ne, nv, elem_size, fp);
    fclose(fp);
  }else
    return -1;
    
  //print_edges(edges, ne, nv, elem_size);
  //std::cout.flush();
  // the sorted edges will overwrite edges
  //sfixn *work = (sfixn *)calloc(ne * elem_size, sizeof(sfixn));
  //sort_edges(edges, ne, work, elem_size, nv);
  //free(work);
  //printf("===============   Input   =============\n");
  //print_edges(edges, ne, nv, elem_size);

  unsigned *ts;
  long long nbout;
  
  unsigned long long start = __cilkview_getticks();

  ts = trvgen(nbout, edges, ne, elem_size, nv);

  unsigned long long end = __cilkview_getticks();
  float elapsed = (end - start) / 1000.f;
  cout << "Running time is " << elapsed << " secs." << endl; 

  //cv.dump("trvgen-gl2-32-16-128");

  //cout << "WHOLE TIME " << cv.accumulated_milliseconds() << " ms." << endl;

  
  //printf("===============   minimal traversal   =============\n");
  printf("===============   #in    %lld =============\n", ne);
  printf("===============   #out   %lld =============\n", nbout);
  print_edges(ts, nbout, nv, elem_size);
  free(edges);
  free(ts);
  return 0;
}

