#include "IntegerPolynomial/DUZP_Support_Factoring.hpp"
#include "IntegerPolynomial/NTL_mpz_DUZP_conversion.hpp"
#include "ModularPolynomial/DUSP_NTL_Support.h"
#include "NTL/ZZXFactoring.h"
#include "NTL/LLL.h"
#include "Utils/MacroHelpers.h"

//#include <bpas.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <fstream>
#include <iostream>
#include "Utils/Unix_Timer.h"
#include "Parser/bpas_parser.h"
#include "../MapleTestTool/MapleTestTool.hpp"

polysize_t maxDeg = 5;
int coefBoundBits = 5ul;
float sparsity = 0;
int includeNeg = 1;

prime_t pr = 11;
polysize_t nfactors = 5;

char xvar[1] = {'x'};

using namespace DUZP::Factoring;

extern void naive_search_test();
extern void recombine_test();
extern void vec_mpz_test();
extern void vec_DUZP_test();
extern void vec_duspoly_test();
extern void vec_DUZP_long_test();
extern void factor_test(int deg, int n, int monic);
extern void factor_test(int* sizes, int n, int monic);
extern void factor_timing(int deg, int n, int monic);

extern void ddf_test();
extern void edf_test();

int main() {

//	naive_search_test();
//	vec_vec_test();
//	vec_mpz_test();
//	vec_DUZP_test();
//	vec_duspoly_test();
//	vec_DUZP_long_test();

	factor_timing(25,10,0);

//	factor_test(2,10,1);
//	int sizes[2] = {5,2};
//	factor_test(sizes,2,0);
//	int sizes[5] = {1,4,2,5,4};
//	factor_test(sizes,5,0);
//	int sizes[10] = {1,4,2,5,4,9,2,7,9,12};
//	factor_test(sizes,10,0);
//	int sizes[8] = {1,2,3,4,5,6,7,8};
//	factor_test(sizes,8,0);

//	Recombine_test(); // compare with NTL
//	recombine_test(); // pure BPAS

//	ddf_test();
//	edf_test();

	return 0;
}

void ddf_test() {

	DUZP_t* f = buildRandomPoly_DUZP(12,coefBoundBits,sparsity,includeNeg);
	mpz_set_ui(f->coefs[f->lt],1);
	Prime_ptr* Pptr = smallprimefield_get_prime_constants(3);
	duspoly_t* ff = convertToDUSP_DUZP(f,Pptr);
	factsll_t* factors;
	distinctDegFactorizationInFormll1_spX(ff,&factors,Pptr);

	freePolynomial_DUZP(f);
	freePolynomial_spX(&ff);
	freeFactsll_spX(&factors);
	free(Pptr);

}

void edf_test() {

	DUZP_t* f = buildRandomPoly_DUZP(12,coefBoundBits,sparsity,includeNeg);
	mpz_set_ui(f->coefs[f->lt],1);
	Prime_ptr* Pptr = smallprimefield_get_prime_constants(3);
	duspoly_t* ff = convertToDUSP_DUZP(f,Pptr);
	factsll_t* ddfactors;
	factsll_t* edfactors;

	distinctDegFactorizationInFormll1_spX(ff,&ddfactors,Pptr);

	equalDegFactorsInFormll1_spX(ddfactors,&edfactors,Pptr);

	freePolynomial_DUZP(f);
	freePolynomial_spX(&ff);
	freeFactsll_spX(&ddfactors);
	freeFactsll_spX(&edfactors);
	free(Pptr);

}

DUZP_t** makePolynomials(int deg, long r, int monic) {

	DUZP_t** F = (DUZP_t**) malloc(sizeof(DUZP_t*)*r);
	mpz_t one;
	mpz_init(one);
	mpz_set_ui(one,1);

	for (long k=0; k<r; ++k) {
		F[k] = buildRandomPoly_DUZP(deg,coefBoundBits,sparsity,includeNeg);
		if (monic) mpz_set(F[k]->coefs[F[k]->lt],one);
	}

	mpz_clear(one);
	return F;
}

DUZP_t** makePolynomials(int* sizes, long r, int monic) {

	DUZP_t** F = (DUZP_t**) malloc(sizeof(DUZP_t*)*r);
	mpz_t one;
	mpz_init(one);
	mpz_set_ui(one,1);

	for (long k=0; k<r; ++k) {
		F[k] = buildRandomPoly_DUZP(sizes[k],coefBoundBits,sparsity,includeNeg);
		if (monic) mpz_set(F[k]->coefs[F[k]->lt],one);
	}

	mpz_clear(one);
	return F;
}

DUZP_t* makeExamplePolynomial(int* sizes, long r) {

	DUZP_t* f = makeConstPolynomial_DUZP(1,1);
	DUZP_t* tmp;
	mpz_t one;
	mpz_init(one);
	mpz_set_ui(one,1);

	for (long k=0; k<r; ++k) {
		tmp = buildRandomPoly_DUZP(sizes[k],coefBoundBits,sparsity,includeNeg);
		mpz_set(tmp->coefs[tmp->lt],one);
		multiplyPolynomials_DUZP_inp(tmp,&f);
		freePolynomial_DUZP(tmp);
	}

	mpz_clear(one);
	return f;
}

void factor_test(int deg, int n, int monic) {

	DUZP_t* f;
	if (n > 1) {
		DUZP_t** F = makePolynomials(deg, n, monic);
		f = makeConstPolynomial_DUZP(1,1);

		for (int i=0; i<n; ++i) {
			multiplyPolynomials_DUZP_inp(F[i],&f);
			freePolynomial_DUZP(F[i]);
		}
		free(F);

	}
	else if (n == 1) {
		f = buildRandomPoly_DUZP(deg,coefBoundBits,sparsity,includeNeg);
		if (monic) {
			mpz_t one;
			mpz_init(one);
			mpz_set_ui(one,1);
			mpz_set(f->coefs[f->lt],one);
			mpz_clear(one);
		}
	}
	else {
		fprintf(stderr,"Invalid number of factors!");
		exit(1);
	}

	printPoly_DUZP(f,xvar);

	NTL::ZZX ff;
	NTLZZX_set_DUZP_t(ff,f);
	NTL::ZZ c;
	NTL::vec_pair_ZZX_long factors;

//	factor_data_t fd;
	factor(c, factors, ff, 1, 0);
//	factor(c, factors, ff, 1, 0, fd);

	DUZP_t* g = makeConstPolynomial_DUZP(1,0);
	for (int i=1; i<=factors.length(); ++i) {
		DUZP_t_set_NTLZZX(&g,factors(i).a);
		printPoly_DUZP(g,xvar);
	}

	freePolynomial_DUZP(g);

	mpz_t cc;
	mpz_init(cc);
	vec_DUZP_long_t factors2;
	vec_DUZP_long_t_init2(&factors2,0);

	long long unsigned int start(0);
	float elapsed;

	fprintf(stderr,"calling BPAS factor:\n");

	_startTimer(&start);

	factor(&cc,&factors2,f);

	_stopTimer(&start,&elapsed);
	fprintf(stderr,"time: %f\n",elapsed);

	g = makeConstPolynomial_DUZP(1,1);
	DUZP_t* h;
	for (int i=0; i<factors2.size; ++i) {
		h = makeConstPolynomial_DUZP(1,1);
		fprintf(stderr,"exp = %ld\n",factors2.pairs[i].b);
		for (int j=0; j<factors2.pairs[i].b; ++j)
			multiplyPolynomials_DUZP_inp(factors2.pairs[i].a,&h);
		multiplyPolynomials_DUZP_inp(h,&g);
		printPoly_DUZP(h,xvar);
		freePolynomial_DUZP(h);
	}
	multiplyByInteger_DUZP_inp(g,cc);

	fprintf(stderr,"g = ");
	printPoly_DUZP(g,xvar);
	fprintf(stderr,"f = ");
	printPoly_DUZP(f,xvar);
	g = subtractPolynomials_DUZP(f,g);
	fprintf(stderr,"f - g = ");
	printPoly_DUZP(g,xvar);


//	print_factor_data(fd);

	mpz_clear(cc);
	freePolynomial_DUZP(f);
	freePolynomial_DUZP(g);
	vec_DUZP_long_t_free(&factors2);

}

void factor_test(int* sizes, int n, int monic) {

	DUZP_t** F = makePolynomials(sizes,n,monic);

	DUZP_t* f = makeConstPolynomial_DUZP(1,1);

	for (int i=0; i<n; ++i)
		multiplyPolynomials_DUZP_inp(F[i],&f);

//	DUZP_t* f = buildRandomPoly_DUZP(16,coefBoundBits,sparsity,includeNeg);

	printPoly_DUZP(f,xvar);

	NTL::ZZX ff;
	NTLZZX_set_DUZP_t(ff,f);
	NTL::ZZ c;
	NTL::vec_pair_ZZX_long factors;

//	factor_data_t fd;
	factor(c, factors, ff, 1, 0);

	DUZP_t* g = makeConstPolynomial_DUZP(1,0);
	for (int i=1; i<=factors.length(); ++i) {
		DUZP_t_set_NTLZZX(&g,factors(i).a);
		printPoly_DUZP(g,xvar);
	}

	freePolynomial_DUZP(g);

	mpz_t cc;
	mpz_init(cc);
	vec_DUZP_long_t factors2;
	vec_DUZP_long_t_init2(&factors2,0);

	factor(&cc,&factors2,f);

	g = makeConstPolynomial_DUZP(1,1);
	DUZP_t* h;
	for (int i=0; i<factors2.size; ++i) {
		h = makeConstPolynomial_DUZP(1,1);
		fprintf(stderr,"exp = %ld\n",factors2.pairs[i].b);
		for (int j=0; j<factors2.pairs[i].b; ++j)
			multiplyPolynomials_DUZP_inp(factors2.pairs[i].a,&h);
		multiplyPolynomials_DUZP_inp(h,&g);
		printPoly_DUZP(h,xvar);
		freePolynomial_DUZP(h);
	}
	multiplyByInteger_DUZP_inp(g,cc);

	fprintf(stderr,"g = ");
	printPoly_DUZP(g,xvar);
	fprintf(stderr,"f = ");
	printPoly_DUZP(f,xvar);
	g = subtractPolynomials_DUZP(f,g);
	fprintf(stderr,"f - g = ");
	printPoly_DUZP(g,xvar);

//	print_factor_data(fd);

	freePolynomial_DUZP(f);
	freePolynomial_DUZP(g);

}



void factor_timing(int deg, int n, int monic) {

	int showOutput = 0;
	std::streambuf *oldcout,*oldcerr;
	std::fstream fs("/dev/null");
	int bakfs1, bakfs2, newfs1, newfs2, bakcout, newcout;

	long long unsigned int start(0);
	float elapsed;

	if (!showOutput) {
//		fprintf(stderr,"hiding output...\n");
		oldcout = std::cout.rdbuf(); // <-- save
		oldcerr = std::cerr.rdbuf(); // <-- save

		std::cout.rdbuf(fs.rdbuf());
		std::cerr.rdbuf(fs.rdbuf());

		fflush(stdout);
		bakfs1 = dup(1);
		newfs1 = open("/dev/null", O_WRONLY);
		dup2(newfs1, 1);
		fflush(stderr);
		bakfs2 = dup(2);
		newfs2 = open("/dev/null", O_WRONLY);
		dup2(newfs2, 2);

	}

	DUZP_t* f;
	if (n > 1) {
		n = 5;
		int degs[] = {360, 360, 1, 1, 89};
		DUZP_t** F = makePolynomials(degs,n,monic);
		// DUZP_t** F = makePolynomials(deg,n,monic);

		f = makeConstPolynomial_DUZP(1,1);

		for (int i=0; i<n; ++i) {
			multiplyPolynomials_DUZP_inp(F[i],&f);
			freePolynomial_DUZP(F[i]);
		}
		free(F);

	}
	else if (n == 1) {
		f = buildRandomPoly_DUZP(deg,coefBoundBits,sparsity,includeNeg);
		if (monic) {
			mpz_t one;
			mpz_init(one);
			mpz_set_ui(one,1);
			mpz_set(f->coefs[f->lt],one);
			mpz_clear(one);
		}
	}
	else {
		fprintf(stderr,"Invalid number of factors!");
		exit(1);
	}

	std::string fstr = "1*x^0*y^0*z^900 - 10*x^0*y^0*z^891 - 90*x^0*y^0*z^890 + 55*x^0*y^0*z^882 + 890*x^0*y^0*z^881 + 4005*x^0*y^0*z^880 - 220*x^0*y^0*z^873 - 4840*x^0*y^0*z^872 - 39160*x^0*y^0*z^871 - 117480*x^0*y^0*z^870 + 715*x^0*y^0*z^864 + 19140*x^0*y^0*z^863 + 210540*x^0*y^0*z^862 + 1135640*x^0*y^0*z^861 + 2555190*x^0*y^0*z^860 - 2002*x^0*y^0*z^855 - 61490*x^0*y^0*z^854 - 823020*x^0*y^0*z^853 - 6035480*x^0*y^0*z^852 - 24416260*x^0*y^0*z^851 - 43949268*x^0*y^0*z^850 + 5005*x^0*y^0*z^846 + 170170*x^0*y^0*z^845 + 2613325*x^0*y^0*z^844 + 23318900*x^0*y^0*z^843 + 128253950*x^0*y^0*z^842 + 415076420*x^0*y^0*z^841 + 622614630*x^0*y^0*z^840 - 11440*x^0*y^0*z^837 - 420420*x^0*y^0*z^836 - 7147140*x^0*y^0*z^835 - 73173100*x^0*y^0*z^834 - 489696900*x^0*y^0*z^833 - 2154666360*x^0*y^0*z^832 - 5811069880*x^0*y^0*z^831 - 7471375560*x^0*y^0*z^830 + 24310*x^0*y^0*z^828 + 949520*x^0*y^0*z^827 + 17447430*x^0*y^0*z^826 + 197737540*x^0*y^0*z^825 + 1518341825*x^0*y^0*z^824 + 8128968540*x^0*y^0*z^823 + 29806217980*x^0*y^0*z^822 + 68902685720*x^0*y^0*z^821 + 77515521435*x^0*y^0*z^820 - 48620*x^0*y^0*z^819 - 1993420*x^0*y^0*z^818 - 38930320*x^0*y^0*z^817 - 476896420*x^0*y^0*z^816 - 4053619570*x^0*y^0*z^815 - 24900805930*x^0*y^0*z^814 - 111095903380*x^0*y^0*z^813 - 349158553480*x^0*y^0*z^812 - 706252528630*x^0*y^0*z^811 - 706252436252*x^0*y^0*z^810 + 3938220*x^0*y^0*z^809 + 80733510*x^0*y^0*z^808 + 1051118640*x^0*y^0*z^807 + 9657152505*x^0*y^0*z^806 + 65668637034*x^0*y^0*z^805 + 336160880055*x^0*y^0*z^804 + 1285538310540*x^0*y^0*z^803 + 3535230353985*x^0*y^0*z^802 + 6356272589728*x^0*y^0*z^801 + 5720638091644*x^0*y^0*z^800 - 157528800*x^0*y^0*z^799 - 2152893600*x^0*y^0*z^798 - 21022372800*x^0*y^0*z^797 - 154514440080*x^0*y^0*z^796 - 875581827120*x^0*y^0*z^795 - 3841838629200*x^0*y^0*z^794 - 12855383105400*x^0*y^0*z^793 - 31424269519430*x^0*y^0*z^792 - 50850168793780*x^0*y^0*z^791 - 41604402497840*x^0*y^0*z^790 + 4148258400*x^0*y^0*z^789 + 42519648600*x^0*y^0*z^788 + 332153490240*x^0*y^0*z^787 + 2034440127720*x^0*y^0*z^786 + 9881566334640*x^0*y^0*z^785 + 37938156463350*x^0*y^0*z^784 + 112841695650660*x^0*y^0*z^783 + 248251708609490*x^0*y^0*z^782 + 365196244634940*x^0*y^0*z^781 + 273889981721260*x^0*y^0*z^780 - 80891038800*x^0*y^0*z^779 - 663306518160*x^0*y^0*z^778 - 4317995373120*x^0*y^0*z^777 - 22669475708880*x^0*y^0*z^776 - 96345271762740*x^0*y^0*z^775 - 328797355199830*x^0*y^0*z^774 - 880165191698560*x^0*y^0*z^773 - 1760329577651190*x^0*y^0*z^772 - 2373765672316220*x^0*y^0*z^771 - 1643239324588400*x^0*y^0*z^770 + 1245721997520*x^0*y^0*z^769 + 8512433649720*x^0*y^0*z^768 + 47497949104320*x^0*y^0*z^767 + 218193703697970*x^0*y^0*z^766 + 824287323770306*x^0*y^0*z^765 + 2531739579310645*x^0*y^0*z^764 + 6161155156018940*x^0*y^0*z^763 + 11295431433316030*x^0*y^0*z^762 + 14059822994132300*x^0*y^0*z^761 + 9036399062758672*x^0*y^0*z^760 - 15779145301920*x^0*y^0*z^759 - 92420708196960*x^0*y^0*z^758 - 451230516491040*x^0*y^0*z^757 - 1842524606917137*x^0*y^0*z^756 - 6264583572297776*x^0*y^0*z^755 - 17492017014492240*x^0*y^0*z^754 - 39020622184861240*x^0*y^0*z^753 - 66034541489050750*x^0*y^0*z^752 - 76322338035352068*x^0*y^0*z^751 - 45767913900224912*x^0*y^0*z^750 + 169062271092000*x^0*y^0*z^749 + 866444139346500*x^0*y^0*z^748 + 3760254300713350*x^0*y^0*z^747 + 13818934413062350*x^0*y^0*z^746 + 42713066843624100*x^0*y^0*z^745 + 109325063507803000*x^0*y^0*z^744 + 225118511428772500*x^0*y^0*z^743 + 353752514575899450*x^0*y^0*z^742 + 381583931110185100*x^0*y^0*z^741 + 214373757291307075*x^0*y^0*z^740 - 1563826007601000*x^0*y^0*z^739 - 7124096251075375*x^0*y^0*z^738 - 27825881603814250*x^0*y^0*z^737 - 92963735999001725*x^0*y^0*z^736 - 263397179447042300*x^0*y^0*z^735 - 622311179489683750*x^0*y^0*z^734 - 1189905868427170400*x^0*y^0*z^733 - 1745134201911529550*x^0*y^0*z^732 - 1764554733187234450*x^0*y^0*z^731 - 931755917548624850*x^0*y^0*z^730 + 12684366495236150*x^0*y^0*z^729 + 52005902259943775*x^0*y^0*z^728 + 184662661594629900*x^0*y^0*z^727 + 565529293024374250*x^0*y^0*z^726 + 1479075372873921350*x^0*y^0*z^725 + 3244898674211115075*x^0*y^0*z^724 + 5790805187552106700*x^0*y^0*z^723 + 7961742832221621575*x^0*y^0*z^722 + 7574914413351454950*x^0*y^0*z^721 + 3768225106313240320*x^0*y^0*z^720 - 91327438074758600*x^0*y^0*z^719 - 340402257343734300*x^0*y^0*z^718 - 1107975813086848200*x^0*y^0*z^717 - 3132160587068820450*x^0*y^0*z^716 - 7606658914185054240*x^0*y^0*z^715 - 15575407571497976400*x^0*y^0*z^714 - 26057958439288640700*x^0*y^0*z^713 - 33716720519573053050*x^0*y^0*z^712 - 30282616518090025210*x^0*y^0*z^711 - 14208667856533546220*x^0*y^0*z^710 + 589477078416569200*x^0*y^0*z^709 + 2014046433637566900*x^0*y^0*z^708 + 6051249996251489700*x^0*y^0*z^707 + 15884507267519070180*x^0*y^0*z^706 + 36004695312264189720*x^0*y^0*z^705 + 69114878381615476575*x^0*y^0*z^704 + 108824830551482357400*x^0*y^0*z^703 + 132967317466495341749*x^0*y^0*z^702 + 113048549831631717646*x^0*y^0*z^701 + 50012802196704665236*x^0*y^0*z^700 - 3438615831549899000*x^0*y^0*z^699 - 10844861355865787250*x^0*y^0*z^698 - 30256217755902081900*x^0*y^0*z^697 - 74127471092182558050*x^0*y^0*z^696 - 157519094777971451250*x^0*y^0*z^695 - 284582630860677963000*x^0*y^0*z^694 - 423168161889747376970*x^0*y^0*z^693 - 489707240286704544985*x^0*y^0*z^692 - 394998944289519202050*x^0*y^0*z^691 - 164370138676302903620*x^0*y^0*z^690 + 18251107627280027500*x^0*y^0*z^689 + 53449622793876845250*x^0*y^0*z^688 + 139178261722280629200*x^0*y^0*z^687 + 319672633420413970125*x^0*y^0*z^686 + 639330651431768943900*x^0*y^0*z^685 + 1090842779275240520010*x^0*y^0*z^684 + 1536514500242942081620*x^0*y^0*z^683 + 1688479688345817935545*x^0*y^0*z^682 + 1294239428498609722910*x^0*y^0*z^681 + 503867682367300178890*x^0*y^0*z^680 - 88648148270430920600*x^0*y^0*z^679 - 242304426847836681900*x^0*y^0*z^678 - 591504570313066786200*x^0*y^0*z^677 - 1278674128883980139025*x^0*y^0*z^676 - 2415168024929440514576*x^0*y^0*z^675 - 3903705811635438922340*x^0*y^0*z^674 - 5222681773929285564800*x^0*y^0*z^673 - 5462096134372264855260*x^0*y^0*z^672 - 3982630902942476690270*x^0*y^0*z^671 - 1436442530351276470220*x^0*y^0*z^670 + 395960822271424696000*x^0*y^0*z^669 + 1014645122825356501050*x^0*y^0*z^668 + 2331200342326606230150*x^0*y^0*z^667 + 4759395889900936004600*x^0*y^0*z^666 + 8516139011102630678140*x^0*y^0*z^665 + 13075348761023055230645*x^0*y^0*z^664 + 16655169470438059008920*x^0*y^0*z^663 + 16608632227357501081395*x^0*y^0*z^662 + 11521719884941705745130*x^0*y^0*z^661 + 3785985803006451563035*x^0*y^0*z^660 - 1633330541764175582900*x^0*y^0*z^659 - 3939174953074894522275*x^0*y^0*z^658 - 8547574414694355375214*x^0*y^0*z^657 - 16531941840496730075131*x^0*y^0*z^656 - 28100423157089864777746*x^0*y^0*z^655 - 41083317365659706437740*x^0*y^0*z^654 - 49928962436701666545370*x^0*y^0*z^653 - 47544619163709604718881*x^0*y^0*z^652 - 31353800222230078057564*x^0*y^0*z^651 - 9122966435686547802512*x^0*y^0*z^650 + 6245028591060933495250*x^0*y^0*z^649 + 14224560878207507621035*x^0*y^0*z^648 + 29240733768445073587460*x^0*y^0*z^647 + 53724970233111513561335*x^0*y^0*z^646 + 86963126889274467265720*x^0*y^0*z^645 + 121332647010395450847800*x^0*y^0*z^644 + 140944112079756570458060*x^0*y^0*z^643 + 128297718687461096282080*x^0*y^0*z^642 + 80251890967479757227130*x^0*y^0*z^641 + 19657804411284880806955*x^0*y^0*z^640 - 22204159802451813045860*x^0*y^0*z^639 - 47912898703984884757880*x^0*y^0*z^638 - 93565097040369791056880*x^0*y^0*z^637 - 163714085678602223262960*x^0*y^0*z^636 - 252917293774313863608320*x^0*y^0*z^635 - 337407014250134760409280*x^0*y^0*z^634 - 375210427612626063147360*x^0*y^0*z^633 - 326673397198028398489400*x^0*y^0*z^632 - 193035112798102676640000*x^0*y^0*z^631 - 36005739115994471313578*x^0*y^0*z^630 + 73622064082841369449420*x^0*y^0*z^629 + 150918106893839335882920*x^0*y^0*z^628 + 280669537785712850583600*x^0*y^0*z^627 + 468730617958167498595200*x^0*y^0*z^626 + 692493023053714236581568*x^0*y^0*z^625 + 884846505786422975559720*x^0*y^0*z^624 + 943152725873252786836560*x^0*y^0*z^623 + 785366334335765645152800*x^0*y^0*z^622 + 435498385560427951020600*x^0*y^0*z^621 + 47770201270359974346270*x^0*y^0*z^620 - 228216592253907585065540*x^0*y^0*z^619 - 445531491116596606229640*x^0*y^0*z^618 - 790862831484910662247440*x^0*y^0*z^617 - 1263173102868085189210320*x^0*y^0*z^616 - 1787849890770273013514160*x^0*y^0*z^615 - 2191326573203174997927480*x^0*y^0*z^614 - 2240872316471596246895280*x^0*y^0*z^613 - 1783287302439866910031301*x^0*y^0*z^612 - 918252953881454490502104*x^0*y^0*z^611 - 4488465621018895202874*x^0*y^0*z^610 + 662859009762669269191180*x^0*y^0*z^609 + 1235178385636545321162840*x^0*y^0*z^608 + 2097036180060226736278992*x^0*y^0*z^607 + 3209182557609950626379928*x^0*y^0*z^606 + 4358437541515051110901224*x^0*y^0*z^605 + 5130717998980190064458340*x^0*y^0*z^604 + 5036505145767701490317342*x^0*y^0*z^603 + 3823827039209293891026166*x^0*y^0*z^602 + 1798423430147866434562270*x^0*y^0*z^601 - 259805812491897207316529*x^0*y^0*z^600 - 1807556976677558158240100*x^0*y^0*z^599 - 3221567090528793385699320*x^0*y^0*z^598 - 5240826803839937330705520*x^0*y^0*z^597 - 7697158092125837214106260*x^0*y^0*z^596 - 10044896422393716212920800*x^0*y^0*z^595 - 11368625784553732816821655*x^0*y^0*z^594 - 10714242820118395188429130*x^0*y^0*z^593 - 7737552262877647265286155*x^0*y^0*z^592 - 3236468141912787136020440*x^0*y^0*z^591 + 1198742200653913359090330*x^0*y^0*z^590 + 4635830975575898838313420*x^0*y^0*z^589 + 7917336306469007938928760*x^0*y^0*z^588 + 12362236813232754894374280*x^0*y^0*z^587 + 17450665156069652361596280*x^0*y^0*z^586 + 21909613752202018395667712*x^0*y^0*z^585 + 23858523976658572191374150*x^0*y^0*z^584 + 21579404409294020496518840*x^0*y^0*z^583 + 14754511044321445541285920*x^0*y^0*z^582 + 5243154365016770622406420*x^0*y^0*z^581 - 3904696488528545183523534*x^0*y^0*z^580 - 11199839731162483538976740*x^0*y^0*z^579 - 18360228632780773147646820*x^0*y^0*z^578 - 27557660567995450924340760*x^0*y^0*z^577 - 37438083239122670511207413*x^0*y^0*z^576 - 45267808476008406293794924*x^0*y^0*z^575 - 47451455193398166813269330*x^0*y^0*z^574 - 41148544287020936322592300*x^0*y^0*z^573 - 26448954722413103618425920*x^0*y^0*z^572 - 7310286666202815170818420*x^0*y^0*z^571 + 10751318248826363441835910*x^0*y^0*z^570 + 25524235068701262298127140*x^0*y^0*z^569 + 40226097742087276970035140*x^0*y^0*z^568 + 58118683930225982186556326*x^0*y^0*z^567 + 76075739033116076191107934*x^0*y^0*z^566 + 88660926083775289932125144*x^0*y^0*z^565 + 89475279474494638913703820*x^0*y^0*z^564 + 74256951682034722118033980*x^0*y^0*z^563 + 44395075083603668575905602*x^0*y^0*z^562 + 7684392313967587536347678*x^0*y^0*z^561 - 26444196135422626194563721*x^0*y^0*z^560 - 54940086139513247333168420*x^0*y^0*z^559 - 83358251238183898743619831*x^0*y^0*z^558 - 116074439827299613916197318*x^0*y^0*z^557 - 146540954595034979922356015*x^0*y^0*z^556 - 164708643088619650310871948*x^0*y^0*z^555 - 159987446332252266016474910*x^0*y^0*z^554 - 126711772578819566577549404*x^0*y^0*z^553 - 69324916152671893494754490*x^0*y^0*z^552 - 2150214980941937514510136*x^0*y^0*z^551 + 59533111499266648918871262*x^0*y^0*z^550 + 111814119745779064984140760*x^0*y^0*z^549 + 163538670950827284874888720*x^0*y^0*z^548 + 219718089162730746991939800*x^0*y^0*z^547 + 267756808030590119087584540*x^0*y^0*z^546 + 290350946335813571466121380*x^0*y^0*z^545 + 271251558108434423703035930*x^0*y^0*z^544 + 204154757038128293325595040*x^0*y^0*z^543 + 99602452477396709770552700*x^0*y^0*z^542 - 17707846112952335713215480*x^0*y^0*z^541 - 124260966072993757040985061*x^0*y^0*z^540 - 215372256010718448741347820*x^0*y^0*z^539 - 304009319792489139757801290*x^0*y^0*z^538 - 394464177861354668123508100*x^0*y^0*z^537 - 464320273372850872514519235*x^0*y^0*z^536 - 485800324187635721076049512*x^0*y^0*z^535 - 435924141761121585958645380*x^0*y^0*z^534 - 309858539016239309049180480*x^0*y^0*z^533 - 128989050702083506686658995*x^0*y^0*z^532 + 66554338471038374281420722*x^0*y^0*z^531 + 242306127468198633270140996*x^0*y^0*z^530 + 392940283342359066386100270*x^0*y^0*z^529 + 535865773709145449038452775*x^0*y^0*z^528 + 672062100086598803499860690*x^0*y^0*z^527 + 764458526989313589953206368*x^0*y^0*z^526 + 771510265467174422589871152*x^0*y^0*z^525 + 663589469711296024042014990*x^0*y^0*z^524 + 441454201480596941155687410*x^0*y^0*z^523 + 144023788665197808110414649*x^0*y^0*z^522 - 167057319636038507666731884*x^0*y^0*z^521 - 443560567505069458457392984*x^0*y^0*z^520 - 679530985708782674947617500*x^0*y^0*z^519 - 896150736254502947853379855*x^0*y^0*z^518 - 1087079012893446557685649366*x^0*y^0*z^517 - 1195214659508731288650558489*x^0*y^0*z^516 - 1162795749831578500197617772*x^0*y^0*z^515 - 955752807257221682056250925*x^0*y^0*z^514 - 587113566988265953760236508*x^0*y^0*z^513 - 121850443212749997426956044*x^0*y^0*z^512 + 350294130752522038790654760*x^0*y^0*z^511 + 764730295204961676259560166*x^0*y^0*z^510 + 1114511349062407038591465540*x^0*y^0*z^509 + 1422522657539925550640310906*x^0*y^0*z^508 + 1669905509261971323249764780*x^0*y^0*z^507 + 1774669522263239285786769084*x^0*y^0*z^506 + 1662510333724827038612965332*x^0*y^0*z^505 + 1300194205405257774089925956*x^0*y^0*z^504 + 722399000282516022799037060*x^0*y^0*z^503 + 29833784744840577407309970*x^0*y^0*z^502 - 653460170645598500341409044*x^0*y^0*z^501 - 1244510211763863628946097281*x^0*y^0*z^500 - 1734368325586455589461905100*x^0*y^0*z^499 - 2144016591032217699797733800*x^0*y^0*z^498 - 2436493428129020520483572800*x^0*y^0*z^497 - 2502139814581891046976166050*x^0*y^0*z^496 - 2253301323112750355967666620*x^0*y^0*z^495 - 1666499508442103965202940500*x^0*y^0*z^494 - 809583450387507271957003000*x^0*y^0*z^493 + 171475687172554650839230850*x^0*y^0*z^492 + 1113702271808678415640631950*x^0*y^0*z^491 + 1914657802139487997197256060*x^0*y^0*z^490 + 2561572455040833551380767550*x^0*y^0*z^489 + 3068738164320245411081277575*x^0*y^0*z^488 + 3376529120191231689453368600*x^0*y^0*z^487 + 3348713457296684024615609110*x^0*y^0*z^486 + 2892071137925062838527844980*x^0*y^0*z^485 + 2005211583822701812497027750*x^0*y^0*z^484 + 801331351460038024864941900*x^0*y^0*z^483 - 520896989764325710190293125*x^0*y^0*z^482 - 1757792947377624025172571120*x^0*y^0*z^481 - 2787601257750618420623627430*x^0*y^0*z^480 - 3591170963591999294517479700*x^0*y^0*z^479 - 4171087413363904303380252450*x^0*y^0*z^478 - 4443340848277272193494177458*x^0*y^0*z^477 - 4251635942636787363449002787*x^0*y^0*z^476 - 3509788464321262098223705092*x^0*y^0*z^475 - 2252868007312700377478299550*x^0*y^0*z^474 - 649834132403287944189864500*x^0*y^0*z^473 + 1044843749006573612547127260*x^0*y^0*z^472 + 2588989518849151804372647640*x^0*y^0*z^471 + 3843049449978201143226742350*x^0*y^0*z^470 + 4778574307681053292369456500*x^0*y^0*z^469 + 5382651834968039119619174160*x^0*y^0*z^468 + 5549790143075332564403612160*x^0*y^0*z^467 + 5116222105244284041128685400*x^0*y^0*z^466 + 4019131462210275501027848260*x^0*y^0*z^465 + 2343845695124577190095819800*x^0*y^0*z^464 + 320706747480321864064494580*x^0*y^0*z^463 - 1743341107566843375843199700*x^0*y^0*z^462 - 3574360211111610747834478240*x^0*y^0*z^461 - 5017769542778364149115200940*x^0*y^0*z^460 - 6033212114029718239624429180*x^0*y^0*z^459 - 6591366212014567847997595960*x^0*y^0*z^458 - 6573926753706634984631226370*x^0*y^0*z^457 - 5827583454206734376597348075*x^0*y^0*z^456 - 4330362385422735437024218360*x^0*y^0*z^455 - 2227509493111664544132966210*x^0*y^0*z^454 + 191421101618845552111443980*x^0*y^0*z^453 + 2577956106412753248350441647*x^0*y^0*z^452 + 4637263461436199752288207308*x^0*y^0*z^451 + 6203335387581911213140956494*x^0*y^0*z^450 + 7222442476260161493550135880*x^0*y^0*z^449 + 7652218982873655528227000250*x^0*y^0*z^448 + 7375923911857434851993357420*x^0*y^0*z^447 + 6271549659406377148233878840*x^0*y^0*z^446 + 4372734855439830359977395660*x^0*y^0*z^445 + 1886391390079947985019440350*x^0*y^0*z^444 - 850698875249355094693112910*x^0*y^0*z^443 - 3466767440238933176102910780*x^0*y^0*z^442 - 5659574651923888307978270630*x^0*y^0*z^441 - 7255457486926742736251250565*x^0*y^0*z^440 - 8187851645583583376042034340*x^0*y^0*z^439 - 8409654713698481204294370290*x^0*y^0*z^438 - 7824166666434049124370117490*x^0*y^0*z^437 - 6360540258587315216296660945*x^0*y^0*z^436 - 4115730564959418318404472300*x^0*y^0*z^435 - 1349246718933857467885090545*x^0*y^0*z^434 + 1576795311016410105979263510*x^0*y^0*z^433 + 4290582025277515457100151398*x^0*y^0*z^432 + 6496120965022496761654840392*x^0*y^0*z^431 + 8015399713740121907955519362*x^0*y^0*z^430 + 8772287390543825863462147180*x^0*y^0*z^429 + 8727752237184217825874511940*x^0*y^0*z^428 + 7824581240250268549853519612*x^0*y^0*z^427 + 6057259339162829347974126428*x^0*y^0*z^426 + 3582967144055451770184352500*x^0*y^0*z^425 + 693074798436902971037876730*x^0*y^0*z^424 - 2254298744309456484406344930*x^0*y^0*z^423 - 4911536512757515388159688320*x^0*y^0*z^422 - 6999973178812404120750315720*x^0*y^0*z^421 - 8339859521565693537324328640*x^0*y^0*z^420 - 8851933620702442551674607500*x^0*y^0*z^419 - 8520815313632896652904198750*x^0*y^0*z^418 - 7345005809942247764572691590*x^0*y^0*z^417 - 5388432714054489085735068430*x^0*y^0*z^416 - 2852821730604598742065691340*x^0*y^0*z^415 - 31068409813601783666620335*x^0*y^0*z^414 + 2754509117014179124302304470*x^0*y^0*z^413 + 5200860595556677910752070760*x^0*y^0*z^412 + 7053105067340909867579270960*x^0*y^0*z^411 + 8132165081585839946059006390*x^0*y^0*z^410 + 8365157448769960308914814700*x^0*y^0*z^409 + 7775778264539927634665323420*x^0*y^0*z^408 + 6426876583030008381908310338*x^0*y^0*z^407 + 4443130400182825826201598542*x^0*y^0*z^406 + 2043726878104904317084795262*x^0*y^0*z^405 - 511750059863700817619467965*x^0*y^0*z^404 - 2964617319629601262460687730*x^0*y^0*z^403 - 5068688737530089415203469908*x^0*y^0*z^402 - 6594279286340864129194018912*x^0*y^0*z^401 - 7366335540926989739369370290*x^0*y^0*z^400 - 7329996980337237192976274340*x^0*y^0*z^399 - 6559578505973550136123152845*x^0*y^0*z^398 - 5179909810456482035400619780*x^0*y^0*z^397 - 3354972510090035882712881835*x^0*y^0*z^396 - 1287428012010107755343515260*x^0*y^0*z^395 + 828608149757468791790763205*x^0*y^0*z^394 + 2815859967113077036824266010*x^0*y^0*z^393 + 4487245167193409497858562445*x^0*y^0*z^392 + 5636185649847481991092932240*x^0*y^0*z^391 + 6097173857637786505383254070*x^0*y^0*z^390 + 5845117131851273683777236240*x^0*y^0*z^389 + 5008880493287215287281225280*x^0*y^0*z^388 + 3760659753881740936374114322*x^0*y^0*z^387 + 2272940314428753875465947758*x^0*y^0*z^386 + 698046850663479535571348518*x^0*y^0*z^385 - 857513504270386329991567925*x^0*y^0*z^384 - 2301893785654184585505588960*x^0*y^0*z^383 - 3500405124299942351847897684*x^0*y^0*z^382 - 4266902971913982216058679136*x^0*y^0*z^381 - 4453500446242476459591389355*x^0*y^0*z^380 - 4073714726666086576391442180*x^0*y^0*z^379 - 3304671705729230233801083139*x^0*y^0*z^378 - 2340833639869502464063104152*x^0*y^0*z^377 - 1329375537036344194658948145*x^0*y^0*z^376 - 346499962779296544237681360*x^0*y^0*z^375 + 595871593823762577331115160*x^0*y^0*z^374 + 1481718600105301409602127940*x^0*y^0*z^373 + 2216917845784827601987831190*x^0*y^0*z^372 + 2635385486322068350652344870*x^0*y^0*z^371 + 2616287832443773555553680260*x^0*y^0*z^370 + 2214443128747231611363310310*x^0*y^0*z^369 + 1638400466726538542451645625*x^0*y^0*z^368 + 1074131601518450175080988650*x^0*y^0*z^367 + 614431174875400570997479880*x^0*y^0*z^366 + 247831765764201335266336210*x^0*y^0*z^365 - 99024959181007348231702315*x^0*y^0*z^364 - 466676785662310958381075460*x^0*y^0*z^363 - 789588919504296348477539683*x^0*y^0*z^362 - 924985826445638303689985532*x^0*y^0*z^361 - 787134325143862563806139065*x^0*y^0*z^360 - 466451752440379027873552720*x^0*y^0*z^359 - 178156887165424383695248515*x^0*y^0*z^358 - 70190443184234968768903904*x^0*y^0*z^357 - 163540917477749239397013646*x^0*y^0*z^356 - 364227000893768114802461988*x^0*y^0*z^355 - 535838153013707033079181290*x^0*y^0*z^354 - 603930586269584505605466114*x^0*y^0*z^353 - 613582681396312081822330512*x^0*y^0*z^352 - 678429388846353952835224238*x^0*y^0*z^351 - 845726325011718240607766952*x^0*y^0*z^350 - 1003543673295144946682371540*x^0*y^0*z^349 - 957385848783896032462880900*x^0*y^0*z^348 - 618705731756199960093841800*x^0*y^0*z^347 - 40300298434873636249543720*x^0*y^0*z^346 + 621041024353814122878346410*x^0*y^0*z^345 + 1194394239070488036610403175*x^0*y^0*z^344 + 1591244413889671318169150550*x^0*y^0*z^343 + 1839045780276929287320957713*x^0*y^0*z^342 + 2016799479391788708259441682*x^0*y^0*z^341 + 2136839614113782046400614372*x^0*y^0*z^340 + 2085417799271031613313752000*x^0*y^0*z^339 + 1712321366065012609099781150*x^0*y^0*z^338 + 996769103143455269519121006*x^0*y^0*z^337 + 52424454860345984412335699*x^0*y^0*z^336 - 929412556851061980555344460*x^0*y^0*z^335 - 1770709030680149881872646755*x^0*y^0*z^334 - 2381942161204437405590730978*x^0*y^0*z^333 - 2771807635983370805927252819*x^0*y^0*z^332 - 2982827478237658574701007650*x^0*y^0*z^331 - 3002874036129840459243690200*x^0*y^0*z^330 - 2736804910271044356371532080*x^0*y^0*z^329 - 2092862968078774026881924112*x^0*y^0*z^328 - 1112331460421378146537666760*x^0*y^0*z^327 + 53504227146472048667853770*x^0*y^0*z^326 + 1208140912680325486952008920*x^0*y^0*z^325 + 2186932867987281254608755845*x^0*y^0*z^324 + 2904898910335422846953702320*x^0*y^0*z^323 + 3349903797161818427815610205*x^0*y^0*z^322 + 3531798269652288552761242970*x^0*y^0*z^321 + 3428810593398010667458909440*x^0*y^0*z^320 + 2980261255732195349819575660*x^0*y^0*z^319 + 2154873805598618494566422620*x^0*y^0*z^318 + 1039068606642267607076771628*x^0*y^0*z^317 - 204987315760389937968662458*x^0*y^0*z^316 - 1399261635288835196180932322*x^0*y^0*z^315 - 2403505133030061532945862510*x^0*y^0*z^314 - 3137278064306060917863771260*x^0*y^0*z^313 - 3567613896082711955705709484*x^0*y^0*z^312 - 3680903111635461180140292346*x^0*y^0*z^311 - 3460812926300951414762243202*x^0*y^0*z^310 - 2888608715059301235667053300*x^0*y^0*z^309 - 1984188459524471555253576568*x^0*y^0*z^308 - 856492678356485006448546264*x^0*y^0*z^307 + 344972058402065627376942051*x^0*y^0*z^306 + 1474838225274941126749502398*x^0*y^0*z^305 + 2419465325584689565404626445*x^0*y^0*z^304 + 3100609537991220837786955528*x^0*y^0*z^303 + 3468148882211717553864921385*x^0*y^0*z^302 + 3497327806276668209920201738*x^0*y^0*z^301 + 3188586872929799761505710279*x^0*y^0*z^300 + 2563167852432240538613147580*x^0*y^0*z^299 + 1675291170641033159551349100*x^0*y^0*z^298 + 634273216188084500534703682*x^0*y^0*z^297 - 438809459745081449079711997*x^0*y^0*z^296 - 1435459063177889514094774172*x^0*y^0*z^295 - 2264923743955771535006545480*x^0*y^0*z^294 - 2849352042429037972756175590*x^0*y^0*z^293 - 3128549397554026418627109948*x^0*y^0*z^292 - 3078774251223604850729475312*x^0*y^0*z^291 - 2722331279069066798792994600*x^0*y^0*z^290 - 2110744257731815662722437980*x^0*y^0*z^289 - 1313317358249162705548924579*x^0*y^0*z^288 - 422913894857470275163332432*x^0*y^0*z^287 + 474247229306073068247497060*x^0*y^0*z^286 + 1302898156562055658022959480*x^0*y^0*z^285 + 1989040611327832739554427500*x^0*y^0*z^284 + 2455551576969334215929813498*x^0*y^0*z^283 + 2640948171676715511094575680*x^0*y^0*z^282 + 2531603023903364129863578050*x^0*y^0*z^281 + 2170197633032365729446013740*x^0*y^0*z^280 + 1624678655651537683262716318*x^0*y^0*z^279 + 962555488169765265899814160*x^0*y^0*z^278 + 251136766185564317547268340*x^0*y^0*z^277 - 456455326124712019072844290*x^0*y^0*z^276 - 1110164524081934074548137620*x^0*y^0*z^275 - 1647101347840804706251410325*x^0*y^0*z^274 - 1993462213214368779637352510*x^0*y^0*z^273 - 2094722526265059963900437753*x^0*y^0*z^272 - 1951776328561787483753928222*x^0*y^0*z^271 - 1621183630662623987417731327*x^0*y^0*z^270 - 1173277709731167525218373510*x^0*y^0*z^269 - 662327627064304503886021935*x^0*y^0*z^268 - 128611925083366224462098688*x^0*y^0*z^267 + 400739701807184604976157268*x^0*y^0*z^266 + 891938662211982474058156728*x^0*y^0*z^265 + 1289676064579149650321374450*x^0*y^0*z^264 + 1527334954073248556447552916*x^0*y^0*z^263 + 1563164771005544725017019323*x^0*y^0*z^262 + 1412215535929514335654118176*x^0*y^0*z^261 + 1136044135582697781158271587*x^0*y^0*z^260 + 796339737581746480551512640*x^0*y^0*z^259 + 429083169208442886326317458*x^0*y^0*z^258 + 51740882166893820276607530*x^0*y^0*z^257 - 325414816628647568738737554*x^0*y^0*z^256 - 677503520662969231664862676*x^0*y^0*z^255 - 955661596402908226393069472*x^0*y^0*z^254 - 1104171883458916443429162330*x^0*y^0*z^253 - 1096455542106865609050278340*x^0*y^0*z^252 - 957779102592886038648653590*x^0*y^0*z^251 - 746143425100249639881614998*x^0*y^0*z^250 - 508257308406287293198309400*x^0*y^0*z^249 - 262310833960587873118534725*x^0*y^0*z^248 - 10109521729484129242856610*x^0*y^0*z^247 + 246541596219970286115404610*x^0*y^0*z^246 + 487068293422895113437431080*x^0*y^0*z^245 + 669589331528590062504936325*x^0*y^0*z^244 + 751591771136200532151770130*x^0*y^0*z^243 + 720727541606152283194094265*x^0*y^0*z^242 + 606848869212912325148904900*x^0*y^0*z^241 + 458198774903760031575943495*x^0*y^0*z^240 + 304966880799147441162536250*x^0*y^0*z^239 + 151637782689798200286937245*x^0*y^0*z^238 - 8197345166070753733619850*x^0*y^0*z^237 - 175214627227383544342061025*x^0*y^0*z^236 - 331230821087586079838794650*x^0*y^0*z^235 - 442405298716344630532022645*x^0*y^0*z^234 - 479682011959880612467079870*x^0*y^0*z^233 - 441616395923182409315430945*x^0*y^0*z^232 - 357219795987645453384545610*x^0*y^0*z^231 - 262052383171752079260250265*x^0*y^0*z^230 - 171926482554843025832467290*x^0*y^0*z^229 - 83051459893123122650450130*x^0*y^0*z^228 + 13304883811561832883322488*x^0*y^0*z^227 + 117144689618051763808409937*x^0*y^0*z^226 + 212570217966149113000249066*x^0*y^0*z^225 + 274343197887722342769011890*x^0*y^0*z^224 + 285177683083895674620119500*x^0*y^0*z^223 + 250208252294626737903089425*x^0*y^0*z^222 + 193742807018244881934234930*x^0*y^0*z^221 + 138830303123169085651734880*x^0*y^0*z^220 + 91008435407406816874796650*x^0*y^0*z^219 + 43146421508414658401673090*x^0*y^0*z^218 - 12267921808724542951899810*x^0*y^0*z^217 - 73711363132889628596396265*x^0*y^0*z^216 - 128166974151232116789780190*x^0*y^0*z^215 - 158552496099657932327290070*x^0*y^0*z^214 - 156431247950585365286549350*x^0*y^0*z^213 - 129510535334000031530596970*x^0*y^0*z^212 - 95639217470163906298028610*x^0*y^0*z^211 - 67658433030977075857920735*x^0*y^0*z^210 - 45217651527550175472699120*x^0*y^0*z^209 - 21243760316229639199899690*x^0*y^0*z^208 + 9207078783587199766073956*x^0*y^0*z^207 + 43557698550308394672614389*x^0*y^0*z^206 + 72110465380672705139404734*x^0*y^0*z^205 + 84550809077132143724915485*x^0*y^0*z^204 + 78069305719161409498962310*x^0*y^0*z^203 + 60103577423809244070666879*x^0*y^0*z^202 + 42164087962995871622075456*x^0*y^0*z^201 + 30067985104623815806868535*x^0*y^0*z^200 + 21087046566954098390392920*x^0*y^0*z^199 + 9864825269920193766712830*x^0*y^0*z^198 - 6106125819534510877741900*x^0*y^0*z^197 - 24051398993209387784601905*x^0*y^0*z^196 - 37495905616233307598064020*x^0*y^0*z^195 - 41012168932789806298037975*x^0*y^0*z^194 - 34672829528404651680135740*x^0*y^0*z^193 - 24202333294849064680042500*x^0*y^0*z^192 - 16065132304686628449717290*x^0*y^0*z^191 - 12052991662094639497070880*x^0*y^0*z^190 - 9230591158460937933392920*x^0*y^0*z^189 - 4270675068042729082970575*x^0*y^0*z^188 + 3682148214642960552692850*x^0*y^0*z^187 + 12309284559287450980515790*x^0*y^0*z^186 + 17777737961691587281038950*x^0*y^0*z^185 + 17702389539424515156737890*x^0*y^0*z^184 + 13165651913884740877446980*x^0*y^0*z^183 + 7877599010821969497411167*x^0*y^0*z^182 + 4930620261723638742888828*x^0*y^0*z^181 + 4299422006322108060711758*x^0*y^0*z^180 + 3789520816920600593603570*x^0*y^0*z^179 + 1686032103580661095861125*x^0*y^0*z^178 - 2034916447760674054746912*x^0*y^0*z^177 - 5770850662459417880797923*x^0*y^0*z^176 - 7535187942956827651564050*x^0*y^0*z^175 - 6541619127287140320388400*x^0*y^0*z^174 - 3888421425563019751468070*x^0*y^0*z^173 - 1630694562811741464721785*x^0*y^0*z^172 - 965010710925638816055280*x^0*y^0*z^171 - 1342711970122288766728165*x^0*y^0*z^170 - 1453771645234450328197900*x^0*y^0*z^169 - 582635802608684615256550*x^0*y^0*z^168 + 1027306570783501003924290*x^0*y^0*z^167 + 2437416232656999044445405*x^0*y^0*z^166 + 2764003389315038609346790*x^0*y^0*z^165 + 1895475247106349524870770*x^0*y^0*z^164 + 593483127815289998670040*x^0*y^0*z^163 - 172925765113882232066466*x^0*y^0*z^162 - 83499472281543599453564*x^0*y^0*z^161 + 361253308763063777225951*x^0*y^0*z^160 + 516270621143213004516640*x^0*y^0*z^159 + 161092687402840425361785*x^0*y^0*z^158 - 468879931365928687339668*x^0*y^0*z^157 - 904617287425445557037127*x^0*y^0*z^156 - 821526322627013330746402*x^0*y^0*z^155 - 303846099903383445187670*x^0*y^0*z^154 + 229421039110218334675878*x^0*y^0*z^153 + 397811357746179943709357*x^0*y^0*z^152 + 191042492179696657741542*x^0*y^0*z^151 - 83886580791857459366480*x^0*y^0*z^150 - 166451487675615971102510*x^0*y^0*z^149 - 25516917656391602170605*x^0*y^0*z^148 + 190383610372016584180950*x^0*y^0*z^147 + 282586388733013726201305*x^0*y^0*z^146 + 161686188741710245358430*x^0*y^0*z^145 - 81362761700789195480020*x^0*y^0*z^144 - 257228358111714891140040*x^0*y^0*z^143 - 248428650357215238583525*x^0*y^0*z^142 - 107489092969105961281670*x^0*y^0*z^141 + 18474577148843261905840*x^0*y^0*z^140 + 46943548051712218267300*x^0*y^0*z^139 - 5824402942801665101785*x^0*y^0*z^138 - 67197237831519925559682*x^0*y^0*z^137 - 67433013227543077037838*x^0*y^0*z^136 + 5353001974814247547298*x^0*y^0*z^135 + 97674330567066478539260*x^0*y^0*z^134 + 139483545642752459325450*x^0*y^0*z^133 + 107051932825820959401964*x^0*y^0*z^132 + 39891927896296006829766*x^0*y^0*z^131 - 5187682362386263612472*x^0*y^0*z^130 - 10710486092276853232830*x^0*y^0*z^129 + 7172675184108600456564*x^0*y^0*z^128 + 19884026902185846805902*x^0*y^0*z^127 + 8239457243556225346157*x^0*y^0*z^126 - 23082822586162258701540*x^0*y^0*z^125 - 50874504732552619363225*x^0*y^0*z^124 - 54685710017032281819670*x^0*y^0*z^123 - 34827171168703695827985*x^0*y^0*z^122 - 10075033947576446580660*x^0*y^0*z^121 + 2130965929990991548245*x^0*y^0*z^120 + 1546404756393568123830*x^0*y^0*z^119 - 3686606211056223725685*x^0*y^0*z^118 - 4601267831336676235154*x^0*y^0*z^117 + 2259592058817771354449*x^0*y^0*z^116 + 12612771319380925308134*x^0*y^0*z^115 + 18669663756004719438565*x^0*y^0*z^114 + 16241684162523903686240*x^0*y^0*z^113 + 8178031505433687283927*x^0*y^0*z^112 + 1126290505670404978358*x^0*y^0*z^111 - 941238104023503391239*x^0*y^0*z^110 + 103000259058106632420*x^0*y^0*z^109 + 1347126282937649308397*x^0*y^0*z^108 + 681705936315643266620*x^0*y^0*z^107 - 1877790482163752706619*x^0*y^0*z^106 - 4440989045004111462254*x^0*y^0*z^105 - 5046243520182216029015*x^0*y^0*z^104 - 3401106413758751624902*x^0*y^0*z^103 - 981263455061375304053*x^0*y^0*z^102 + 440165971409014063460*x^0*y^0*z^101 + 362309804862976912272*x^0*y^0*z^100 - 162475250232539179630*x^0*y^0*z^99 - 376722566104471244930*x^0*y^0*z^98 + 8492514676994382430*x^0*y^0*z^97 + 689348613879650381805*x^0*y^0*z^96 + 1091043270259320164140*x^0*y^0*z^95 + 897809122159439865235*x^0*y^0*z^94 + 303793343876636347060*x^0*y^0*z^93 - 215569439219214478298*x^0*y^0*z^92 - 333988504904657473632*x^0*y^0*z^91 - 116591883486304518089*x^0*y^0*z^90 + 62880694981114314770*x^0*y^0*z^89 + 79930143116408282040*x^0*y^0*z^88 - 39807609198036323456*x^0*y^0*z^87 - 159025915383458771544*x^0*y^0*z^86 - 156276248817855876384*x^0*y^0*z^85 - 30025934904149294415*x^0*y^0*z^84 + 115898953564241220028*x^0*y^0*z^83 + 176573138306644052364*x^0*y^0*z^82 + 128497358964512269386*x^0*y^0*z^81 + 31644359484454677681*x^0*y^0*z^80 - 15339924675427816870*x^0*y^0*z^79 - 11935586799911826348*x^0*y^0*z^78 + 11842938124981636890*x^0*y^0*z^77 + 17925504431155643379*x^0*y^0*z^76 - 7908293658929055370*x^0*y^0*z^75 - 47270942142298030680*x^0*y^0*z^74 - 70444541926945767830*x^0*y^0*z^73 - 63645000888829747411*x^0*y^0*z^72 - 36017063254502941564*x^0*y^0*z^71 - 7369641733045668429*x^0*y^0*z^70 + 2384722762215370420*x^0*y^0*z^69 + 940415032638709485*x^0*y^0*z^68 - 1327453151688589476*x^0*y^0*z^67 + 2818883728041481731*x^0*y^0*z^66 + 12437257756560025840*x^0*y^0*z^65 + 20689981120046785440*x^0*y^0*z^64 + 21892574361261531400*x^0*y^0*z^63 + 16169548339101590804*x^0*y^0*z^62 + 7934641161285696096*x^0*y^0*z^61 + 1489029261749236473*x^0*y^0*z^60 - 142630813777821590*x^0*y^0*z^59 + 49013779737897810*x^0*y^0*z^58 - 265284623750856896*x^0*y^0*z^57 - 1963573182380479965*x^0*y^0*z^56 - 4164873921677061732*x^0*y^0*z^55 - 5350592049368532296*x^0*y^0*z^54 - 4818013803484490368*x^0*y^0*z^53 - 3139013115234392980*x^0*y^0*z^52 - 1403302569712091734*x^0*y^0*z^51 - 258915695931951759*x^0*y^0*z^50 - 35276261377456670*x^0*y^0*z^49 - 21282882529555185*x^0*y^0*z^48 + 153213224796566718*x^0*y^0*z^47 + 527665627317397332*x^0*y^0*z^46 + 881981274376715180*x^0*y^0*z^45 + 984047181953028515*x^0*y^0*z^44 + 795094658089491020*x^0*y^0*z^43 + 472076971449479873*x^0*y^0*z^42 + 198908883881274352*x^0*y^0*z^41 + 37270765080549573*x^0*y^0*z^40 + 11576023279154040*x^0*y^0*z^39 + 1246147628550099*x^0*y^0*z^38 - 35067803756475018*x^0*y^0*z^37 - 90035659897929326*x^0*y^0*z^36 - 130533706363423354*x^0*y^0*z^35 - 131947292442958450*x^0*y^0*z^34 - 98032146409803368*x^0*y^0*z^33 - 54083226303388275*x^0*y^0*z^32 - 22136460857318798*x^0*y^0*z^31 - 4110977642849268*x^0*y^0*z^30 - 1640193541129518*x^0*y^0*z^29 + 289863492942465*x^0*y^0*z^28 + 4764373976021662*x^0*y^0*z^27 + 10175465858766007*x^0*y^0*z^26 + 13325587774499534*x^0*y^0*z^25 + 12480999897275930*x^0*y^0*z^24 + 8650381693582750*x^0*y^0*z^23 + 4502849387394895*x^0*y^0*z^22 + 1842680715539360*x^0*y^0*z^21 + 303370748925840*x^0*y^0*z^20 + 124210348865940*x^0*y^0*z^19 - 56351096480659*x^0*y^0*z^18 - 378210317960404*x^0*y^0*z^17 - 706933905952328*x^0*y^0*z^16 - 857030542392210*x^0*y^0*z^15 - 754919771954015*x^0*y^0*z^14 - 492957649564478*x^0*y^0*z^13 - 245876354418193*x^0*y^0*z^12 - 103089432023292*x^0*y^0*z^11 - 11064289439586*x^0*y^0*z^10 - 4049660803852*x^0*y^0*z^9 + 3154226640202*x^0*y^0*z^8 + 13723489975200*x^0*y^0*z^7 + 23199016772901*x^0*y^0*z^6 + 26521256768988*x^0*y^0*z^5 + 22211189372392*x^0*y^0*z^4 + 13772493253240*x^0*y^0*z^3 + 6701498456596*x^0*y^0*z^2 + 2917351310048*x^0*y^0*z^1";
	const char* curVars[] = {"x", "y", "z"};
    AltArrZ_t* aa = generate_altarrZ_var_defined(fstr.c_str(), curVars, 3);
	int varMap[3];
	tryShrinkVariables_AAZ_inp(aa, varMap);

	f = convertFromAltArrZ_DUZP(aa);
	printPoly_DUZP(f,xvar);

	/// NTL Test ///

	NTL::ZZX ff;
	NTLZZX_set_DUZP_t(ff,f);
	std::cerr << "NTL FF: " << ff << std::endl;
	NTL::ZZ c;
	NTL::vec_pair_ZZX_long factors;

	_startTimer(&start);

//	factor_data_t fd;

	factor(c, factors, ff, 1, 0);

//	factor(c, factors, ff, 1, 0, fd);

	_stopTimer(&start,&elapsed);

	if (!showOutput) {
		std::cout.rdbuf(oldcout);   // <-- restore
		std::cerr.rdbuf(oldcerr);   // <-- restore
		fflush(stdout);
		dup2(bakfs1, 1);
		fflush(stderr);
		dup2(bakfs2, 2);
	}

	fprintf(stderr,"NTL time: %f\n",elapsed);

	if (!showOutput) {
		std::cout.rdbuf(fs.rdbuf());
		std::cerr.rdbuf(fs.rdbuf());
		fflush(stdout);
		dup2(newfs1, 1);
		fflush(stderr);
		dup2(newfs2, 2);
	}

	DUZP_t* g = makeConstPolynomial_DUZP(1,0);
	for (int i=1; i<=factors.length(); ++i) {
		DUZP_t_set_NTLZZX(&g,factors(i).a);
		printPoly_DUZP(g,xvar);
	}

	freePolynomial_DUZP(g);

	/// BPAS Test ///

	mpz_t cc;
	mpz_init(cc);
	vec_DUZP_long_t factors2;
	vec_DUZP_long_t_init2(&factors2,0);

	fprintf(stderr,"calling BPAS factor:\n");

	_startTimer(&start);

	factor(&cc,&factors2,f);

	_stopTimer(&start,&elapsed);

	if (!showOutput) {
		std::cout.rdbuf(oldcout);   // <-- restore
		std::cerr.rdbuf(oldcerr);   // <-- restore
		fflush(stdout);
		dup2(bakfs1, 1);
		fflush(stderr);
		dup2(bakfs2, 2);
//		close(bakfs);
	}
	fprintf(stderr,"BPAS time: %f\n",elapsed);

	if (!showOutput) {
		std::cout.rdbuf(fs.rdbuf());
		std::cerr.rdbuf(fs.rdbuf());
		fflush(stdout);
		dup2(newfs1, 1);
		fflush(stderr);
		dup2(newfs2, 2);
		close(newfs1);
		close(newfs2);
	}

	g = makeConstPolynomial_DUZP(1,1);
	DUZP_t* h;
	for (int i=0; i<factors2.size; ++i) {
		h = makeConstPolynomial_DUZP(1,1);
		fprintf(stderr,"exp = %ld\n",factors2.pairs[i].b);
		for (int j=0; j<factors2.pairs[i].b; ++j)
			multiplyPolynomials_DUZP_inp(factors2.pairs[i].a,&h);
		multiplyPolynomials_DUZP_inp(h,&g);
		printPoly_DUZP(h,xvar);
		freePolynomial_DUZP(h);
	}
	multiplyByInteger_DUZP_inp(g,cc);

	fprintf(stderr,"g = ");
	printPoly_DUZP(g,xvar);
	fprintf(stderr,"f = ");
	printPoly_DUZP(f,xvar);
	g = subtractPolynomials_DUZP(f,g);
	fprintf(stderr,"f - g = ");
	printPoly_DUZP(g,xvar);

	/// MAPLE Test ///


    MapleTestTool* mapleTest = MapleTestTool::getMapleTestTool();
    mapleTest->restartMapleKernel();
    MKernelVector kv = mapleTest->getMKernelVector();

	if (!showOutput) {
		std::cout.rdbuf(oldcout);   // <-- restore
		std::cerr.rdbuf(oldcerr);   // <-- restore
		fflush(stdout);
		dup2(bakfs1, 1);
		fflush(stderr);
		dup2(bakfs2, 2);
//		close(bakfs);
	}

	fflush(stderr);
	bakfs2 = dup(2);
	dup2(newfs2, 2);

	FILE* fp2 = fopen("duz_tst_tmp_OUT","w");
	if (fp2 == NULL) {
		fprintf(stderr, "\n\nCOULD NOT OPEN FILE FOR WRITING\n\n");
		exit(1);
	}
	//FILE* fp;
	// int fp2 = open("./duz_tst_tmp_OUT", O_RDWR | O_CREAT | O_TRUNC, 0600);
//	if((fp=freopen("/home/rmoir2/BPAS/Main.new/tests/IntegerPolynomial/OUT", "w" ,stderr))==NULL) {
//		printf("Cannot open file.\n");
//		exit(1);
//	}
	// fflush(stderr);
	// bakfs2 = dup(2);
	// dup2(fp2, 2);

	printPolyToFile_DUZP(fp2,f,xvar);

	fclose(fp2);

	fflush(stderr);
	dup2(bakfs2, 2);

	if (!showOutput) {
		std::cout.rdbuf(fs.rdbuf());
		std::cerr.rdbuf(fs.rdbuf());
		fflush(stdout);
		dup2(newfs1, 1);
		fflush(stderr);
		dup2(newfs2, 2);
	}

	std::ifstream file("duz_tst_tmp_OUT");
	if (!file) {
		std::cout << "unable to open file";
		exit(1);
	}

	std::string s;
	std::getline(file, s);
	file.close();

	std::cout << "this is a test" << std::endl;

	s += ":";

	std::cout << s << std::endl;

	fprintf(stderr,"STDERR is working again...\n");

    char* cstr;
    std::string evalStr;
    evalStr = "kernelopts(numcpus=1);";
    cstr = new char[evalStr.length()+1];
    std::strcpy (cstr, evalStr.c_str());
    EvalMapleStatement(kv, cstr);
    delete[] cstr;

    cstr = new char[s.length()+1];
    std::strcpy(cstr, s.c_str());
    ALGEB res = EvalMapleStatement(kv, cstr);
    delete[] cstr;

	std::string procStr = "factorTest := proc (f::polynom) local a; a := factors(f); end proc:";

    cstr = new char[procStr.length()+1];
    std::strcpy (cstr, procStr.c_str());
    ALGEB testProc = EvalMapleStatement(kv, cstr);
    delete[] cstr;


	if (!showOutput) {
		std::cout.rdbuf(oldcout);   // <-- restore
		std::cerr.rdbuf(oldcerr);   // <-- restore
		fflush(stdout);
		dup2(bakfs1, 1);
		fflush(stderr);
		dup2(bakfs2, 2);
	}

	_startTimer(&start);

//	fprintf(stderr,"computing factorization in Maple...\n");

    ALGEB result = EvalMapleProc(kv, testProc, 1, res);

	_stopTimer(&start,&elapsed);

	fprintf(stderr,"Maple time: %f\n",elapsed);

	if (!showOutput) {
		std::cout.rdbuf(fs.rdbuf());
		std::cerr.rdbuf(fs.rdbuf());
		fflush(stdout);
		dup2(newfs1, 1);
		fflush(stderr);
		dup2(newfs2, 2);
		close(newfs1);
		close(newfs2);
	}


//	print_factor_data(fd);

	mpz_clear(cc);
	freePolynomial_DUZP(f);
	freePolynomial_DUZP(g);
	vec_DUZP_long_t_free(&factors2);

	if (!showOutput) {
		std::cout.rdbuf(oldcout);   // <-- restore
		std::cerr.rdbuf(oldcerr);   // <-- restore

		fflush(stdout);
		dup2(bakfs1, 1);
		fflush(stderr);
		dup2(bakfs2, 2);
//		close(bakfs1);
//		close(bakfs2);
	}

}

void make_Recombine_input(int* sizes, int r, long_t p, DUZP_t** f, vec_DUZP_t* padicFactors, mpz_t* P, int* e, long_t* bound) {


	mpz_t one;
	mpz_init(one);
	mpz_set_ui(one,1);
	DUZP_t* tmp;

	Prime_ptr* Pptr = smallprimefield_get_prime_constants(pr);
	duspoly_t* modf;
	factsll_t* modularFactorsll = initFactsll_spX(1);
	factors_t* modularFactors;

	int allOne = 0;
	long n;

	while (!allOne) {
		*f = makeConstPolynomial_DUZP(1,1);
		fprintf(stderr,"start build f for loop\n");
		for (int i=0; i<r; ++i) {
			tmp = buildRandomPoly_DUZP(sizes[i],coefBoundBits,sparsity,includeNeg);
			mpz_set(tmp->coefs[tmp->lt],one);
			printPoly_DUZP(tmp,xvar);
			*f = multiplyPolynomials_DUZP(*f,tmp);
		}
		printPoly_DUZP(*f,xvar);

		modf = convertToDUSP_DUZP(*f,Pptr);
		modularFactorsll = initFactsll_spX(1);
		modFactorizationInFormll1_spX(modf, &modularFactorsll, Pptr);

		modularFactors = convertToFactorsList_spX(modularFactorsll,Pptr);
		n = modularFactors->alloc;
		allOne = 1;
		fprintf(stderr,"start print modular factors loop\n");
		for (int i=0; i<n; ++i) {
//			printPolynomialOutForm_spX(modularFactors->polys[i],Pptr);
			fprintf(stderr,"exp = %ld\n",modularFactors->exps[i]);
			if (modularFactors->exps[i] > 1) {
				allOne = 0;
				freePolynomial_DUZP(*f);
				break;
			}
		}
	}
	DUZP_t** liftedModularFactors = (DUZP_t**) malloc(sizeof(DUZP_t*)*n);

	fprintf(stderr,"check1\n");
//	*e = multiTermPadicLiftOpt_Iterative(*f, (const duspoly_t**) modularFactors->polys, liftedModularFactors, n, Pptr);
	*e = multiTermPadicLiftOpt_Iterative(*f, CONSTCONSTCAST(duspoly_t,modularFactors->polys), liftedModularFactors, n, Pptr);

	fprintf(stderr,"check2\n");
	for (int i=0; i<n; ++i) {
		printPoly_DUZP(liftedModularFactors[i],xvar);
	}

	long* idxs = (long*) malloc(sizeof(long)*n);
	for (int i=0; i<n; ++i) {
		idxs[i] = i;
	}

	mpz_t pp;
	mpz_init_set_ui(pp,p);
	mpz_pow_ui(*P,pp,*e);
	DUZP_t* g;
	ComputePotentialFactorRational(&g, liftedModularFactors, idxs, n, *P);

	printPoly_DUZP(g,xvar);

	*bound = LandauMignotteBoundInBits(*f,n-1);
	fprintf(stderr,"log2(LM_Bound) = %Ld\n",*bound);

	vec_DUZP_t_free(padicFactors);
	vec_DUZP_t_init_set(padicFactors,n);
	padicFactors->polys = liftedModularFactors;
	padicFactors->alloc = n;
	padicFactors->size = n;

	mpz_clear(one);
	mpz_clear(pp);
	free(idxs);
//	free(liftedModularFactors);

}

//void recombine_test() {

//	mpz_t one;
//	mpz_init(one);
//	mpz_set_ui(one,1);
//	DUZP_t* f; // random polynomial to factor
////	DUZP_t* tmp;
//
//	Prime_ptr* Pptr = smallprimefield_get_prime_constants(pr);
//	duspoly_t* modf;
////	factsll_t* modularFactorsll; // = initFactsll_spX(1);
//	factors_t* modularFactors;
//
//	int r = 5; // minimum number of rational factors
//	int sizes[5] = {2,3,4,5,6}; // sizes of factors
//
//	int allOne = 0;
//	long n;
//
//	f = makeExamplePolynomial(sizes,r);
//
////	while (!allOne) {
////		f = makeConstPolynomial_DUZP(1,1);
////		fprintf(stderr,"start build f for loop\n");
////		for (int i=0; i<r; ++i) {
////			tmp = buildRandomPoly_DUZP(sizes[i],coefBoundBits,sparsity,includeNeg);
////			mpz_set(tmp->coefs[tmp->lt],one);
////			printPoly_DUZP(tmp,xvar);
////			multiplyPolynomials_DUZP_inp(tmp,&f);
////			freePolynomial_DUZP(tmp);
////		}
//////		printPoly_DUZP(f,xvar);
//////		return;
////
////		modf = convertToDUSP_DUZP(f,Pptr);
//////		modularFactorsll = initFactsll_spX(1);
////		modFactorizationInFormll1_spX(modf, &modularFactorsll, Pptr);
////
////		modularFactors = convertToFactorsList_spX(modularFactorsll,Pptr);
////		freeFactsll_spX(&modularFactorsll);
////		n = modularFactors->alloc;
////		allOne = 1;
////		fprintf(stderr,"start print modular factors loop\n");
////		for (int i=0; i<n; ++i) {
//////			printPolynomialOutForm_spX(modularFactors->polys[i],Pptr);
////			fprintf(stderr,"exp = %ld\n",modularFactors->exps[i]);
////			if (modularFactors->exps[i] > 1) {
////				allOne = 0;
////				freePolynomial_DUZP(f);
////				freePolynomial_spX(&modf);
////				freeFactors_spX(&modularFactors);
////				break;
////			}
////		}
////	}
////	printPoly_DUZP(f,xvar);
////	return;

//	factoring_info_t fi;
//	factoring_info_t_init(&fi);
//	SmallPrimeFactorize(&modularFactors,&fi,f);
//	n = modularFactors->alloc;

//	DUZP_t** liftedModularFactors = (DUZP_t**) malloc(sizeof(DUZP_t*)*n);
//	duspoly_t ** sigmas;
//	long bnd = LandauMignotteBoundInBits(f,f->lt);
////	long bnd = 6;
//	mpz_t bound;
//	mpz_init_set_ui(bound,1);
//	mpz_mul_2exp(bound,bound,bnd);
//	gmp_fprintf(stderr,"bound = %Zd\n",bound);
//
//	fprintf(stderr,"check1\n");
////	int e = multiTermPadicLiftOpt_Iterative(f, (const duspoly_t**) modularFactors->polys, liftedModularFactors, n, Pptr);
////	int e = multiTermPadicLiftOpt_Iterative(f, CONSTCONSTCAST(duspoly_t,modularFactors->polys), &liftedModularFactors, n, Pptr);

//	int e = multiTermPadicLiftStart(f, CONSTCONSTCAST(duspoly_t,modularFactors->polys), liftedModularFactors, &sigmas, n, bound, fi.Pptr);

//	fprintf(stderr,"check2\n");
//	for (int i=0; i<n; ++i) {
//		printPoly_DUZP(liftedModularFactors[i],xvar);
//	}
//
//	long* idxs = (long*) malloc(sizeof(long)*n);
//	for (int i=0; i<n; ++i) {
//		idxs[i] = i;
//	}
////
//	mpz_t P,p;
//	mpz_init(P);
//	mpz_init(p);
//	mpz_set_si(p,11);
//	mpz_pow_ui(P,p,e);
////	DUZP_t* g;
////	ComputePotentialFactorRational(&g, liftedModularFactors, idxs, n, P);
////
////	printPoly_DUZP(g,xvar);
////
//	vec_DUZP_t padicFactors;
//	vec_DUZP_t_init2(&padicFactors,n);
//	for (int i=0; i<n; ++i)
//		vec_DUZP_t_push(&padicFactors,liftedModularFactors[i]);
////	padicFactors.polys = liftedModularFactors;
////	padicFactors.alloc = n;
////	padicFactors.size = n;
////
//	vec_DUZP_t rationalFactors;
//	vec_DUZP_t_init(&rationalFactors);
////	rationalFactors.polys = (DUZP_t**) malloc(sizeof(DUZP_t*));
////	rationalFactors.alloc = 1;
////	rationalFactors.size = 0;
////
//	DUZP_t* sigmas2;
////
//	Recombine(&rationalFactors,f,&padicFactors,&sigmas2,P,11,e,mpz_sizeinbase(P,2),modularFactors,sigmas);
////
////	fprintf(stderr,"\n%ld rationalFactors:\n",rationalFactors.size);
////	for (int i=0; i<rationalFactors.size; ++i) {
////		printPoly_DUZP(rationalFactors.polys[i],xvar);
////	}
//////	fprintf(stderr,"alloc = %ld:\n",rationalFactors.alloc);
//////	fprintf(stderr,"size = %ld:\n",rationalFactors.size);
////	fprintf(stderr,"\n%ld padicFactors:\n",padicFactors.size);
////	for (int i=0; i<padicFactors.size; ++i) {
////		printPoly_DUZP(padicFactors.polys[i],xvar);
////	}

//	factoring_info_t_free(&fi);
//	vec_DUZP_t_free(&rationalFactors);
//	vec_DUZP_t_free(&padicFactors);
//	for (int i=0; i<n; ++i)
//		freePolynomial_DUZP(liftedModularFactors[i]);
//	free(liftedModularFactors);
//	for (int i=0; i<n; ++i) {
//		freePolynomial_spX(&sigmas[i]);
//	}
//	free(sigmas);
//	free(sigmas2);
//	freeFactors_spX(&modularFactors);
//	freePolynomial_DUZP(f);
//	freePolynomial_spX(&modf);
//	free(idxs);
//	mpz_clear(one);
//	mpz_clear(bound);
//	mpz_clear(P);
//	mpz_clear(p);
//	free(Pptr);

//}

void vec_mpz_test() {

	int size = 10;
	vec_mpz_t a;
	vec_mpz_t_init2(&a,size);
	fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);

	mpz_t n;
	mpz_init(n);

	for (int i=0; i<size+1; ++i) {
		mpz_set_ui(n,i+1);
		vec_mpz_t_push(&a,n);
		fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);
	}

	print_vec_mpz(a);
	fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);

	for (int i=0; i<size+1; ++i) {
		vec_mpz_t_pop(&n,&a);
		gmp_fprintf(stderr,"n = %Zd, alloc=%ld, size=%ld\n",n,a.alloc,a.size);
	}

	print_vec_mpz(a);
	fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);

	mpz_clear(n);
	vec_mpz_t_free(&a);

}

void vec_DUZP_test() {

	int alloc = 10;
	vec_DUZP_t a;
	vec_DUZP_t_init2(&a,alloc);
	fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);

	DUZP_t* f;

	for (int i=0; i<alloc+1; ++i) {
		f = buildRandomPoly_DUZP(5,coefBoundBits,sparsity,includeNeg);
		vec_DUZP_t_push(&a,f);
		freePolynomial_DUZP(f);
		fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);
	}

	print_vec_DUZP(a);
	fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);

	for (int i=0; i<alloc+1; ++i) {
		f = vec_DUZP_t_pop(&a);
		printPoly_DUZP(f,xvar);
		freePolynomial_DUZP(f);
		fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);
	}

	print_vec_DUZP(a);
	fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);

	vec_DUZP_t_free(&a);

}

void vec_duspoly_test() {

	int alloc = 11;
	vec_duspoly_t a;
	Prime_ptr* Pptr = smallprimefield_get_prime_constants(11);
	vec_duspoly_t_init2(&a,Pptr,alloc);
	fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);

//	duspoly_t* f;
//
//	for (int i=0; i<alloc+1; ++i) {
//		f = binPolynomialInForm_spX(i+1,a.ptr);
//		vec_duspoly_t_push(&a,f);
//		freePolynomial_spX(f);
//		fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);
//	}
//
//	print_vec_duspoly(a);
//	fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);
//
//	for (int i=0; i<alloc+1; ++i) {
//		f = vec_duspoly_t_pop(&a);
//		printPolynomialOutForm_spX(f,a.ptr);
//		freePolynomial_spX(f);
//		fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);
//	}
//
//	print_vec_duspoly(a);
//	fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);

	vec_duspoly_t_free(&a);

}

void vec_DUZP_long_test() {

//	DUZP_t* f = buildRandomPoly_DUZP(5,coefBoundBits,sparsity,includeNeg);
//	printPoly_DUZP(f,xvar);
//	differentiate_DUZP_inp(&f);
//	printPoly_DUZP(f,xvar);
//	DUZP_t* df = differentiate_DUZP(f);
//	printPoly_DUZP(df,xvar);
//	freePolynomial_DUZP(df);
//	freePolynomial_DUZP(f);

	int alloc = 10;
	vec_DUZP_long_t a;
	vec_DUZP_long_t_init2(&a,alloc);
	fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);

	DUZP_t* f;
	DUZP_long_t tmp;

	for (int i=0; i<alloc+1; ++i) {
		f = buildRandomPoly_DUZP(5,coefBoundBits,sparsity,includeNeg);
		tmp.a = f;
		tmp.b = i+1;
		vec_DUZP_long_t_push(&a,tmp);
		freePolynomial_DUZP(f);
		fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);
	}

	print_vec_DUZP_long(a);
	fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);

	DUZP_t* tmp2;

	for (int i=0; i<alloc-1; ++i) {
		tmp = vec_DUZP_long_t_pop(&a);
		printPoly_DUZP(tmp.a,xvar);
		differentiate_DUZP_inp(&tmp.a);
		printPoly_DUZP(tmp.a,xvar);
		tmp2 = differentiate_DUZP(tmp.a);
		printPoly_DUZP(tmp2,xvar);
		freePolynomial_DUZP(tmp.a);
		freePolynomial_DUZP(tmp2);
		fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);
	}

	print_vec_DUZP_long(a);
	fprintf(stderr,"alloc=%ld, size=%ld\n",a.alloc,a.size);

	vec_DUZP_long_t_free(&a);

}

void vec_vec_test() {

	int length = 10;
	int depth = 2;
	vec_vec_mpz_t vec;
	vec_vec_mpz_t_init(&vec,length);
	fprintf(stderr,"one\n");
	vec_vec_mpz_t_set(&vec,length,depth);
	fprintf(stderr,"two\n");

	mpz_t t;
	mpz_init(t);

	// filling the array
	for (int i=0; i<vec.length; ++i)
		for (int j=0; j<vec.depth; ++j) {
			mpz_add_ui(t,t,1);
//			fprintf(stderr,"i=%d, j=%d\n",i,j);
			mpz_set(vec.array[i][j],t);
		}
	print_vec_vec(&vec);

	// decrease the depth
	vec_vec_mpz_t_set(&vec,length,depth-1);
	print_vec_vec(&vec);

	// increase the depth
	vec_vec_mpz_t_set(&vec,length,depth+1);

	// filling the array
	for (int i=0; i<vec.length; ++i)
		for (int j=depth-1; j<vec.depth; ++j) {
			mpz_add_ui(t,t,1);
//			fprintf(stderr,"i=%d, j=%d\n",i,j);
			mpz_set(vec.array[i][j],t);
		}
	print_vec_vec(&vec);

	// decrease depth and length
	vec_vec_mpz_t_set(&vec,length-5,depth);
	print_vec_vec(&vec);

	// increase depth and length
	vec_vec_mpz_t_set(&vec,length,depth+2);

	// filling the array
	for (int i=0; i<length-5; ++i)
		for (int j=depth; j<vec.depth; ++j) {
			mpz_add_ui(t,t,1);
//			fprintf(stderr,"i=%d, j=%d\n",i,j);
			mpz_set(vec.array[i][j],t);
		}
	for (int i=length-5; i<vec.length; ++i)
		for (int j=0; j<vec.depth; ++j) {
			mpz_add_ui(t,t,1);
//			fprintf(stderr,"i=%d, j=%d\n",i,j);
			mpz_set(vec.array[i][j],t);
		}
	print_vec_vec(&vec);

	vec_vec_mpz_t_free(&vec);
	mpz_clear(t);
}

void naive_search_test() {

	mpz_t one;
	mpz_init(one);
	mpz_set_ui(one,1);
	DUZP_t* f; // random polynomial to factor
	DUZP_t* tmp;

	Prime_ptr* Pptr = smallprimefield_get_prime_constants(pr);
	duspoly_t* modf;
	factsll_t* modularFactorsll = initFactsll_spX(1);
	factors_t* modularFactors;

	int r = 3; // minimum number of rational factors
	int sizes[3] = {2,3,4}; // sizes of factors

	int allOne = 0;
	long n;

	while (!allOne) {
		f = makeConstPolynomial_DUZP(1,1);
		fprintf(stderr,"start build f for loop\n");
		for (int i=0; i<r; ++i) {
			tmp = buildRandomPoly_DUZP(sizes[i],coefBoundBits,sparsity,includeNeg);
			mpz_set(tmp->coefs[tmp->lt],one);
			printPoly_DUZP(tmp,xvar);
			f = multiplyPolynomials_DUZP(f,tmp);
		}
		printPoly_DUZP(f,xvar);

		modf = convertToDUSP_DUZP(f,Pptr);
		modularFactorsll = initFactsll_spX(1);
		modFactorizationInFormll1_spX(modf, &modularFactorsll, Pptr);


		modularFactors = convertToFactorsList_spX(modularFactorsll,Pptr);
		n = modularFactors->alloc;
		allOne = 1;
		fprintf(stderr,"start print modular factors loop\n");
		for (int i=0; i<n; ++i) {
//			printPolynomialOutForm_spX(modularFactors->polys[i],Pptr);
			fprintf(stderr,"exp = %ld\n",modularFactors->exps[i]);
			if (modularFactors->exps[i] > 1) {
				allOne = 0;
				freePolynomial_DUZP(f);
				break;
			}
		}
	}
	DUZP_t** liftedModularFactors = (DUZP_t**) malloc(sizeof(DUZP_t*)*n);

	fprintf(stderr,"check1\n");
//	int e = multiTermPadicLiftOpt_Iterative(f, (const duspoly_t**) modularFactors->polys, liftedModularFactors, n, Pptr);
	int e = multiTermPadicLiftOpt_Iterative(f, CONSTCONSTCAST(duspoly_t,modularFactors->polys), liftedModularFactors, n, Pptr);

	fprintf(stderr,"check2\n");
	for (int i=0; i<n; ++i) {
		printPoly_DUZP(liftedModularFactors[i],xvar);
	}

	long* idxs = (long*) malloc(sizeof(long)*n);
	for (int i=0; i<n; ++i) {
		idxs[i] = i;
	}

	mpz_t P,p;
	mpz_init(P);
	mpz_init(p);
	mpz_set_si(p,11);
	mpz_pow_ui(P,p,e);
	DUZP_t* g;
	ComputePotentialFactorRational(&g, liftedModularFactors, idxs, n, P);

	printPoly_DUZP(g,xvar);

	long_t bound = LandauMignotteBoundInBits(f,n-1);
	fprintf(stderr,"log2(LM_Bound) = %Ld\n",bound);

	vec_DUZP_t padicFactors;
	padicFactors.polys = liftedModularFactors;
	padicFactors.alloc = n;
	padicFactors.size = n;

	vec_DUZP_t rationalFactors;
	rationalFactors.polys = (DUZP_t**) malloc(sizeof(DUZP_t*));
	rationalFactors.alloc = 1;
	rationalFactors.size = 0;

	NaiveFactorSearch(&f,&rationalFactors,&padicFactors,P,11,e,1,mpz_sizeinbase(P,2));
	fprintf(stderr,"f:\n");
	printPoly_DUZP(f,xvar);
	if (padicFactors.size >= 2)
		NaiveFactorSearch(&f,&rationalFactors,&padicFactors,P,11,e,2,mpz_sizeinbase(P,2));
	if (padicFactors.size >= 3)
		NaiveFactorSearch(&f,&rationalFactors,&padicFactors,P,11,e,3,mpz_sizeinbase(P,2));

	// Current issues to fix:
	//   - degree six factor found

	fprintf(stderr,"\n%ld rationalFactors:\n",rationalFactors.size);
	for (int i=0; i<rationalFactors.size; ++i) {
		printPoly_DUZP(rationalFactors.polys[i],xvar);
	}
//	fprintf(stderr,"alloc = %ld:\n",rationalFactors.alloc);
//	fprintf(stderr,"size = %ld:\n",rationalFactors.size);
	fprintf(stderr,"\n%ld padicFactors:\n",padicFactors.size);
	for (int i=0; i<padicFactors.size; ++i) {
		printPoly_DUZP(padicFactors.polys[i],xvar);
	}
//	free(f);
//	free(liftedModularFactors);

}
