#include <bpas.h>
#include "../../../include/FFT/src/dft_fermat_inverse_16.h"
//! 16 Point inverse FFT Generalized Fermat Prime Field 

/*!
 \param a coefficient vector
*/
GeneralizedFermatPrimeField* dft_fermat_inverse_16(GeneralizedFermatPrimeField* a){
  // temp array
  GeneralizedFermatPrimeField b[16];
  // step 1, B=L_{2}^{16}
  b[0]=a[0];
  b[1]=a[2];
  b[2]=a[4];
  b[3]=a[6];
  b[4]=a[8];
  b[5]=a[10];
  b[6]=a[12];
  b[7]=a[14];
  b[8]=a[1];
  b[9]=a[3];
  b[10]=a[5];
  b[11]=a[7];
  b[12]=a[9];
  b[13]=a[11];
  b[14]=a[13];
  b[15]=a[15];

  // step 2, A=I_{2} t* L_{2}^{8}
  a[0]=b[0];
  a[1]=b[2];
  a[2]=b[4];
  a[3]=b[6];
  a[4]=b[1];
  a[5]=b[3];
  a[6]=b[5];
  a[7]=b[7];

  a[8]=b[8];
  a[9]=b[10];
  a[10]=b[12];
  a[11]=b[14];
  a[12]=b[9];
  a[13]=b[11];
  a[14]=b[13];
  a[15]=b[15];

  // step 3, B= I_{4} T* L_{2}^{4}
  b[0]=a[0];
  b[1]=a[2];
  b[2]=a[1];
  b[3]=a[3];

  b[4]=a[4];
  b[5]=a[6];
  b[6]=a[5];
  b[7]=a[7];

  b[8]=a[8];
  b[9]=a[10];
  b[10]=a[9];
  b[11]=a[11];

  b[12]=a[12];
  b[13]=a[14];
  b[14]=a[13];
  b[15]=a[15];

  // step 4, A = I_{8} T* DFT_{2} B
  a[0]=b[0]+b[1];
  a[1]=b[0]-b[1];
  a[2]=b[2]+b[3];
  a[3]=b[2]-b[3];
  a[4]=b[4]+b[5];
  a[5]=b[4]-b[5];
  a[6]=b[6]+b[7];
  a[7]=b[6]-b[7];
  a[8]=b[8]+b[9];
  a[9]=b[8]-b[9];
  a[10]=b[10]+b[11];
  a[11]=b[10]-b[11];
  a[12]=b[12]+b[13];
  a[13]=b[12]-b[13];
  a[14]=b[14]+b[15];
  a[15]=b[14]-b[15];

  //step 5, B= T_{2}^{4} T* A
  b[0]=a[0];
  b[1]=a[1];
  b[2]=a[2];
  b[3]=a[3].MulPowR(12);
  b[4]=a[4];
  b[5]=a[5];
  b[6]=a[6];
  b[7]=a[7].MulPowR(12);
  b[8]=a[8];
  b[9]=a[9];
  b[10]=a[10];
  b[11]=a[11].MulPowR(12);
  b[12]=a[12];
  b[13]=a[13];
  b[14]=a[14];
  b[15]=a[15].MulPowR(12);
  // step 6, A= I_{4} T* L_2^4 B
  a[0]=b[0];
  a[1]=b[2];
  a[2]=b[1];
  a[3]=b[3];
  a[4]=b[4];
  a[5]=b[6];
  a[6]=b[5];
  a[7]=b[7];
  a[8]=b[8];
  a[9]=b[10];
  a[10]=b[9];
  a[11]=b[11];
  a[12]=b[12];
  a[13]=b[14];
  a[14]=b[13];
  a[15]=b[15];

  b[0]=a[0]+a[1];
  b[1]=a[0]-a[1];
  b[2]=a[2]+a[3];
  b[3]=a[2]-a[3];
  b[4]=a[4]+a[5];
  b[5]=a[4]-a[5];
  b[6]=a[6]+a[7];
  b[7]=a[6]-a[7];
  b[8]=a[8]+a[9];
  b[9]=a[8]-a[9];
  b[10]=a[10]+a[11];
  b[11]=a[10]-a[11];
  b[12]=a[12]+a[13];
  b[13]=a[12]-a[13];
  b[14]=a[14]+a[15];
  b[15]=a[14]-a[15];

  a[0]=b[0];
  a[1]=b[2];
  a[2]=b[1];
  a[3]=b[3];
  a[4]=b[4];
  a[5]=b[6];
  a[6]=b[5];
  a[7]=b[7];
  a[8]=b[8];
  a[9]=b[10];
  a[10]=b[9];
  a[11]=b[11];
  a[12]=b[12];
  a[13]=b[14];
  a[14]=b[13];
  a[15]=b[15];

  b[0]=a[0];
  b[1]=a[1];
  b[2]=a[2];
  b[3]=a[3];
  b[4]=a[4];
  b[5]=a[5].MulPowR(14);
  b[6]=a[6].MulPowR(12);
  b[7]=a[7].MulPowR(10);
  b[8]=a[8];
  b[9]=a[9];
  b[10]=a[10];
  b[11]=a[11];
  b[12]=a[12];
  b[13]=a[13].MulPowR(14);
  b[14]=a[14].MulPowR(12);
  b[15]=a[15].MulPowR(10);

  a[0]=b[0];
  a[1]=b[4];
  a[2]=b[1];
  a[3]=b[5];
  a[4]=b[2];
  a[5]=b[6];
  a[6]=b[3];
  a[7]=b[7];
  a[8]=b[8];
  a[9]=b[12];
  a[10]=b[9];
  a[11]=b[13];
  a[12]=b[10];
  a[13]=b[14];
  a[14]=b[11];
  a[15]=b[15];

  b[0]=a[0]+a[1];
  b[1]=a[0]-a[1];
  b[2]=a[2]+a[3];
  b[3]=a[2]-a[3];
  b[4]=a[4]+a[5];
  b[5]=a[4]-a[5];
  b[6]=a[6]+a[7];
  b[7]=a[6]-a[7];
  b[8]=a[8]+a[9];
  b[9]=a[8]-a[9];
  b[10]=a[10]+a[11];
  b[11]=a[10]-a[11];
  b[12]=a[12]+a[13];
  b[13]=a[12]-a[13];
  b[14]=a[14]+a[15];
  b[15]=a[14]-a[15];

  a[0]=b[0];
  a[1]=b[2];
  a[2]=b[4];
  a[3]=b[6];
  a[4]=b[1];
  a[5]=b[3];
  a[6]=b[5];
  a[7]=b[7];

  a[8]=b[8];
  a[9]=b[10];
  a[10]=b[12];
  a[11]=b[14];
  a[12]=b[9];
  a[13]=b[11];
  a[14]=b[13];
  a[15]=b[15];

  b[0]=a[0];
  b[1]=a[1];
  b[2]=a[2];
  b[3]=a[3];
  b[4]=a[4];
  b[5]=a[5];
  b[6]=a[6];
  b[7]=a[7];
  b[8]=a[8];

  b[9]=a[9].MulPowR(15);
  b[10]=a[10].MulPowR(14);
  b[11]=a[11].MulPowR(13);
  b[12]=a[12].MulPowR(12);
  b[13]=a[13].MulPowR(11);
  b[14]=a[14].MulPowR(10);
  b[15]=a[15].MulPowR(9);

  a[0]=b[0];
  a[1]=b[8];
  a[2]=b[1];
  a[3]=b[9];
  a[4]=b[2];
  a[5]=b[10];
  a[6]=b[3];
  a[7]=b[11];
  a[8]=b[4];
  a[9]=b[12];
  a[10]=b[5];
  a[11]=b[13];
  a[12]=b[6];
  a[13]=b[14];
  a[14]=b[7];
  a[15]=b[15];

  b[0]=a[0]+a[1];
  b[1]=a[0]-a[1];
  b[2]=a[2]+a[3];
  b[3]=a[2]-a[3];
  b[4]=a[4]+a[5];
  b[5]=a[4]-a[5];
  b[6]=a[6]+a[7];
  b[7]=a[6]-a[7];
  b[8]=a[8]+a[9];
  b[9]=a[8]-a[9];
  b[10]=a[10]+a[11];
  b[11]=a[10]-a[11];
  b[12]=a[12]+a[13];
  b[13]=a[12]-a[13];
  b[14]=a[14]+a[15];
  b[15]=a[14]-a[15];

  a[0]=b[0];
  a[1]=b[2];
  a[2]=b[4];
  a[3]=b[6];
  a[4]=b[8];
  a[5]=b[10];
  a[6]=b[12];
  a[7]=b[14];
  a[8]=b[1];
  a[9]=b[3];
  a[10]=b[5];
  a[11]=b[7];
  a[12]=b[9];
  a[13]=b[11];
  a[14]=b[13];
  a[15]=b[15];

  return a;
}
