
#ifndef _EXP_PACKING_DEFS_H_
#define _EXP_PACKING_DEFS_H_

typedef int degree_t;

typedef long long unsigned int degrees_t; 

typedef int cmpExp_t;


/**
 * Get the nth exponent from a packed exponent vector, given the mask
 * and offset for that exponent.
 */
#define GET_NTH_EXP(A, M, O) ( ((A) & (M)) >> (O))

/**
 * Compare two exponent vectors for lexicographical term order.
 * a: int array representing exponent vector
 * b: int array representing exponent vector
 * returns negative int if a < b, 0 if equal, a positive int if a > b
 */
// #define compareExponentVectors(A, B) ((A) - (B))
#define compareExponentVectors(A, B) ((A) < (B) ? -1 : ((A) > (B) ? 1 : 0) )

#define isLessExponentVectors(A, B) ((A) < (B))

#define isEqualExponentVectors(A, B) ((A) == (B))

#define isGreaterExponentVectors(A, B) ((A) > (B))

/**
 * Check if an exponent vector has all 0 exponents.
 * a: the exponent vector to check
 */ 
#define isZeroExponentVector(A) ((A) == 0)

/**
 * Add two exponent vectors, a and b, and store the result in c.
 * a,b,c: degree_t  
 */
#define addExponentVectors(A, B, C) ((C) = (A) + (B)) 

/**
 * Subtract two exponent vectors, b from a, and store the result in c.
 * It is assumed that this operation is valid.
 * see also, monomialDivideTest.
 *
 * a,b,c: degree_tarrays
 */
#define subtractExponentVectors(A, B, C) ((C) = (A) - (B))



//defines for nvar=1
#define EXP_1_V1 0xffffffffffffffff

// #define MAX_EXP_1_V1 0xffffffffffffffff
#define MAX_EXP_1_V1 0xffffffff

#define EXP_OFFSET_1_V1 0

//defines for nvar=2
#define EXP_1_V2 0xffffffff00000000
#define EXP_2_V2 0x00000000ffffffff

#define MAX_EXP_1_V2 0xffffffff
#define MAX_EXP_2_V2 0xffffffff

#define EXP_OFFSET_1_V2 32
#define EXP_OFFSET_2_V2 0


//defines for nvar=3
#define EXP_1_V3 0xffff000000000000
#define EXP_2_V3 0x0000fffff0000000
#define EXP_3_V3 0x000000000fffffff

#define MAX_EXP_1_V3 0xffff
#define MAX_EXP_2_V3 0xfffff
#define MAX_EXP_3_V3 0xfffffff

#define EXP_OFFSET_1_V3 48
#define EXP_OFFSET_2_V3 28
#define EXP_OFFSET_3_V3 0


//defines for nvar=4
#define EXP_1_V4 0xffc0000000000000
#define EXP_2_V4 0x003ffc0000000000
#define EXP_3_V4 0x000003ffff000000
#define EXP_4_V4 0x0000000000ffffff

#define MAX_EXP_1_V4 0xffc
#define MAX_EXP_2_V4 0x3ffc
#define MAX_EXP_3_V4 0x3ffff
#define MAX_EXP_4_V4 0xffffff

#define EXP_OFFSET_1_V4 54
#define EXP_OFFSET_2_V4 42
#define EXP_OFFSET_3_V4 24
#define EXP_OFFSET_4_V4 0


//defines for nvar=5
#define EXP_1_V5 0xff00000000000000
#define EXP_2_V5 0x00ffc00000000000
#define EXP_3_V5 0x00003ffc00000000
#define EXP_4_V5 0x00000003fffc0000
#define EXP_5_V5 0x000000000003ffff

#define MAX_EXP_1_V5 0xff
#define MAX_EXP_2_V5 0xffc
#define MAX_EXP_3_V5 0x3ffc
#define MAX_EXP_4_V5 0x3fffc
#define MAX_EXP_5_V5 0x3ffff

#define EXP_OFFSET_1_V5 56
#define EXP_OFFSET_2_V5 46
#define EXP_OFFSET_3_V5 34
#define EXP_OFFSET_4_V5 18
#define EXP_OFFSET_5_V5 0

//defines for nvar=6
#define EXP_1_V6 0xff80000000000000
#define EXP_2_V6 0x007fe00000000000
#define EXP_3_V6 0x00001ff800000000
#define EXP_4_V6 0x00000007ff000000
#define EXP_5_V6 0x0000000000fff000
#define EXP_6_V6 0x0000000000000fff

#define MAX_EXP_1_V6 0xff8
#define MAX_EXP_2_V6 0x7fe
#define MAX_EXP_3_V6 0x1ff8
#define MAX_EXP_4_V6 0x7ff
#define MAX_EXP_5_V6 0xfff
#define MAX_EXP_6_V6 0xfff

#define EXP_OFFSET_1_V6 55
#define EXP_OFFSET_2_V6 45
#define EXP_OFFSET_3_V6 35
#define EXP_OFFSET_4_V6 24
#define EXP_OFFSET_5_V6 12
#define EXP_OFFSET_6_V6 0


//defines for nvar=7
#define EXP_1_V7 0xff00000000000000
#define EXP_2_V7 0x00ff000000000000
#define EXP_3_V7 0x0000ff0000000000
#define EXP_4_V7 0x000000ff80000000
#define EXP_5_V7 0x000000007fe00000
#define EXP_6_V7 0x00000000001ff800
#define EXP_7_V7 0x00000000000007ff

#define MAX_EXP_1_V7 0xff
#define MAX_EXP_2_V7 0xff
#define MAX_EXP_3_V7 0xff
#define MAX_EXP_4_V7 0xff8
#define MAX_EXP_5_V7 0x7fe
#define MAX_EXP_6_V7 0x1ff8
#define MAX_EXP_7_V7 0x7ff

#define EXP_OFFSET_1_V7 56
#define EXP_OFFSET_2_V7 48
#define EXP_OFFSET_3_V7 40
#define EXP_OFFSET_4_V7 31
#define EXP_OFFSET_5_V7 21
#define EXP_OFFSET_6_V7 11
#define EXP_OFFSET_7_V7 0


//defines for nvar=8
#define EXP_1_V8 0xfe00000000000000
#define EXP_2_V8 0x01fc000000000000
#define EXP_3_V8 0x0003f80000000000
#define EXP_4_V8 0x000007f800000000
#define EXP_5_V8 0x00000007f8000000
#define EXP_6_V8 0x0000000007fc0000
#define EXP_7_V8 0x000000000003fe00
#define EXP_8_V8 0x00000000000001ff

#define MAX_EXP_1_V8 0xfe
#define MAX_EXP_2_V8 0x1fc
#define MAX_EXP_3_V8 0x3f8
#define MAX_EXP_4_V8 0x7f8
#define MAX_EXP_5_V8 0x7f8
#define MAX_EXP_6_V8 0x7fc
#define MAX_EXP_7_V8 0x3fe
#define MAX_EXP_8_V8 0x1ff

#define EXP_OFFSET_1_V8 57
#define EXP_OFFSET_2_V8 50
#define EXP_OFFSET_3_V8 43
#define EXP_OFFSET_4_V8 35
#define EXP_OFFSET_5_V8 27
#define EXP_OFFSET_6_V8 18
#define EXP_OFFSET_7_V8 9
#define EXP_OFFSET_8_V8 0


//defines for nvar=9
#define EXP_1_V9 0xfe00000000000000
#define EXP_2_V9 0x01fc000000000000
#define EXP_3_V9 0x0003f80000000000
#define EXP_4_V9 0x000007f000000000
#define EXP_5_V9 0x0000000fe0000000
#define EXP_6_V9 0x000000001fc00000
#define EXP_7_V9 0x00000000003f8000
#define EXP_8_V9 0x0000000000007f00
#define EXP_9_V9 0x00000000000000ff

#define MAX_EXP_1_V9 0xfe
#define MAX_EXP_2_V9 0x1fc
#define MAX_EXP_3_V9 0x3f8
#define MAX_EXP_4_V9 0x7f
#define MAX_EXP_5_V9 0xfe
#define MAX_EXP_6_V9 0x1fc
#define MAX_EXP_7_V9 0x3f8
#define MAX_EXP_8_V9 0x7f
#define MAX_EXP_9_V9 0xff

#define EXP_OFFSET_1_V9 57
#define EXP_OFFSET_2_V9 50
#define EXP_OFFSET_3_V9 43
#define EXP_OFFSET_4_V9 36
#define EXP_OFFSET_5_V9 29
#define EXP_OFFSET_6_V9 22
#define EXP_OFFSET_7_V9 15
#define EXP_OFFSET_8_V9 8
#define EXP_OFFSET_9_V9 0


//defines for nvar=10
#define EXP_1_V10 0xfc00000000000000
#define EXP_2_V10 0x03f0000000000000
#define EXP_3_V10 0x000fc00000000000
#define EXP_4_V10 0x00003f0000000000
#define EXP_5_V10 0x000000fc00000000
#define EXP_6_V10 0x00000003f0000000
#define EXP_7_V10 0x000000000fe00000
#define EXP_8_V10 0x00000000001fc000
#define EXP_9_V10 0x0000000000003f80
#define EXP_10_V10 0x000000000000007f

#define MAX_EXP_1_V10 0xfc
#define MAX_EXP_2_V10 0x3f
#define MAX_EXP_3_V10 0xfc
#define MAX_EXP_4_V10 0x3f
#define MAX_EXP_5_V10 0xfc
#define MAX_EXP_6_V10 0x3f
#define MAX_EXP_7_V10 0xfe
#define MAX_EXP_8_V10 0x1fc
#define MAX_EXP_9_V10 0x3f8
#define MAX_EXP_10_V10 0x7f

#define EXP_OFFSET_1_V10 58
#define EXP_OFFSET_2_V10 52
#define EXP_OFFSET_3_V10 46
#define EXP_OFFSET_4_V10 40
#define EXP_OFFSET_5_V10 34
#define EXP_OFFSET_6_V10 28
#define EXP_OFFSET_7_V10 21
#define EXP_OFFSET_8_V10 14
#define EXP_OFFSET_9_V10 7
#define EXP_OFFSET_10_V10 0


//defines for nvar=11
#define EXP_1_V11 0xf800000000000000
#define EXP_2_V11 0x07c0000000000000
#define EXP_3_V11 0x003f000000000000
#define EXP_4_V11 0x0000fc0000000000
#define EXP_5_V11 0x000003f000000000
#define EXP_6_V11 0x0000000fc0000000
#define EXP_7_V11 0x000000003f000000
#define EXP_8_V11 0x0000000000fc0000
#define EXP_9_V11 0x000000000003f000
#define EXP_10_V11 0x0000000000000fc0
#define EXP_11_V11 0x000000000000003f

#define MAX_EXP_1_V11 0xf8
#define MAX_EXP_2_V11 0x7c
#define MAX_EXP_3_V11 0x3f
#define MAX_EXP_4_V11 0xfc
#define MAX_EXP_5_V11 0x3f
#define MAX_EXP_6_V11 0xfc
#define MAX_EXP_7_V11 0x3f
#define MAX_EXP_8_V11 0xfc
#define MAX_EXP_9_V11 0x3f
#define MAX_EXP_10_V11 0xfc
#define MAX_EXP_11_V11 0x3f

#define EXP_OFFSET_1_V11 59
#define EXP_OFFSET_2_V11 54
#define EXP_OFFSET_3_V11 48
#define EXP_OFFSET_4_V11 42
#define EXP_OFFSET_5_V11 36
#define EXP_OFFSET_6_V11 30
#define EXP_OFFSET_7_V11 24
#define EXP_OFFSET_8_V11 18
#define EXP_OFFSET_9_V11 12
#define EXP_OFFSET_10_V11 6
#define EXP_OFFSET_11_V11 0


//defines for nvar=12
#define EXP_1_V12 0xf800000000000000
#define EXP_2_V12 0x07c0000000000000
#define EXP_3_V12 0x003e000000000000
#define EXP_4_V12 0x0001f00000000000
#define EXP_5_V12 0x00000f8000000000
#define EXP_6_V12 0x0000007c00000000
#define EXP_7_V12 0x00000003e0000000
#define EXP_8_V12 0x000000001f000000
#define EXP_9_V12 0x0000000000fc0000
#define EXP_10_V12 0x000000000003f000
#define EXP_11_V12 0x0000000000000fc0
#define EXP_12_V12 0x000000000000003f

#define MAX_EXP_1_V12 0xf8
#define MAX_EXP_2_V12 0x7c
#define MAX_EXP_3_V12 0x3e
#define MAX_EXP_4_V12 0x1f
#define MAX_EXP_5_V12 0xf8
#define MAX_EXP_6_V12 0x7c
#define MAX_EXP_7_V12 0x3e
#define MAX_EXP_8_V12 0x1f
#define MAX_EXP_9_V12 0xfc
#define MAX_EXP_10_V12 0x3f
#define MAX_EXP_11_V12 0xfc
#define MAX_EXP_12_V12 0x3f

#define EXP_OFFSET_1_V12 59
#define EXP_OFFSET_2_V12 54
#define EXP_OFFSET_3_V12 49
#define EXP_OFFSET_4_V12 44
#define EXP_OFFSET_5_V12 39
#define EXP_OFFSET_6_V12 34
#define EXP_OFFSET_7_V12 29
#define EXP_OFFSET_8_V12 24
#define EXP_OFFSET_9_V12 18
#define EXP_OFFSET_10_V12 12
#define EXP_OFFSET_11_V12 6
#define EXP_OFFSET_12_V12 0


//defines for nvar=13
#define EXP_1_V13 0xf000000000000000
#define EXP_2_V13 0x0f80000000000000
#define EXP_3_V13 0x007c000000000000
#define EXP_4_V13 0x0003e00000000000
#define EXP_5_V13 0x00001f0000000000
#define EXP_6_V13 0x000000f800000000
#define EXP_7_V13 0x00000007c0000000
#define EXP_8_V13 0x000000003e000000
#define EXP_9_V13 0x0000000001f00000
#define EXP_10_V13 0x00000000000f8000
#define EXP_11_V13 0x0000000000007c00
#define EXP_12_V13 0x00000000000003e0
#define EXP_13_V13 0x000000000000001f

#define MAX_EXP_1_V13 0xf
#define MAX_EXP_2_V13 0xf8
#define MAX_EXP_3_V13 0x7c
#define MAX_EXP_4_V13 0x3e
#define MAX_EXP_5_V13 0x1f
#define MAX_EXP_6_V13 0xf8
#define MAX_EXP_7_V13 0x7c
#define MAX_EXP_8_V13 0x3e
#define MAX_EXP_9_V13 0x1f
#define MAX_EXP_10_V13 0xf8
#define MAX_EXP_11_V13 0x7c
#define MAX_EXP_12_V13 0x3e
#define MAX_EXP_13_V13 0x1f

#define EXP_OFFSET_1_V13 60
#define EXP_OFFSET_2_V13 55
#define EXP_OFFSET_3_V13 50
#define EXP_OFFSET_4_V13 45
#define EXP_OFFSET_5_V13 40
#define EXP_OFFSET_6_V13 35
#define EXP_OFFSET_7_V13 30
#define EXP_OFFSET_8_V13 25
#define EXP_OFFSET_9_V13 20
#define EXP_OFFSET_10_V13 15
#define EXP_OFFSET_11_V13 10
#define EXP_OFFSET_12_V13 5
#define EXP_OFFSET_13_V13 0


//defines for nvar=14
#define EXP_1_V14 0xf000000000000000
#define EXP_2_V14 0x0f00000000000000
#define EXP_3_V14 0x00f0000000000000
#define EXP_4_V14 0x000f000000000000
#define EXP_5_V14 0x0000f00000000000
#define EXP_6_V14 0x00000f0000000000
#define EXP_7_V14 0x000000f800000000
#define EXP_8_V14 0x00000007c0000000
#define EXP_9_V14 0x000000003e000000
#define EXP_10_V14 0x0000000001f00000
#define EXP_11_V14 0x00000000000f8000
#define EXP_12_V14 0x0000000000007c00
#define EXP_13_V14 0x00000000000003e0
#define EXP_14_V14 0x000000000000001f

#define MAX_EXP_1_V14 0xf
#define MAX_EXP_2_V14 0xf
#define MAX_EXP_3_V14 0xf
#define MAX_EXP_4_V14 0xf
#define MAX_EXP_5_V14 0xf
#define MAX_EXP_6_V14 0xf
#define MAX_EXP_7_V14 0xf8
#define MAX_EXP_8_V14 0x7c
#define MAX_EXP_9_V14 0x3e
#define MAX_EXP_10_V14 0x1f
#define MAX_EXP_11_V14 0xf8
#define MAX_EXP_12_V14 0x7c
#define MAX_EXP_13_V14 0x3e
#define MAX_EXP_14_V14 0x1f

#define EXP_OFFSET_1_V14 60
#define EXP_OFFSET_2_V14 56
#define EXP_OFFSET_3_V14 52
#define EXP_OFFSET_4_V14 48
#define EXP_OFFSET_5_V14 44
#define EXP_OFFSET_6_V14 40
#define EXP_OFFSET_7_V14 35
#define EXP_OFFSET_8_V14 30
#define EXP_OFFSET_9_V14 25
#define EXP_OFFSET_10_V14 20
#define EXP_OFFSET_11_V14 15
#define EXP_OFFSET_12_V14 10
#define EXP_OFFSET_13_V14 5
#define EXP_OFFSET_14_V14 0


//defines for nvar=15
#define EXP_1_V15 0xf000000000000000
#define EXP_2_V15 0x0f00000000000000
#define EXP_3_V15 0x00f0000000000000
#define EXP_4_V15 0x000f000000000000
#define EXP_5_V15 0x0000f00000000000
#define EXP_6_V15 0x00000f0000000000
#define EXP_7_V15 0x000000f000000000
#define EXP_8_V15 0x0000000f00000000
#define EXP_9_V15 0x00000000f0000000
#define EXP_10_V15 0x000000000f000000
#define EXP_11_V15 0x0000000000f00000
#define EXP_12_V15 0x00000000000f8000
#define EXP_13_V15 0x0000000000007c00
#define EXP_14_V15 0x00000000000003e0
#define EXP_15_V15 0x000000000000001f

#define MAX_EXP_1_V15 0xf
#define MAX_EXP_2_V15 0xf
#define MAX_EXP_3_V15 0xf
#define MAX_EXP_4_V15 0xf
#define MAX_EXP_5_V15 0xf
#define MAX_EXP_6_V15 0xf
#define MAX_EXP_7_V15 0xf
#define MAX_EXP_8_V15 0xf
#define MAX_EXP_9_V15 0xf
#define MAX_EXP_10_V15 0xf
#define MAX_EXP_11_V15 0xf
#define MAX_EXP_12_V15 0xf8
#define MAX_EXP_13_V15 0x7c
#define MAX_EXP_14_V15 0x3e
#define MAX_EXP_15_V15 0x1f

#define EXP_OFFSET_1_V15 60
#define EXP_OFFSET_2_V15 56
#define EXP_OFFSET_3_V15 52
#define EXP_OFFSET_4_V15 48
#define EXP_OFFSET_5_V15 44
#define EXP_OFFSET_6_V15 50
#define EXP_OFFSET_7_V15 36
#define EXP_OFFSET_8_V15 32
#define EXP_OFFSET_9_V15 28
#define EXP_OFFSET_10_V15 24
#define EXP_OFFSET_11_V15 20
#define EXP_OFFSET_12_V15 15
#define EXP_OFFSET_13_V15 10
#define EXP_OFFSET_14_V15 5
#define EXP_OFFSET_15_V15 0


//defines for nvar=16
#define EXP_1_V16 0xf000000000000000
#define EXP_2_V16 0x0f00000000000000
#define EXP_3_V16 0x00f0000000000000
#define EXP_4_V16 0x000f000000000000
#define EXP_5_V16 0x0000f00000000000
#define EXP_6_V16 0x00000f0000000000
#define EXP_7_V16 0x000000f000000000
#define EXP_8_V16 0x0000000f00000000
#define EXP_9_V16 0x00000000f0000000
#define EXP_10_V16 0x000000000f000000
#define EXP_11_V16 0x0000000000f00000
#define EXP_12_V16 0x00000000000f0000
#define EXP_13_V16 0x000000000000f000
#define EXP_14_V16 0x0000000000000f00
#define EXP_15_V16 0x00000000000000f0
#define EXP_16_V16 0x000000000000000f

#define MAX_EXP_1_V16 0xf
#define MAX_EXP_2_V16 0xf
#define MAX_EXP_3_V16 0xf
#define MAX_EXP_4_V16 0xf
#define MAX_EXP_5_V16 0xf
#define MAX_EXP_6_V16 0xf
#define MAX_EXP_7_V16 0xf
#define MAX_EXP_8_V16 0xf
#define MAX_EXP_9_V16 0xf
#define MAX_EXP_10_V16 0xf
#define MAX_EXP_11_V16 0xf
#define MAX_EXP_12_V16 0xf
#define MAX_EXP_13_V16 0xf
#define MAX_EXP_14_V16 0xf
#define MAX_EXP_15_V16 0xf
#define MAX_EXP_16_V16 0xf

#define EXP_OFFSET_1_V16 60
#define EXP_OFFSET_2_V16 56
#define EXP_OFFSET_3_V16 52
#define EXP_OFFSET_4_V16 48
#define EXP_OFFSET_5_V16 44
#define EXP_OFFSET_6_V16 40
#define EXP_OFFSET_7_V16 36
#define EXP_OFFSET_8_V16 32
#define EXP_OFFSET_9_V16 28
#define EXP_OFFSET_10_V16 24
#define EXP_OFFSET_11_V16 20
#define EXP_OFFSET_12_V16 16
#define EXP_OFFSET_13_V16 12
#define EXP_OFFSET_14_V16 8
#define EXP_OFFSET_15_V16 4
#define EXP_OFFSET_16_V16 0


//defines for nvar=17
#define EXP_1_V17 0xe000000000000000
#define EXP_2_V17 0x1c00000000000000
#define EXP_3_V17 0x0380000000000000
#define EXP_4_V17 0x0070000000000000
#define EXP_5_V17 0x000f000000000000
#define EXP_6_V17 0x0000f00000000000
#define EXP_7_V17 0x00000f0000000000
#define EXP_8_V17 0x000000f000000000
#define EXP_9_V17 0x0000000f00000000
#define EXP_10_V17 0x00000000f0000000
#define EXP_11_V17 0x000000000f000000
#define EXP_12_V17 0x0000000000f00000
#define EXP_13_V17 0x00000000000f0000
#define EXP_14_V17 0x000000000000f000
#define EXP_15_V17 0x0000000000000f00
#define EXP_16_V17 0x00000000000000f0
#define EXP_17_V17 0x000000000000000f

#define MAX_EXP_1_V17 0xe
#define MAX_EXP_2_V17 0x1c
#define MAX_EXP_3_V17 0x38
#define MAX_EXP_4_V17 0x7
#define MAX_EXP_5_V17 0xf
#define MAX_EXP_6_V17 0xf
#define MAX_EXP_7_V17 0xf
#define MAX_EXP_8_V17 0xf
#define MAX_EXP_9_V17 0xf
#define MAX_EXP_10_V17 0xf
#define MAX_EXP_11_V17 0xf
#define MAX_EXP_12_V17 0xf
#define MAX_EXP_13_V17 0xf
#define MAX_EXP_14_V17 0xf
#define MAX_EXP_15_V17 0xf
#define MAX_EXP_16_V17 0xf
#define MAX_EXP_17_V17 0xf

#define EXP_OFFSET_1_V17 61
#define EXP_OFFSET_2_V17 58
#define EXP_OFFSET_3_V17 55
#define EXP_OFFSET_4_V17 52
#define EXP_OFFSET_5_V17 48
#define EXP_OFFSET_6_V17 44
#define EXP_OFFSET_7_V17 40
#define EXP_OFFSET_8_V17 36
#define EXP_OFFSET_9_V17 32
#define EXP_OFFSET_10_V17 28
#define EXP_OFFSET_11_V17 24
#define EXP_OFFSET_12_V17 20
#define EXP_OFFSET_13_V17 16
#define EXP_OFFSET_14_V17 12
#define EXP_OFFSET_15_V17 8
#define EXP_OFFSET_16_V17 4
#define EXP_OFFSET_17_V17 0


//defines for nvar=18
#define EXP_1_V18 0xe000000000000000
#define EXP_2_V18 0x1c00000000000000
#define EXP_3_V18 0x0380000000000000
#define EXP_4_V18 0x0070000000000000
#define EXP_5_V18 0x000e000000000000
#define EXP_6_V18 0x0001c00000000000
#define EXP_7_V18 0x0000380000000000
#define EXP_8_V18 0x0000070000000000
#define EXP_9_V18 0x000000f000000000
#define EXP_10_V18 0x0000000f00000000
#define EXP_11_V18 0x00000000f0000000
#define EXP_12_V18 0x000000000f000000
#define EXP_13_V18 0x0000000000f00000
#define EXP_14_V18 0x00000000000f0000
#define EXP_15_V18 0x000000000000f000
#define EXP_16_V18 0x0000000000000f00
#define EXP_17_V18 0x00000000000000f0
#define EXP_18_V18 0x000000000000000f

#define MAX_EXP_1_V18 0xe
#define MAX_EXP_2_V18 0x1c
#define MAX_EXP_3_V18 0x38
#define MAX_EXP_4_V18 0x7
#define MAX_EXP_5_V18 0xe
#define MAX_EXP_6_V18 0x1c
#define MAX_EXP_7_V18 0x38
#define MAX_EXP_8_V18 0x7
#define MAX_EXP_9_V18 0xf
#define MAX_EXP_10_V18 0xf
#define MAX_EXP_11_V18 0xf
#define MAX_EXP_12_V18 0xf
#define MAX_EXP_13_V18 0xf
#define MAX_EXP_14_V18 0xf
#define MAX_EXP_15_V18 0xf
#define MAX_EXP_16_V18 0xf
#define MAX_EXP_17_V18 0xf
#define MAX_EXP_18_V18 0xf

#define EXP_OFFSET_1_V18 61
#define EXP_OFFSET_2_V18 58
#define EXP_OFFSET_3_V18 55
#define EXP_OFFSET_4_V18 52
#define EXP_OFFSET_5_V18 49
#define EXP_OFFSET_6_V18 46
#define EXP_OFFSET_7_V18 43
#define EXP_OFFSET_8_V18 40
#define EXP_OFFSET_9_V18 36
#define EXP_OFFSET_10_V18 32
#define EXP_OFFSET_11_V18 28
#define EXP_OFFSET_12_V18 24
#define EXP_OFFSET_13_V18 20
#define EXP_OFFSET_14_V18 16
#define EXP_OFFSET_15_V18 12
#define EXP_OFFSET_16_V18 8
#define EXP_OFFSET_17_V18 4
#define EXP_OFFSET_18_V18 0


//defines for nvar=19
#define EXP_1_V19 0xe000000000000000
#define EXP_2_V19 0x1c00000000000000
#define EXP_3_V19 0x0380000000000000
#define EXP_4_V19 0x0070000000000000
#define EXP_5_V19 0x000e000000000000
#define EXP_6_V19 0x0001c00000000000
#define EXP_7_V19 0x0000380000000000
#define EXP_8_V19 0x0000070000000000
#define EXP_9_V19 0x000000e000000000
#define EXP_10_V19 0x0000001c00000000
#define EXP_11_V19 0x0000000380000000
#define EXP_12_V19 0x0000000070000000
#define EXP_13_V19 0x000000000f000000
#define EXP_14_V19 0x0000000000f00000
#define EXP_15_V19 0x00000000000f0000
#define EXP_16_V19 0x000000000000f000
#define EXP_17_V19 0x0000000000000f00
#define EXP_18_V19 0x00000000000000f0
#define EXP_19_V19 0x000000000000000f

#define MAX_EXP_1_V19 0xe
#define MAX_EXP_2_V19 0x1c
#define MAX_EXP_3_V19 0x38
#define MAX_EXP_4_V19 0x7
#define MAX_EXP_5_V19 0xe
#define MAX_EXP_6_V19 0x1c
#define MAX_EXP_7_V19 0x38
#define MAX_EXP_8_V19 0x7
#define MAX_EXP_9_V19 0xe
#define MAX_EXP_10_V19 0x1c
#define MAX_EXP_11_V19 0x38
#define MAX_EXP_12_V19 0x7
#define MAX_EXP_13_V19 0xf
#define MAX_EXP_14_V19 0xf
#define MAX_EXP_15_V19 0xf
#define MAX_EXP_16_V19 0xf
#define MAX_EXP_17_V19 0xf
#define MAX_EXP_18_V19 0xf
#define MAX_EXP_19_V19 0xf

#define EXP_OFFSET_1_V19 61
#define EXP_OFFSET_2_V19 58
#define EXP_OFFSET_3_V19 55
#define EXP_OFFSET_4_V19 52
#define EXP_OFFSET_5_V19 49
#define EXP_OFFSET_6_V19 46
#define EXP_OFFSET_7_V19 43
#define EXP_OFFSET_8_V19 40
#define EXP_OFFSET_9_V19 37
#define EXP_OFFSET_10_V19 34
#define EXP_OFFSET_11_V19 31
#define EXP_OFFSET_12_V19 28
#define EXP_OFFSET_13_V19 24
#define EXP_OFFSET_14_V19 20
#define EXP_OFFSET_15_V19 16
#define EXP_OFFSET_16_V19 12
#define EXP_OFFSET_17_V19 8
#define EXP_OFFSET_18_V19 4
#define EXP_OFFSET_19_V19 0


//defines for nvar=20
#define EXP_1_V20 0xe000000000000000
#define EXP_2_V20 0x1c00000000000000
#define EXP_3_V20 0x0380000000000000
#define EXP_4_V20 0x0070000000000000
#define EXP_5_V20 0x000e000000000000
#define EXP_6_V20 0x0001c00000000000
#define EXP_7_V20 0x0000380000000000
#define EXP_8_V20 0x0000070000000000
#define EXP_9_V20 0x000000e000000000
#define EXP_10_V20 0x0000001c00000000
#define EXP_11_V20 0x0000000380000000
#define EXP_12_V20 0x0000000070000000
#define EXP_13_V20 0x000000000e000000
#define EXP_14_V20 0x0000000001c00000
#define EXP_15_V20 0x0000000000380000
#define EXP_16_V20 0x0000000000070000
#define EXP_17_V20 0x000000000000f000
#define EXP_18_V20 0x0000000000000f00
#define EXP_19_V20 0x00000000000000f0
#define EXP_20_V20 0x000000000000000f

#define MAX_EXP_1_V20 0xe
#define MAX_EXP_2_V20 0x1c
#define MAX_EXP_3_V20 0x38
#define MAX_EXP_4_V20 0x7
#define MAX_EXP_5_V20 0xe
#define MAX_EXP_6_V20 0x1c
#define MAX_EXP_7_V20 0x38
#define MAX_EXP_8_V20 0x7
#define MAX_EXP_9_V20 0xe
#define MAX_EXP_10_V20 0x1c
#define MAX_EXP_11_V20 0x38
#define MAX_EXP_12_V20 0x7
#define MAX_EXP_13_V20 0xe
#define MAX_EXP_14_V20 0x1c
#define MAX_EXP_15_V20 0x38
#define MAX_EXP_16_V20 0x7
#define MAX_EXP_17_V20 0xf
#define MAX_EXP_18_V20 0xf
#define MAX_EXP_19_V20 0xf
#define MAX_EXP_20_V20 0xf

#define EXP_OFFSET_1_V20 61
#define EXP_OFFSET_2_V20 58
#define EXP_OFFSET_3_V20 55
#define EXP_OFFSET_4_V20 52
#define EXP_OFFSET_5_V20 49
#define EXP_OFFSET_6_V20 46
#define EXP_OFFSET_7_V20 43
#define EXP_OFFSET_8_V20 40
#define EXP_OFFSET_9_V20 37
#define EXP_OFFSET_10_V20 34
#define EXP_OFFSET_11_V20 31
#define EXP_OFFSET_12_V20 28
#define EXP_OFFSET_13_V20 25
#define EXP_OFFSET_14_V20 22
#define EXP_OFFSET_15_V20 19
#define EXP_OFFSET_16_V20 16
#define EXP_OFFSET_17_V20 12
#define EXP_OFFSET_18_V20 8
#define EXP_OFFSET_19_V20 4
#define EXP_OFFSET_20_V20 0


//defines for nvar=21
#define EXP_1_V21 0xe000000000000000
#define EXP_2_V21 0x1c00000000000000
#define EXP_3_V21 0x0380000000000000
#define EXP_4_V21 0x0070000000000000
#define EXP_5_V21 0x000e000000000000
#define EXP_6_V21 0x0001c00000000000
#define EXP_7_V21 0x0000380000000000
#define EXP_8_V21 0x0000070000000000
#define EXP_9_V21 0x000000e000000000
#define EXP_10_V21 0x0000001c00000000
#define EXP_11_V21 0x0000000380000000
#define EXP_12_V21 0x0000000070000000
#define EXP_13_V21 0x000000000e000000
#define EXP_14_V21 0x0000000001c00000
#define EXP_15_V21 0x0000000000380000
#define EXP_16_V21 0x0000000000070000
#define EXP_17_V21 0x000000000000e000
#define EXP_18_V21 0x0000000000001c00
#define EXP_19_V21 0x0000000000000380
#define EXP_20_V21 0x0000000000000070
#define EXP_21_V21 0x000000000000000f

#define MAX_EXP_1_V21 0xe
#define MAX_EXP_2_V21 0x1c
#define MAX_EXP_3_V21 0x38
#define MAX_EXP_4_V21 0x7
#define MAX_EXP_5_V21 0xe
#define MAX_EXP_6_V21 0x1c
#define MAX_EXP_7_V21 0x38
#define MAX_EXP_8_V21 0x7
#define MAX_EXP_9_V21 0xe
#define MAX_EXP_10_V21 0x1c
#define MAX_EXP_11_V21 0x38
#define MAX_EXP_12_V21 0x7
#define MAX_EXP_13_V21 0xe
#define MAX_EXP_14_V21 0x1c
#define MAX_EXP_15_V21 0x38
#define MAX_EXP_16_V21 0x7
#define MAX_EXP_17_V21 0xe
#define MAX_EXP_18_V21 0x1c
#define MAX_EXP_19_V21 0x38
#define MAX_EXP_20_V21 0x7
#define MAX_EXP_21_V21 0xf

#define EXP_OFFSET_1_V21 61
#define EXP_OFFSET_2_V21 58
#define EXP_OFFSET_3_V21 55
#define EXP_OFFSET_4_V21 52
#define EXP_OFFSET_5_V21 49
#define EXP_OFFSET_6_V21 46
#define EXP_OFFSET_7_V21 43
#define EXP_OFFSET_8_V21 40
#define EXP_OFFSET_9_V21 37
#define EXP_OFFSET_10_V21 34
#define EXP_OFFSET_11_V21 31
#define EXP_OFFSET_12_V21 28
#define EXP_OFFSET_13_V21 25
#define EXP_OFFSET_14_V21 22
#define EXP_OFFSET_15_V21 19
#define EXP_OFFSET_16_V21 16
#define EXP_OFFSET_17_V21 13
#define EXP_OFFSET_18_V21 10
#define EXP_OFFSET_19_V21 7
#define EXP_OFFSET_20_V21 4
#define EXP_OFFSET_21_V21 0


//defines for nvar=22
#define EXP_1_V22 0xc000000000000000
#define EXP_2_V22 0x3000000000000000
#define EXP_3_V22 0x0e00000000000000
#define EXP_4_V22 0x01c0000000000000
#define EXP_5_V22 0x0038000000000000
#define EXP_6_V22 0x0007000000000000
#define EXP_7_V22 0x0000e00000000000
#define EXP_8_V22 0x00001c0000000000
#define EXP_9_V22 0x0000038000000000
#define EXP_10_V22 0x0000007000000000
#define EXP_11_V22 0x0000000e00000000
#define EXP_12_V22 0x00000001c0000000
#define EXP_13_V22 0x0000000038000000
#define EXP_14_V22 0x0000000007000000
#define EXP_15_V22 0x0000000000e00000
#define EXP_16_V22 0x00000000001c0000
#define EXP_17_V22 0x0000000000038000
#define EXP_18_V22 0x0000000000007000
#define EXP_19_V22 0x0000000000000e00
#define EXP_20_V22 0x00000000000001c0
#define EXP_21_V22 0x0000000000000038
#define EXP_22_V22 0x0000000000000007

#define MAX_EXP_1_V22 0xc
#define MAX_EXP_2_V22 0x3
#define MAX_EXP_3_V22 0xe
#define MAX_EXP_4_V22 0x1c
#define MAX_EXP_5_V22 0x38
#define MAX_EXP_6_V22 0x7
#define MAX_EXP_7_V22 0xe
#define MAX_EXP_8_V22 0x1c
#define MAX_EXP_9_V22 0x38
#define MAX_EXP_10_V22 0x7
#define MAX_EXP_11_V22 0xe
#define MAX_EXP_12_V22 0x1c
#define MAX_EXP_13_V22 0x38
#define MAX_EXP_14_V22 0x7
#define MAX_EXP_15_V22 0xe
#define MAX_EXP_16_V22 0x1c
#define MAX_EXP_17_V22 0x38
#define MAX_EXP_18_V22 0x7
#define MAX_EXP_19_V22 0xe
#define MAX_EXP_20_V22 0x1c
#define MAX_EXP_21_V22 0x38
#define MAX_EXP_22_V22 0x7

#define EXP_OFFSET_1_V22 62
#define EXP_OFFSET_2_V22 60
#define EXP_OFFSET_3_V22 57
#define EXP_OFFSET_4_V22 54
#define EXP_OFFSET_5_V22 51
#define EXP_OFFSET_6_V22 48
#define EXP_OFFSET_7_V22 45
#define EXP_OFFSET_8_V22 42
#define EXP_OFFSET_9_V22 39
#define EXP_OFFSET_10_V22 36
#define EXP_OFFSET_11_V22 33
#define EXP_OFFSET_12_V22 30
#define EXP_OFFSET_13_V22 27
#define EXP_OFFSET_14_V22 24
#define EXP_OFFSET_15_V22 21
#define EXP_OFFSET_16_V22 18
#define EXP_OFFSET_17_V22 15
#define EXP_OFFSET_18_V22 12
#define EXP_OFFSET_19_V22 9
#define EXP_OFFSET_20_V22 6
#define EXP_OFFSET_21_V22 3
#define EXP_OFFSET_22_V22 0


//defines for nvar=23
#define EXP_1_V23 0xc000000000000000
#define EXP_2_V23 0x3000000000000000
#define EXP_3_V23 0x0c00000000000000
#define EXP_4_V23 0x0300000000000000
#define EXP_5_V23 0x00c0000000000000
#define EXP_6_V23 0x0038000000000000
#define EXP_7_V23 0x0007000000000000
#define EXP_8_V23 0x0000e00000000000
#define EXP_9_V23 0x00001c0000000000
#define EXP_10_V23 0x0000038000000000
#define EXP_11_V23 0x0000007000000000
#define EXP_12_V23 0x0000000e00000000
#define EXP_13_V23 0x00000001c0000000
#define EXP_14_V23 0x0000000038000000
#define EXP_15_V23 0x0000000007000000
#define EXP_16_V23 0x0000000000e00000
#define EXP_17_V23 0x00000000001c0000
#define EXP_18_V23 0x0000000000038000
#define EXP_19_V23 0x0000000000007000
#define EXP_20_V23 0x0000000000000e00
#define EXP_21_V23 0x00000000000001c0
#define EXP_22_V23 0x0000000000000038
#define EXP_23_V23 0x0000000000000007

#define MAX_EXP_1_V23 0xc
#define MAX_EXP_2_V23 0x3
#define MAX_EXP_3_V23 0xc
#define MAX_EXP_4_V23 0x3
#define MAX_EXP_5_V23 0xc
#define MAX_EXP_6_V23 0x38
#define MAX_EXP_7_V23 0x7
#define MAX_EXP_8_V23 0xe
#define MAX_EXP_9_V23 0x1c
#define MAX_EXP_10_V23 0x38
#define MAX_EXP_11_V23 0x7
#define MAX_EXP_12_V23 0xe
#define MAX_EXP_13_V23 0x1c
#define MAX_EXP_14_V23 0x38
#define MAX_EXP_15_V23 0x7
#define MAX_EXP_16_V23 0xe
#define MAX_EXP_17_V23 0x1c
#define MAX_EXP_18_V23 0x38
#define MAX_EXP_19_V23 0x7
#define MAX_EXP_20_V23 0xe
#define MAX_EXP_21_V23 0x1c
#define MAX_EXP_22_V23 0x38
#define MAX_EXP_23_V23 0x7

#define EXP_OFFSET_1_V23 62
#define EXP_OFFSET_2_V23 60
#define EXP_OFFSET_3_V23 58
#define EXP_OFFSET_4_V23 56
#define EXP_OFFSET_5_V23 53
#define EXP_OFFSET_6_V23 51
#define EXP_OFFSET_7_V23 48
#define EXP_OFFSET_8_V23 45
#define EXP_OFFSET_9_V23 42
#define EXP_OFFSET_10_V23 39
#define EXP_OFFSET_11_V23 36
#define EXP_OFFSET_12_V23 33
#define EXP_OFFSET_13_V23 30
#define EXP_OFFSET_14_V23 27
#define EXP_OFFSET_15_V23 24
#define EXP_OFFSET_16_V23 21
#define EXP_OFFSET_17_V23 18
#define EXP_OFFSET_18_V23 15
#define EXP_OFFSET_19_V23 12
#define EXP_OFFSET_20_V23 9
#define EXP_OFFSET_21_V23 6
#define EXP_OFFSET_22_V23 3
#define EXP_OFFSET_23_V23 0


//defines for nvar=24
#define EXP_1_V24 0xc000000000000000
#define EXP_2_V24 0x3000000000000000
#define EXP_3_V24 0x0c00000000000000
#define EXP_4_V24 0x0300000000000000
#define EXP_5_V24 0x00c0000000000000
#define EXP_6_V24 0x0030000000000000
#define EXP_7_V24 0x000c000000000000
#define EXP_8_V24 0x0003000000000000
#define EXP_9_V24 0x0000e00000000000
#define EXP_10_V24 0x00001c0000000000
#define EXP_11_V24 0x0000038000000000
#define EXP_12_V24 0x0000007000000000
#define EXP_13_V24 0x0000000e00000000
#define EXP_14_V24 0x00000001c0000000
#define EXP_15_V24 0x0000000038000000
#define EXP_16_V24 0x0000000007000000
#define EXP_17_V24 0x0000000000e00000
#define EXP_18_V24 0x00000000001c0000
#define EXP_19_V24 0x0000000000038000
#define EXP_20_V24 0x0000000000007000
#define EXP_21_V24 0x0000000000000e00
#define EXP_22_V24 0x00000000000001c0
#define EXP_23_V24 0x0000000000000038
#define EXP_24_V24 0x0000000000000007

#define MAX_EXP_1_V24 0xc
#define MAX_EXP_2_V24 0x3
#define MAX_EXP_3_V24 0xc
#define MAX_EXP_4_V24 0x3
#define MAX_EXP_5_V24 0xc
#define MAX_EXP_6_V24 0x3
#define MAX_EXP_7_V24 0xc
#define MAX_EXP_8_V24 0x3
#define MAX_EXP_9_V24 0xe
#define MAX_EXP_10_V24 0x1c
#define MAX_EXP_11_V24 0x38
#define MAX_EXP_12_V24 0x7
#define MAX_EXP_13_V24 0xe
#define MAX_EXP_14_V24 0x1c
#define MAX_EXP_15_V24 0x38
#define MAX_EXP_16_V24 0x7
#define MAX_EXP_17_V24 0xe
#define MAX_EXP_18_V24 0x1c
#define MAX_EXP_19_V24 0x38
#define MAX_EXP_20_V24 0x7
#define MAX_EXP_21_V24 0xe
#define MAX_EXP_22_V24 0x1c
#define MAX_EXP_23_V24 0x38
#define MAX_EXP_24_V24 0x7

#define EXP_OFFSET_1_V24 62
#define EXP_OFFSET_2_V24 60
#define EXP_OFFSET_3_V24 58
#define EXP_OFFSET_4_V24 56
#define EXP_OFFSET_5_V24 54
#define EXP_OFFSET_6_V24 52
#define EXP_OFFSET_7_V24 50
#define EXP_OFFSET_8_V24 48
#define EXP_OFFSET_9_V24 45
#define EXP_OFFSET_10_V24 42
#define EXP_OFFSET_11_V24 39
#define EXP_OFFSET_12_V24 36
#define EXP_OFFSET_13_V24 33
#define EXP_OFFSET_14_V24 30
#define EXP_OFFSET_15_V24 27
#define EXP_OFFSET_16_V24 24
#define EXP_OFFSET_17_V24 21
#define EXP_OFFSET_18_V24 18
#define EXP_OFFSET_19_V24 15
#define EXP_OFFSET_20_V24 12
#define EXP_OFFSET_21_V24 9
#define EXP_OFFSET_22_V24 6
#define EXP_OFFSET_23_V24 3
#define EXP_OFFSET_24_V24 0


//defines for nvar=25
#define EXP_1_V25 0xc000000000000000
#define EXP_2_V25 0x3000000000000000
#define EXP_3_V25 0x0c00000000000000
#define EXP_4_V25 0x0300000000000000
#define EXP_5_V25 0x00c0000000000000
#define EXP_6_V25 0x0030000000000000
#define EXP_7_V25 0x000c000000000000
#define EXP_8_V25 0x0003000000000000
#define EXP_9_V25 0x0000c00000000000
#define EXP_10_V25 0x0000300000000000
#define EXP_11_V25 0x00000c0000000000
#define EXP_12_V25 0x0000038000000000
#define EXP_13_V25 0x0000007000000000
#define EXP_14_V25 0x0000000e00000000
#define EXP_15_V25 0x00000001c0000000
#define EXP_16_V25 0x0000000038000000
#define EXP_17_V25 0x0000000007000000
#define EXP_18_V25 0x0000000000e00000
#define EXP_19_V25 0x00000000001c0000
#define EXP_20_V25 0x0000000000038000
#define EXP_21_V25 0x0000000000007000
#define EXP_22_V25 0x0000000000000e00
#define EXP_23_V25 0x00000000000001c0
#define EXP_24_V25 0x0000000000000038
#define EXP_25_V25 0x0000000000000007

#define MAX_EXP_1_V25 0xc
#define MAX_EXP_2_V25 0x3
#define MAX_EXP_3_V25 0xc
#define MAX_EXP_4_V25 0x3
#define MAX_EXP_5_V25 0xc
#define MAX_EXP_6_V25 0x3
#define MAX_EXP_7_V25 0xc
#define MAX_EXP_8_V25 0x3
#define MAX_EXP_9_V25 0xc
#define MAX_EXP_10_V25 0x3
#define MAX_EXP_11_V25 0xc
#define MAX_EXP_12_V25 0x38
#define MAX_EXP_13_V25 0x7
#define MAX_EXP_14_V25 0xe
#define MAX_EXP_15_V25 0x1c
#define MAX_EXP_16_V25 0x38
#define MAX_EXP_17_V25 0x7
#define MAX_EXP_18_V25 0xe
#define MAX_EXP_19_V25 0x1c
#define MAX_EXP_20_V25 0x38
#define MAX_EXP_21_V25 0x7
#define MAX_EXP_22_V25 0xe
#define MAX_EXP_23_V25 0x1c
#define MAX_EXP_24_V25 0x38
#define MAX_EXP_25_V25 0x7

#define EXP_OFFSET_1_V25 62
#define EXP_OFFSET_2_V25 60
#define EXP_OFFSET_3_V25 58
#define EXP_OFFSET_4_V25 56
#define EXP_OFFSET_5_V25 54
#define EXP_OFFSET_6_V25 52
#define EXP_OFFSET_7_V25 50
#define EXP_OFFSET_8_V25 48
#define EXP_OFFSET_9_V25 46
#define EXP_OFFSET_10_V25 44
#define EXP_OFFSET_11_V25 42
#define EXP_OFFSET_12_V25 39
#define EXP_OFFSET_13_V25 36
#define EXP_OFFSET_14_V25 33
#define EXP_OFFSET_15_V25 30
#define EXP_OFFSET_16_V25 27
#define EXP_OFFSET_17_V25 24
#define EXP_OFFSET_18_V25 21
#define EXP_OFFSET_19_V25 18
#define EXP_OFFSET_20_V25 15
#define EXP_OFFSET_21_V25 12
#define EXP_OFFSET_22_V25 9
#define EXP_OFFSET_23_V25 6
#define EXP_OFFSET_24_V25 3
#define EXP_OFFSET_25_V25 0


//defines for nvar=26
#define EXP_1_V26 0xc000000000000000
#define EXP_2_V26 0x3000000000000000
#define EXP_3_V26 0x0c00000000000000
#define EXP_4_V26 0x0300000000000000
#define EXP_5_V26 0x00c0000000000000
#define EXP_6_V26 0x0030000000000000
#define EXP_7_V26 0x000c000000000000
#define EXP_8_V26 0x0003000000000000
#define EXP_9_V26 0x0000c00000000000
#define EXP_10_V26 0x0000300000000000
#define EXP_11_V26 0x00000c0000000000
#define EXP_12_V26 0x0000030000000000
#define EXP_13_V26 0x000000c000000000
#define EXP_14_V26 0x0000003000000000
#define EXP_15_V26 0x0000000e00000000
#define EXP_16_V26 0x00000001c0000000
#define EXP_17_V26 0x0000000038000000
#define EXP_18_V26 0x0000000007000000
#define EXP_19_V26 0x0000000000e00000
#define EXP_20_V26 0x00000000001c0000
#define EXP_21_V26 0x0000000000038000
#define EXP_22_V26 0x0000000000007000
#define EXP_23_V26 0x0000000000000e00
#define EXP_24_V26 0x00000000000001c0
#define EXP_25_V26 0x0000000000000038
#define EXP_26_V26 0x0000000000000007

#define MAX_EXP_1_V26 0xc
#define MAX_EXP_2_V26 0x3
#define MAX_EXP_3_V26 0xc
#define MAX_EXP_4_V26 0x3
#define MAX_EXP_5_V26 0xc
#define MAX_EXP_6_V26 0x3
#define MAX_EXP_7_V26 0xc
#define MAX_EXP_8_V26 0x3
#define MAX_EXP_9_V26 0xc
#define MAX_EXP_10_V26 0x3
#define MAX_EXP_11_V26 0xc
#define MAX_EXP_12_V26 0x3
#define MAX_EXP_13_V26 0xc
#define MAX_EXP_14_V26 0x3
#define MAX_EXP_15_V26 0xe
#define MAX_EXP_16_V26 0x1c
#define MAX_EXP_17_V26 0x38
#define MAX_EXP_18_V26 0x7
#define MAX_EXP_19_V26 0xe
#define MAX_EXP_20_V26 0x1c
#define MAX_EXP_21_V26 0x38
#define MAX_EXP_22_V26 0x7
#define MAX_EXP_23_V26 0xe
#define MAX_EXP_24_V26 0x1c
#define MAX_EXP_25_V26 0x38
#define MAX_EXP_26_V26 0x7

#define EXP_OFFSET_1_V26 62
#define EXP_OFFSET_2_V26 60
#define EXP_OFFSET_3_V26 58
#define EXP_OFFSET_4_V26 56
#define EXP_OFFSET_5_V26 54
#define EXP_OFFSET_6_V26 52
#define EXP_OFFSET_7_V26 50
#define EXP_OFFSET_8_V26 48
#define EXP_OFFSET_9_V26 46
#define EXP_OFFSET_10_V26 44
#define EXP_OFFSET_11_V26 42
#define EXP_OFFSET_12_V26 40
#define EXP_OFFSET_13_V26 38
#define EXP_OFFSET_14_V26 36
#define EXP_OFFSET_15_V26 33
#define EXP_OFFSET_16_V26 30
#define EXP_OFFSET_17_V26 27
#define EXP_OFFSET_18_V26 24
#define EXP_OFFSET_19_V26 21
#define EXP_OFFSET_20_V26 18
#define EXP_OFFSET_21_V26 15
#define EXP_OFFSET_22_V26 12
#define EXP_OFFSET_23_V26 9
#define EXP_OFFSET_24_V26 6
#define EXP_OFFSET_25_V26 3
#define EXP_OFFSET_26_V26 0


//defines for nvar=27
#define EXP_1_V27 0xc000000000000000
#define EXP_2_V27 0x3000000000000000
#define EXP_3_V27 0x0c00000000000000
#define EXP_4_V27 0x0300000000000000
#define EXP_5_V27 0x00c0000000000000
#define EXP_6_V27 0x0030000000000000
#define EXP_7_V27 0x000c000000000000
#define EXP_8_V27 0x0003000000000000
#define EXP_9_V27 0x0000c00000000000
#define EXP_10_V27 0x0000300000000000
#define EXP_11_V27 0x00000c0000000000
#define EXP_12_V27 0x0000030000000000
#define EXP_13_V27 0x000000c000000000
#define EXP_14_V27 0x0000003000000000
#define EXP_15_V27 0x0000000c00000000
#define EXP_16_V27 0x0000000300000000
#define EXP_17_V27 0x00000000c0000000
#define EXP_18_V27 0x0000000038000000
#define EXP_19_V27 0x0000000007000000
#define EXP_20_V27 0x0000000000e00000
#define EXP_21_V27 0x00000000001c0000
#define EXP_22_V27 0x0000000000038000
#define EXP_23_V27 0x0000000000007000
#define EXP_24_V27 0x0000000000000e00
#define EXP_25_V27 0x00000000000001c0
#define EXP_26_V27 0x0000000000000038
#define EXP_27_V27 0x0000000000000007

#define MAX_EXP_1_V27 0xc
#define MAX_EXP_2_V27 0x3
#define MAX_EXP_3_V27 0xc
#define MAX_EXP_4_V27 0x3
#define MAX_EXP_5_V27 0xc
#define MAX_EXP_6_V27 0x3
#define MAX_EXP_7_V27 0xc
#define MAX_EXP_8_V27 0x3
#define MAX_EXP_9_V27 0xc
#define MAX_EXP_10_V27 0x3
#define MAX_EXP_11_V27 0xc
#define MAX_EXP_12_V27 0x3
#define MAX_EXP_13_V27 0xc
#define MAX_EXP_14_V27 0x3
#define MAX_EXP_15_V27 0xc
#define MAX_EXP_16_V27 0x3
#define MAX_EXP_17_V27 0xc
#define MAX_EXP_18_V27 0x38
#define MAX_EXP_19_V27 0x7
#define MAX_EXP_20_V27 0xe
#define MAX_EXP_21_V27 0x1c
#define MAX_EXP_22_V27 0x38
#define MAX_EXP_23_V27 0x7
#define MAX_EXP_24_V27 0xe
#define MAX_EXP_25_V27 0x1c
#define MAX_EXP_26_V27 0x38
#define MAX_EXP_27_V27 0x7

#define EXP_OFFSET_1_V27 62
#define EXP_OFFSET_2_V27 60
#define EXP_OFFSET_3_V27 58
#define EXP_OFFSET_4_V27 56
#define EXP_OFFSET_5_V27 54
#define EXP_OFFSET_6_V27 52
#define EXP_OFFSET_7_V27 50
#define EXP_OFFSET_8_V27 48
#define EXP_OFFSET_9_V27 46
#define EXP_OFFSET_10_V27 44
#define EXP_OFFSET_11_V27 42
#define EXP_OFFSET_12_V27 40
#define EXP_OFFSET_13_V27 38
#define EXP_OFFSET_14_V27 36
#define EXP_OFFSET_15_V27 34
#define EXP_OFFSET_16_V27 32
#define EXP_OFFSET_17_V27 30
#define EXP_OFFSET_18_V27 27
#define EXP_OFFSET_19_V27 24
#define EXP_OFFSET_20_V27 21
#define EXP_OFFSET_21_V27 18
#define EXP_OFFSET_22_V27 15
#define EXP_OFFSET_23_V27 12
#define EXP_OFFSET_24_V27 9
#define EXP_OFFSET_25_V27 6
#define EXP_OFFSET_26_V27 3
#define EXP_OFFSET_27_V27 0


//defines for nvar=28
#define EXP_1_V28 0xc000000000000000
#define EXP_2_V28 0x3000000000000000
#define EXP_3_V28 0x0c00000000000000
#define EXP_4_V28 0x0300000000000000
#define EXP_5_V28 0x00c0000000000000
#define EXP_6_V28 0x0030000000000000
#define EXP_7_V28 0x000c000000000000
#define EXP_8_V28 0x0003000000000000
#define EXP_9_V28 0x0000c00000000000
#define EXP_10_V28 0x0000300000000000
#define EXP_11_V28 0x00000c0000000000
#define EXP_12_V28 0x0000030000000000
#define EXP_13_V28 0x000000c000000000
#define EXP_14_V28 0x0000003000000000
#define EXP_15_V28 0x0000000c00000000
#define EXP_16_V28 0x0000000300000000
#define EXP_17_V28 0x00000000c0000000
#define EXP_18_V28 0x0000000030000000
#define EXP_19_V28 0x000000000c000000
#define EXP_20_V28 0x0000000003000000
#define EXP_21_V28 0x0000000000e00000
#define EXP_22_V28 0x00000000001c0000
#define EXP_23_V28 0x0000000000038000
#define EXP_24_V28 0x0000000000007000
#define EXP_25_V28 0x0000000000000e00
#define EXP_26_V28 0x00000000000001c0
#define EXP_27_V28 0x0000000000000038
#define EXP_28_V28 0x0000000000000007

#define MAX_EXP_1_V28 0xc
#define MAX_EXP_2_V28 0x3
#define MAX_EXP_3_V28 0xc
#define MAX_EXP_4_V28 0x3
#define MAX_EXP_5_V28 0xc
#define MAX_EXP_6_V28 0x3
#define MAX_EXP_7_V28 0xc
#define MAX_EXP_8_V28 0x3
#define MAX_EXP_9_V28 0xc
#define MAX_EXP_10_V28 0x3
#define MAX_EXP_11_V28 0xc
#define MAX_EXP_12_V28 0x3
#define MAX_EXP_13_V28 0xc
#define MAX_EXP_14_V28 0x3
#define MAX_EXP_15_V28 0xc
#define MAX_EXP_16_V28 0x3
#define MAX_EXP_17_V28 0xc
#define MAX_EXP_18_V28 0x3
#define MAX_EXP_19_V28 0xc
#define MAX_EXP_20_V28 0x3
#define MAX_EXP_21_V28 0xe
#define MAX_EXP_22_V28 0x1c
#define MAX_EXP_23_V28 0x38
#define MAX_EXP_24_V28 0x7
#define MAX_EXP_25_V28 0xe
#define MAX_EXP_26_V28 0x1c
#define MAX_EXP_27_V28 0x38
#define MAX_EXP_28_V28 0x7

#define EXP_OFFSET_1_V28 62
#define EXP_OFFSET_2_V28 60
#define EXP_OFFSET_3_V28 58
#define EXP_OFFSET_4_V28 56
#define EXP_OFFSET_5_V28 54
#define EXP_OFFSET_6_V28 52
#define EXP_OFFSET_7_V28 50
#define EXP_OFFSET_8_V28 48
#define EXP_OFFSET_9_V28 46
#define EXP_OFFSET_10_V28 44
#define EXP_OFFSET_11_V28 42
#define EXP_OFFSET_12_V28 40
#define EXP_OFFSET_13_V28 38
#define EXP_OFFSET_14_V28 36
#define EXP_OFFSET_15_V28 34
#define EXP_OFFSET_16_V28 32
#define EXP_OFFSET_17_V28 30
#define EXP_OFFSET_18_V28 28
#define EXP_OFFSET_19_V28 26
#define EXP_OFFSET_20_V28 24
#define EXP_OFFSET_21_V28 21
#define EXP_OFFSET_22_V28 18
#define EXP_OFFSET_23_V28 15
#define EXP_OFFSET_24_V28 12
#define EXP_OFFSET_25_V28 9
#define EXP_OFFSET_26_V28 6
#define EXP_OFFSET_27_V28 3
#define EXP_OFFSET_28_V28 0


//defines for nvar=29
#define EXP_1_V29 0xc000000000000000
#define EXP_2_V29 0x3000000000000000
#define EXP_3_V29 0x0c00000000000000
#define EXP_4_V29 0x0300000000000000
#define EXP_5_V29 0x00c0000000000000
#define EXP_6_V29 0x0030000000000000
#define EXP_7_V29 0x000c000000000000
#define EXP_8_V29 0x0003000000000000
#define EXP_9_V29 0x0000c00000000000
#define EXP_10_V29 0x0000300000000000
#define EXP_11_V29 0x00000c0000000000
#define EXP_12_V29 0x0000030000000000
#define EXP_13_V29 0x000000c000000000
#define EXP_14_V29 0x0000003000000000
#define EXP_15_V29 0x0000000c00000000
#define EXP_16_V29 0x0000000300000000
#define EXP_17_V29 0x00000000c0000000
#define EXP_18_V29 0x0000000030000000
#define EXP_19_V29 0x000000000c000000
#define EXP_20_V29 0x0000000003000000
#define EXP_21_V29 0x0000000000c00000
#define EXP_22_V29 0x0000000000300000
#define EXP_23_V29 0x00000000000c0000
#define EXP_24_V29 0x0000000000038000
#define EXP_25_V29 0x0000000000007000
#define EXP_26_V29 0x0000000000000e00
#define EXP_27_V29 0x00000000000001c0
#define EXP_28_V29 0x0000000000000038
#define EXP_29_V29 0x0000000000000007

#define MAX_EXP_1_V29 0xc
#define MAX_EXP_2_V29 0x3
#define MAX_EXP_3_V29 0xc
#define MAX_EXP_4_V29 0x3
#define MAX_EXP_5_V29 0xc
#define MAX_EXP_6_V29 0x3
#define MAX_EXP_7_V29 0xc
#define MAX_EXP_8_V29 0x3
#define MAX_EXP_9_V29 0xc
#define MAX_EXP_10_V29 0x3
#define MAX_EXP_11_V29 0xc
#define MAX_EXP_12_V29 0x3
#define MAX_EXP_13_V29 0xc
#define MAX_EXP_14_V29 0x3
#define MAX_EXP_15_V29 0xc
#define MAX_EXP_16_V29 0x3
#define MAX_EXP_17_V29 0xc
#define MAX_EXP_18_V29 0x3
#define MAX_EXP_19_V29 0xc
#define MAX_EXP_20_V29 0x3
#define MAX_EXP_21_V29 0xc
#define MAX_EXP_22_V29 0x3
#define MAX_EXP_23_V29 0xc
#define MAX_EXP_24_V29 0x38
#define MAX_EXP_25_V29 0x7
#define MAX_EXP_26_V29 0xe
#define MAX_EXP_27_V29 0x1c
#define MAX_EXP_28_V29 0x38
#define MAX_EXP_29_V29 0x7

#define EXP_OFFSET_1_V29 62
#define EXP_OFFSET_2_V29 60
#define EXP_OFFSET_3_V29 58
#define EXP_OFFSET_4_V29 56
#define EXP_OFFSET_5_V29 54
#define EXP_OFFSET_6_V29 52
#define EXP_OFFSET_7_V29 50
#define EXP_OFFSET_8_V29 48
#define EXP_OFFSET_9_V29 46
#define EXP_OFFSET_10_V29 44
#define EXP_OFFSET_11_V29 42
#define EXP_OFFSET_12_V29 40
#define EXP_OFFSET_13_V29 38
#define EXP_OFFSET_14_V29 36
#define EXP_OFFSET_15_V29 34
#define EXP_OFFSET_16_V29 32
#define EXP_OFFSET_17_V29 30
#define EXP_OFFSET_18_V29 28
#define EXP_OFFSET_19_V29 26
#define EXP_OFFSET_20_V29 24
#define EXP_OFFSET_21_V29 22
#define EXP_OFFSET_22_V29 20
#define EXP_OFFSET_23_V29 18
#define EXP_OFFSET_24_V29 15
#define EXP_OFFSET_25_V29 12
#define EXP_OFFSET_26_V29 9
#define EXP_OFFSET_27_V29 6
#define EXP_OFFSET_28_V29 3
#define EXP_OFFSET_29_V29 0


//defines for nvar=30
#define EXP_1_V30 0xc000000000000000
#define EXP_2_V30 0x3000000000000000
#define EXP_3_V30 0x0c00000000000000
#define EXP_4_V30 0x0300000000000000
#define EXP_5_V30 0x00c0000000000000
#define EXP_6_V30 0x0030000000000000
#define EXP_7_V30 0x000c000000000000
#define EXP_8_V30 0x0003000000000000
#define EXP_9_V30 0x0000c00000000000
#define EXP_10_V30 0x0000300000000000
#define EXP_11_V30 0x00000c0000000000
#define EXP_12_V30 0x0000030000000000
#define EXP_13_V30 0x000000c000000000
#define EXP_14_V30 0x0000003000000000
#define EXP_15_V30 0x0000000c00000000
#define EXP_16_V30 0x0000000300000000
#define EXP_17_V30 0x00000000c0000000
#define EXP_18_V30 0x0000000030000000
#define EXP_19_V30 0x000000000c000000
#define EXP_20_V30 0x0000000003000000
#define EXP_21_V30 0x0000000000c00000
#define EXP_22_V30 0x0000000000300000
#define EXP_23_V30 0x00000000000c0000
#define EXP_24_V30 0x0000000000030000
#define EXP_25_V30 0x000000000000c000
#define EXP_26_V30 0x0000000000003000
#define EXP_27_V30 0x0000000000000e00
#define EXP_28_V30 0x00000000000001c0
#define EXP_29_V30 0x0000000000000038
#define EXP_30_V30 0x0000000000000007

#define MAX_EXP_1_V30 0xc
#define MAX_EXP_2_V30 0x3
#define MAX_EXP_3_V30 0xc
#define MAX_EXP_4_V30 0x3
#define MAX_EXP_5_V30 0xc
#define MAX_EXP_6_V30 0x3
#define MAX_EXP_7_V30 0xc
#define MAX_EXP_8_V30 0x3
#define MAX_EXP_9_V30 0xc
#define MAX_EXP_10_V30 0x3
#define MAX_EXP_11_V30 0xc
#define MAX_EXP_12_V30 0x3
#define MAX_EXP_13_V30 0xc
#define MAX_EXP_14_V30 0x3
#define MAX_EXP_15_V30 0xc
#define MAX_EXP_16_V30 0x3
#define MAX_EXP_17_V30 0xc
#define MAX_EXP_18_V30 0x3
#define MAX_EXP_19_V30 0xc
#define MAX_EXP_20_V30 0x3
#define MAX_EXP_21_V30 0xc
#define MAX_EXP_22_V30 0x3
#define MAX_EXP_23_V30 0xc
#define MAX_EXP_24_V30 0x3
#define MAX_EXP_25_V30 0xc
#define MAX_EXP_26_V30 0x3
#define MAX_EXP_27_V30 0xe
#define MAX_EXP_28_V30 0x1c
#define MAX_EXP_29_V30 0x38
#define MAX_EXP_30_V30 0x7

#define EXP_OFFSET_1_V30 62
#define EXP_OFFSET_2_V30 60
#define EXP_OFFSET_3_V30 58
#define EXP_OFFSET_4_V30 56
#define EXP_OFFSET_5_V30 54
#define EXP_OFFSET_6_V30 52
#define EXP_OFFSET_7_V30 50
#define EXP_OFFSET_8_V30 48
#define EXP_OFFSET_9_V30 46
#define EXP_OFFSET_10_V30 44
#define EXP_OFFSET_11_V30 42
#define EXP_OFFSET_12_V30 40
#define EXP_OFFSET_13_V30 38
#define EXP_OFFSET_14_V30 36
#define EXP_OFFSET_15_V30 34
#define EXP_OFFSET_16_V30 32
#define EXP_OFFSET_17_V30 30
#define EXP_OFFSET_18_V30 28
#define EXP_OFFSET_19_V30 26
#define EXP_OFFSET_20_V30 24
#define EXP_OFFSET_21_V30 22
#define EXP_OFFSET_22_V30 20
#define EXP_OFFSET_23_V30 18
#define EXP_OFFSET_24_V30 16
#define EXP_OFFSET_25_V30 14
#define EXP_OFFSET_26_V30 12
#define EXP_OFFSET_27_V30 9
#define EXP_OFFSET_28_V30 6
#define EXP_OFFSET_29_V30 3
#define EXP_OFFSET_30_V30 0


//defines for nvar=31
#define EXP_1_V31 0xc000000000000000
#define EXP_2_V31 0x3000000000000000
#define EXP_3_V31 0x0c00000000000000
#define EXP_4_V31 0x0300000000000000
#define EXP_5_V31 0x00c0000000000000
#define EXP_6_V31 0x0030000000000000
#define EXP_7_V31 0x000c000000000000
#define EXP_8_V31 0x0003000000000000
#define EXP_9_V31 0x0000c00000000000
#define EXP_10_V31 0x0000300000000000
#define EXP_11_V31 0x00000c0000000000
#define EXP_12_V31 0x0000030000000000
#define EXP_13_V31 0x000000c000000000
#define EXP_14_V31 0x0000003000000000
#define EXP_15_V31 0x0000000c00000000
#define EXP_16_V31 0x0000000300000000
#define EXP_17_V31 0x00000000c0000000
#define EXP_18_V31 0x0000000030000000
#define EXP_19_V31 0x000000000c000000
#define EXP_20_V31 0x0000000003000000
#define EXP_21_V31 0x0000000000c00000
#define EXP_22_V31 0x0000000000300000
#define EXP_23_V31 0x00000000000c0000
#define EXP_24_V31 0x0000000000030000
#define EXP_25_V31 0x000000000000c000
#define EXP_26_V31 0x0000000000003000
#define EXP_27_V31 0x0000000000000c00
#define EXP_28_V31 0x0000000000000300
#define EXP_29_V31 0x00000000000000c0
#define EXP_30_V31 0x0000000000000038
#define EXP_31_V31 0x0000000000000007

#define MAX_EXP_1_V31 0xc
#define MAX_EXP_2_V31 0x3
#define MAX_EXP_3_V31 0xc
#define MAX_EXP_4_V31 0x3
#define MAX_EXP_5_V31 0xc
#define MAX_EXP_6_V31 0x3
#define MAX_EXP_7_V31 0xc
#define MAX_EXP_8_V31 0x3
#define MAX_EXP_9_V31 0xc
#define MAX_EXP_10_V31 0x3
#define MAX_EXP_11_V31 0xc
#define MAX_EXP_12_V31 0x3
#define MAX_EXP_13_V31 0xc
#define MAX_EXP_14_V31 0x3
#define MAX_EXP_15_V31 0xc
#define MAX_EXP_16_V31 0x3
#define MAX_EXP_17_V31 0xc
#define MAX_EXP_18_V31 0x3
#define MAX_EXP_19_V31 0xc
#define MAX_EXP_20_V31 0x3
#define MAX_EXP_21_V31 0xc
#define MAX_EXP_22_V31 0x3
#define MAX_EXP_23_V31 0xc
#define MAX_EXP_24_V31 0x3
#define MAX_EXP_25_V31 0xc
#define MAX_EXP_26_V31 0x3
#define MAX_EXP_27_V31 0xc
#define MAX_EXP_28_V31 0x3
#define MAX_EXP_29_V31 0xc
#define MAX_EXP_30_V31 0x38
#define MAX_EXP_31_V31 0x7

#define EXP_OFFSET_1_V31 62
#define EXP_OFFSET_2_V31 60
#define EXP_OFFSET_3_V31 58
#define EXP_OFFSET_4_V31 56
#define EXP_OFFSET_5_V31 54
#define EXP_OFFSET_6_V31 52
#define EXP_OFFSET_7_V31 50
#define EXP_OFFSET_8_V31 48
#define EXP_OFFSET_9_V31 46
#define EXP_OFFSET_10_V31 44
#define EXP_OFFSET_11_V31 42
#define EXP_OFFSET_12_V31 40
#define EXP_OFFSET_13_V31 38
#define EXP_OFFSET_14_V31 36
#define EXP_OFFSET_15_V31 34
#define EXP_OFFSET_16_V31 32
#define EXP_OFFSET_17_V31 30
#define EXP_OFFSET_18_V31 28
#define EXP_OFFSET_19_V31 26
#define EXP_OFFSET_20_V31 24
#define EXP_OFFSET_21_V31 22
#define EXP_OFFSET_22_V31 20
#define EXP_OFFSET_23_V31 18
#define EXP_OFFSET_24_V31 16
#define EXP_OFFSET_25_V31 14
#define EXP_OFFSET_26_V31 12
#define EXP_OFFSET_27_V31 10
#define EXP_OFFSET_28_V31 8
#define EXP_OFFSET_29_V31 6
#define EXP_OFFSET_30_V31 3
#define EXP_OFFSET_31_V31 0


//defines for nvar=32
#define EXP_1_V32 0xc000000000000000
#define EXP_2_V32 0x3000000000000000
#define EXP_3_V32 0x0c00000000000000
#define EXP_4_V32 0x0300000000000000
#define EXP_5_V32 0x00c0000000000000
#define EXP_6_V32 0x0030000000000000
#define EXP_7_V32 0x000c000000000000
#define EXP_8_V32 0x0003000000000000
#define EXP_9_V32 0x0000c00000000000
#define EXP_10_V32 0x0000300000000000
#define EXP_11_V32 0x00000c0000000000
#define EXP_12_V32 0x0000030000000000
#define EXP_13_V32 0x000000c000000000
#define EXP_14_V32 0x0000003000000000
#define EXP_15_V32 0x0000000c00000000
#define EXP_16_V32 0x0000000300000000
#define EXP_17_V32 0x00000000c0000000
#define EXP_18_V32 0x0000000030000000
#define EXP_19_V32 0x000000000c000000
#define EXP_20_V32 0x0000000003000000
#define EXP_21_V32 0x0000000000c00000
#define EXP_22_V32 0x0000000000300000
#define EXP_23_V32 0x00000000000c0000
#define EXP_24_V32 0x0000000000030000
#define EXP_25_V32 0x000000000000c000
#define EXP_26_V32 0x0000000000003000
#define EXP_27_V32 0x0000000000000c00
#define EXP_28_V32 0x0000000000000300
#define EXP_29_V32 0x00000000000000c0
#define EXP_30_V32 0x0000000000000030
#define EXP_31_V32 0x000000000000000c
#define EXP_32_V32 0x0000000000000003

#define MAX_EXP_1_V32 0xc
#define MAX_EXP_2_V32 0x3
#define MAX_EXP_3_V32 0xc
#define MAX_EXP_4_V32 0x3
#define MAX_EXP_5_V32 0xc
#define MAX_EXP_6_V32 0x3
#define MAX_EXP_7_V32 0xc
#define MAX_EXP_8_V32 0x3
#define MAX_EXP_9_V32 0xc
#define MAX_EXP_10_V32 0x3
#define MAX_EXP_11_V32 0xc
#define MAX_EXP_12_V32 0x3
#define MAX_EXP_13_V32 0xc
#define MAX_EXP_14_V32 0x3
#define MAX_EXP_15_V32 0xc
#define MAX_EXP_16_V32 0x3
#define MAX_EXP_17_V32 0xc
#define MAX_EXP_18_V32 0x3
#define MAX_EXP_19_V32 0xc
#define MAX_EXP_20_V32 0x3
#define MAX_EXP_21_V32 0xc
#define MAX_EXP_22_V32 0x3
#define MAX_EXP_23_V32 0xc
#define MAX_EXP_24_V32 0x3
#define MAX_EXP_25_V32 0xc
#define MAX_EXP_26_V32 0x3
#define MAX_EXP_27_V32 0xc
#define MAX_EXP_28_V32 0x3
#define MAX_EXP_29_V32 0xc
#define MAX_EXP_30_V32 0x3
#define MAX_EXP_31_V32 0xc
#define MAX_EXP_32_V32 0x3

#define EXP_OFFSET_1_V32 62
#define EXP_OFFSET_2_V32 60
#define EXP_OFFSET_3_V32 58
#define EXP_OFFSET_4_V32 56
#define EXP_OFFSET_5_V32 54
#define EXP_OFFSET_6_V32 52
#define EXP_OFFSET_7_V32 50
#define EXP_OFFSET_8_V32 48
#define EXP_OFFSET_9_V32 46
#define EXP_OFFSET_10_V32 44
#define EXP_OFFSET_11_V32 42
#define EXP_OFFSET_12_V32 40
#define EXP_OFFSET_13_V32 38
#define EXP_OFFSET_14_V32 36
#define EXP_OFFSET_15_V32 34
#define EXP_OFFSET_16_V32 32
#define EXP_OFFSET_17_V32 30
#define EXP_OFFSET_18_V32 28
#define EXP_OFFSET_19_V32 26
#define EXP_OFFSET_20_V32 24
#define EXP_OFFSET_21_V32 22
#define EXP_OFFSET_22_V32 20
#define EXP_OFFSET_23_V32 18
#define EXP_OFFSET_24_V32 16
#define EXP_OFFSET_25_V32 14
#define EXP_OFFSET_26_V32 12
#define EXP_OFFSET_27_V32 10
#define EXP_OFFSET_28_V32 8
#define EXP_OFFSET_29_V32 6
#define EXP_OFFSET_30_V32 4
#define EXP_OFFSET_31_V32 2
#define EXP_OFFSET_32_V32 0




typedef int (*DivTest_ptr)(degrees_t, degrees_t);

//monomial divide test for nvar 1
static inline int monomialDivideTest_1(degrees_t adegs, degrees_t bdegs) {
	return adegs >= bdegs;
}

//monomial divide test for nvar 2
static inline int monomialDivideTest_2(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V2) < (bdegs & EXP_1_V2) ||
			   (adegs & EXP_2_V2) < (bdegs & EXP_2_V2)  );
}

//monomial divide test for nvar 3
static inline int monomialDivideTest_3(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V3) < (bdegs & EXP_1_V3) ||
			   (adegs & EXP_2_V3) < (bdegs & EXP_2_V3) ||
			   (adegs & EXP_3_V3) < (bdegs & EXP_3_V3)  );
}

//monomial divide test for nvar 4
static inline int monomialDivideTest_4(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V4) < (bdegs & EXP_1_V4) ||
			   (adegs & EXP_2_V4) < (bdegs & EXP_2_V4) ||
			   (adegs & EXP_3_V4) < (bdegs & EXP_3_V4) ||
			   (adegs & EXP_4_V4) < (bdegs & EXP_4_V4)  );
}

//monomial divide test for nvar 5
static inline int monomialDivideTest_5(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V5) < (bdegs & EXP_1_V5) ||
			   (adegs & EXP_2_V5) < (bdegs & EXP_2_V5) ||
			   (adegs & EXP_3_V5) < (bdegs & EXP_3_V5) ||
			   (adegs & EXP_4_V5) < (bdegs & EXP_4_V5) ||
			   (adegs & EXP_5_V5) < (bdegs & EXP_5_V5)  );
}

//monomial divide test for nvar 6
static inline int monomialDivideTest_6(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V6) < (bdegs & EXP_1_V6) ||
			   (adegs & EXP_2_V6) < (bdegs & EXP_2_V6) ||
			   (adegs & EXP_3_V6) < (bdegs & EXP_3_V6) ||
			   (adegs & EXP_4_V6) < (bdegs & EXP_4_V6) ||
			   (adegs & EXP_5_V6) < (bdegs & EXP_5_V6) ||
			   (adegs & EXP_6_V6) < (bdegs & EXP_6_V6)  );
}

//monomial divide test for nvar 7
static inline int monomialDivideTest_7(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V7) < (bdegs & EXP_1_V7) ||
			   (adegs & EXP_2_V7) < (bdegs & EXP_2_V7) ||
			   (adegs & EXP_3_V7) < (bdegs & EXP_3_V7) ||
			   (adegs & EXP_4_V7) < (bdegs & EXP_4_V7) ||
			   (adegs & EXP_5_V7) < (bdegs & EXP_5_V7) ||
			   (adegs & EXP_6_V7) < (bdegs & EXP_6_V7) ||
			   (adegs & EXP_7_V7) < (bdegs & EXP_7_V7)  );
}

//monomial divide test for nvar 8
static inline int monomialDivideTest_8(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V8) < (bdegs & EXP_1_V8) ||
			   (adegs & EXP_2_V8) < (bdegs & EXP_2_V8) ||
			   (adegs & EXP_3_V8) < (bdegs & EXP_3_V8) ||
			   (adegs & EXP_4_V8) < (bdegs & EXP_4_V8) ||
			   (adegs & EXP_5_V8) < (bdegs & EXP_5_V8) ||
			   (adegs & EXP_6_V8) < (bdegs & EXP_6_V8) ||
			   (adegs & EXP_7_V8) < (bdegs & EXP_7_V8) ||
			   (adegs & EXP_8_V8) < (bdegs & EXP_8_V8)  );
}

//monomial divide test for nvar 9
static inline int monomialDivideTest_9(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V9) < (bdegs & EXP_1_V9) ||
			   (adegs & EXP_2_V9) < (bdegs & EXP_2_V9) ||
			   (adegs & EXP_3_V9) < (bdegs & EXP_3_V9) ||
			   (adegs & EXP_4_V9) < (bdegs & EXP_4_V9) ||
			   (adegs & EXP_5_V9) < (bdegs & EXP_5_V9) ||
			   (adegs & EXP_6_V9) < (bdegs & EXP_6_V9) ||
			   (adegs & EXP_7_V9) < (bdegs & EXP_7_V9) ||
			   (adegs & EXP_8_V9) < (bdegs & EXP_8_V9) ||
			   (adegs & EXP_9_V9) < (bdegs & EXP_9_V9)  );
}

//monomial divide test for nvar 10
static inline int monomialDivideTest_10(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V10) < (bdegs & EXP_1_V10) ||
			   (adegs & EXP_2_V10) < (bdegs & EXP_2_V10) ||
			   (adegs & EXP_3_V10) < (bdegs & EXP_3_V10) ||
			   (adegs & EXP_4_V10) < (bdegs & EXP_4_V10) ||
			   (adegs & EXP_5_V10) < (bdegs & EXP_5_V10) ||
			   (adegs & EXP_6_V10) < (bdegs & EXP_6_V10) ||
			   (adegs & EXP_7_V10) < (bdegs & EXP_7_V10) ||
			   (adegs & EXP_8_V10) < (bdegs & EXP_8_V10) ||
			   (adegs & EXP_9_V10) < (bdegs & EXP_9_V10) ||
			   (adegs & EXP_10_V10) < (bdegs & EXP_10_V10)  );
}

//monomial divide test for nvar 11
static inline int monomialDivideTest_11(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V11) < (bdegs & EXP_1_V11) ||
			   (adegs & EXP_2_V11) < (bdegs & EXP_2_V11) ||
			   (adegs & EXP_3_V11) < (bdegs & EXP_3_V11) ||
			   (adegs & EXP_4_V11) < (bdegs & EXP_4_V11) ||
			   (adegs & EXP_5_V11) < (bdegs & EXP_5_V11) ||
			   (adegs & EXP_6_V11) < (bdegs & EXP_6_V11) ||
			   (adegs & EXP_7_V11) < (bdegs & EXP_7_V11) ||
			   (adegs & EXP_8_V11) < (bdegs & EXP_8_V11) ||
			   (adegs & EXP_9_V11) < (bdegs & EXP_9_V11) ||
			   (adegs & EXP_10_V11) < (bdegs & EXP_10_V11) ||
			   (adegs & EXP_11_V11) < (bdegs & EXP_11_V11)  );
}

//monomial divide test for nvar 12
static inline int monomialDivideTest_12(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V12) < (bdegs & EXP_1_V12) ||
			   (adegs & EXP_2_V12) < (bdegs & EXP_2_V12) ||
			   (adegs & EXP_3_V12) < (bdegs & EXP_3_V12) ||
			   (adegs & EXP_4_V12) < (bdegs & EXP_4_V12) ||
			   (adegs & EXP_5_V12) < (bdegs & EXP_5_V12) ||
			   (adegs & EXP_6_V12) < (bdegs & EXP_6_V12) ||
			   (adegs & EXP_7_V12) < (bdegs & EXP_7_V12) ||
			   (adegs & EXP_8_V12) < (bdegs & EXP_8_V12) ||
			   (adegs & EXP_9_V12) < (bdegs & EXP_9_V12) ||
			   (adegs & EXP_10_V12) < (bdegs & EXP_10_V12) ||
			   (adegs & EXP_11_V12) < (bdegs & EXP_11_V12) ||
			   (adegs & EXP_12_V12) < (bdegs & EXP_12_V12)  );
}

//monomial divide test for nvar 13
static inline int monomialDivideTest_13(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V13) < (bdegs & EXP_1_V13) ||
			   (adegs & EXP_2_V13) < (bdegs & EXP_2_V13) ||
			   (adegs & EXP_3_V13) < (bdegs & EXP_3_V13) ||
			   (adegs & EXP_4_V13) < (bdegs & EXP_4_V13) ||
			   (adegs & EXP_5_V13) < (bdegs & EXP_5_V13) ||
			   (adegs & EXP_6_V13) < (bdegs & EXP_6_V13) ||
			   (adegs & EXP_7_V13) < (bdegs & EXP_7_V13) ||
			   (adegs & EXP_8_V13) < (bdegs & EXP_8_V13) ||
			   (adegs & EXP_9_V13) < (bdegs & EXP_9_V13) ||
			   (adegs & EXP_10_V13) < (bdegs & EXP_10_V13) ||
			   (adegs & EXP_11_V13) < (bdegs & EXP_11_V13) ||
			   (adegs & EXP_12_V13) < (bdegs & EXP_12_V13) ||
			   (adegs & EXP_13_V13) < (bdegs & EXP_13_V13)  );
}

//monomial divide test for nvar 14
static inline int monomialDivideTest_14(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V14) < (bdegs & EXP_1_V14) ||
			   (adegs & EXP_2_V14) < (bdegs & EXP_2_V14) ||
			   (adegs & EXP_3_V14) < (bdegs & EXP_3_V14) ||
			   (adegs & EXP_4_V14) < (bdegs & EXP_4_V14) ||
			   (adegs & EXP_5_V14) < (bdegs & EXP_5_V14) ||
			   (adegs & EXP_6_V14) < (bdegs & EXP_6_V14) ||
			   (adegs & EXP_7_V14) < (bdegs & EXP_7_V14) ||
			   (adegs & EXP_8_V14) < (bdegs & EXP_8_V14) ||
			   (adegs & EXP_9_V14) < (bdegs & EXP_9_V14) ||
			   (adegs & EXP_10_V14) < (bdegs & EXP_10_V14) ||
			   (adegs & EXP_11_V14) < (bdegs & EXP_11_V14) ||
			   (adegs & EXP_12_V14) < (bdegs & EXP_12_V14) ||
			   (adegs & EXP_13_V14) < (bdegs & EXP_13_V14) ||
			   (adegs & EXP_14_V14) < (bdegs & EXP_14_V14)  );
}

//monomial divide test for nvar 15
static inline int monomialDivideTest_15(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V15) < (bdegs & EXP_1_V15) ||
			   (adegs & EXP_2_V15) < (bdegs & EXP_2_V15) ||
			   (adegs & EXP_3_V15) < (bdegs & EXP_3_V15) ||
			   (adegs & EXP_4_V15) < (bdegs & EXP_4_V15) ||
			   (adegs & EXP_5_V15) < (bdegs & EXP_5_V15) ||
			   (adegs & EXP_6_V15) < (bdegs & EXP_6_V15) ||
			   (adegs & EXP_7_V15) < (bdegs & EXP_7_V15) ||
			   (adegs & EXP_8_V15) < (bdegs & EXP_8_V15) ||
			   (adegs & EXP_9_V15) < (bdegs & EXP_9_V15) ||
			   (adegs & EXP_10_V15) < (bdegs & EXP_10_V15) ||
			   (adegs & EXP_11_V15) < (bdegs & EXP_11_V15) ||
			   (adegs & EXP_12_V15) < (bdegs & EXP_12_V15) ||
			   (adegs & EXP_13_V15) < (bdegs & EXP_13_V15) ||
			   (adegs & EXP_14_V15) < (bdegs & EXP_14_V15) ||
			   (adegs & EXP_15_V15) < (bdegs & EXP_15_V15)  );
}

//monomial divide test for nvar 16
static inline int monomialDivideTest_16(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V16) < (bdegs & EXP_1_V16) ||
			   (adegs & EXP_2_V16) < (bdegs & EXP_2_V16) ||
			   (adegs & EXP_3_V16) < (bdegs & EXP_3_V16) ||
			   (adegs & EXP_4_V16) < (bdegs & EXP_4_V16) ||
			   (adegs & EXP_5_V16) < (bdegs & EXP_5_V16) ||
			   (adegs & EXP_6_V16) < (bdegs & EXP_6_V16) ||
			   (adegs & EXP_7_V16) < (bdegs & EXP_7_V16) ||
			   (adegs & EXP_8_V16) < (bdegs & EXP_8_V16) ||
			   (adegs & EXP_9_V16) < (bdegs & EXP_9_V16) ||
			   (adegs & EXP_10_V16) < (bdegs & EXP_10_V16) ||
			   (adegs & EXP_11_V16) < (bdegs & EXP_11_V16) ||
			   (adegs & EXP_12_V16) < (bdegs & EXP_12_V16) ||
			   (adegs & EXP_13_V16) < (bdegs & EXP_13_V16) ||
			   (adegs & EXP_14_V16) < (bdegs & EXP_14_V16) ||
			   (adegs & EXP_15_V16) < (bdegs & EXP_15_V16) ||
			   (adegs & EXP_16_V16) < (bdegs & EXP_16_V16)  );
}

//monomial divide test for nvar 17
static inline int monomialDivideTest_17(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V17) < (bdegs & EXP_1_V17) ||
			   (adegs & EXP_2_V17) < (bdegs & EXP_2_V17) ||
			   (adegs & EXP_3_V17) < (bdegs & EXP_3_V17) ||
			   (adegs & EXP_4_V17) < (bdegs & EXP_4_V17) ||
			   (adegs & EXP_5_V17) < (bdegs & EXP_5_V17) ||
			   (adegs & EXP_6_V17) < (bdegs & EXP_6_V17) ||
			   (adegs & EXP_7_V17) < (bdegs & EXP_7_V17) ||
			   (adegs & EXP_8_V17) < (bdegs & EXP_8_V17) ||
			   (adegs & EXP_9_V17) < (bdegs & EXP_9_V17) ||
			   (adegs & EXP_10_V17) < (bdegs & EXP_10_V17) ||
			   (adegs & EXP_11_V17) < (bdegs & EXP_11_V17) ||
			   (adegs & EXP_12_V17) < (bdegs & EXP_12_V17) ||
			   (adegs & EXP_13_V17) < (bdegs & EXP_13_V17) ||
			   (adegs & EXP_14_V17) < (bdegs & EXP_14_V17) ||
			   (adegs & EXP_15_V17) < (bdegs & EXP_15_V17) ||
			   (adegs & EXP_16_V17) < (bdegs & EXP_16_V17) ||
			   (adegs & EXP_17_V17) < (bdegs & EXP_17_V17)  );
}

//monomial divide test for nvar 18
static inline int monomialDivideTest_18(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V18) < (bdegs & EXP_1_V18) ||
			   (adegs & EXP_2_V18) < (bdegs & EXP_2_V18) ||
			   (adegs & EXP_3_V18) < (bdegs & EXP_3_V18) ||
			   (adegs & EXP_4_V18) < (bdegs & EXP_4_V18) ||
			   (adegs & EXP_5_V18) < (bdegs & EXP_5_V18) ||
			   (adegs & EXP_6_V18) < (bdegs & EXP_6_V18) ||
			   (adegs & EXP_7_V18) < (bdegs & EXP_7_V18) ||
			   (adegs & EXP_8_V18) < (bdegs & EXP_8_V18) ||
			   (adegs & EXP_9_V18) < (bdegs & EXP_9_V18) ||
			   (adegs & EXP_10_V18) < (bdegs & EXP_10_V18) ||
			   (adegs & EXP_11_V18) < (bdegs & EXP_11_V18) ||
			   (adegs & EXP_12_V18) < (bdegs & EXP_12_V18) ||
			   (adegs & EXP_13_V18) < (bdegs & EXP_13_V18) ||
			   (adegs & EXP_14_V18) < (bdegs & EXP_14_V18) ||
			   (adegs & EXP_15_V18) < (bdegs & EXP_15_V18) ||
			   (adegs & EXP_16_V18) < (bdegs & EXP_16_V18) ||
			   (adegs & EXP_17_V18) < (bdegs & EXP_17_V18) ||
			   (adegs & EXP_18_V18) < (bdegs & EXP_18_V18)  );
}

//monomial divide test for nvar 19
static inline int monomialDivideTest_19(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V19) < (bdegs & EXP_1_V19) ||
			   (adegs & EXP_2_V19) < (bdegs & EXP_2_V19) ||
			   (adegs & EXP_3_V19) < (bdegs & EXP_3_V19) ||
			   (adegs & EXP_4_V19) < (bdegs & EXP_4_V19) ||
			   (adegs & EXP_5_V19) < (bdegs & EXP_5_V19) ||
			   (adegs & EXP_6_V19) < (bdegs & EXP_6_V19) ||
			   (adegs & EXP_7_V19) < (bdegs & EXP_7_V19) ||
			   (adegs & EXP_8_V19) < (bdegs & EXP_8_V19) ||
			   (adegs & EXP_9_V19) < (bdegs & EXP_9_V19) ||
			   (adegs & EXP_10_V19) < (bdegs & EXP_10_V19) ||
			   (adegs & EXP_11_V19) < (bdegs & EXP_11_V19) ||
			   (adegs & EXP_12_V19) < (bdegs & EXP_12_V19) ||
			   (adegs & EXP_13_V19) < (bdegs & EXP_13_V19) ||
			   (adegs & EXP_14_V19) < (bdegs & EXP_14_V19) ||
			   (adegs & EXP_15_V19) < (bdegs & EXP_15_V19) ||
			   (adegs & EXP_16_V19) < (bdegs & EXP_16_V19) ||
			   (adegs & EXP_17_V19) < (bdegs & EXP_17_V19) ||
			   (adegs & EXP_18_V19) < (bdegs & EXP_18_V19) ||
			   (adegs & EXP_19_V19) < (bdegs & EXP_19_V19)  );
}

//monomial divide test for nvar 20
static inline int monomialDivideTest_20(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V20) < (bdegs & EXP_1_V20) ||
			   (adegs & EXP_2_V20) < (bdegs & EXP_2_V20) ||
			   (adegs & EXP_3_V20) < (bdegs & EXP_3_V20) ||
			   (adegs & EXP_4_V20) < (bdegs & EXP_4_V20) ||
			   (adegs & EXP_5_V20) < (bdegs & EXP_5_V20) ||
			   (adegs & EXP_6_V20) < (bdegs & EXP_6_V20) ||
			   (adegs & EXP_7_V20) < (bdegs & EXP_7_V20) ||
			   (adegs & EXP_8_V20) < (bdegs & EXP_8_V20) ||
			   (adegs & EXP_9_V20) < (bdegs & EXP_9_V20) ||
			   (adegs & EXP_10_V20) < (bdegs & EXP_10_V20) ||
			   (adegs & EXP_11_V20) < (bdegs & EXP_11_V20) ||
			   (adegs & EXP_12_V20) < (bdegs & EXP_12_V20) ||
			   (adegs & EXP_13_V20) < (bdegs & EXP_13_V20) ||
			   (adegs & EXP_14_V20) < (bdegs & EXP_14_V20) ||
			   (adegs & EXP_15_V20) < (bdegs & EXP_15_V20) ||
			   (adegs & EXP_16_V20) < (bdegs & EXP_16_V20) ||
			   (adegs & EXP_17_V20) < (bdegs & EXP_17_V20) ||
			   (adegs & EXP_18_V20) < (bdegs & EXP_18_V20) ||
			   (adegs & EXP_19_V20) < (bdegs & EXP_19_V20) ||
			   (adegs & EXP_20_V20) < (bdegs & EXP_20_V20)  );
}

//monomial divide test for nvar 21
static inline int monomialDivideTest_21(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V21) < (bdegs & EXP_1_V21) ||
			   (adegs & EXP_2_V21) < (bdegs & EXP_2_V21) ||
			   (adegs & EXP_3_V21) < (bdegs & EXP_3_V21) ||
			   (adegs & EXP_4_V21) < (bdegs & EXP_4_V21) ||
			   (adegs & EXP_5_V21) < (bdegs & EXP_5_V21) ||
			   (adegs & EXP_6_V21) < (bdegs & EXP_6_V21) ||
			   (adegs & EXP_7_V21) < (bdegs & EXP_7_V21) ||
			   (adegs & EXP_8_V21) < (bdegs & EXP_8_V21) ||
			   (adegs & EXP_9_V21) < (bdegs & EXP_9_V21) ||
			   (adegs & EXP_10_V21) < (bdegs & EXP_10_V21) ||
			   (adegs & EXP_11_V21) < (bdegs & EXP_11_V21) ||
			   (adegs & EXP_12_V21) < (bdegs & EXP_12_V21) ||
			   (adegs & EXP_13_V21) < (bdegs & EXP_13_V21) ||
			   (adegs & EXP_14_V21) < (bdegs & EXP_14_V21) ||
			   (adegs & EXP_15_V21) < (bdegs & EXP_15_V21) ||
			   (adegs & EXP_16_V21) < (bdegs & EXP_16_V21) ||
			   (adegs & EXP_17_V21) < (bdegs & EXP_17_V21) ||
			   (adegs & EXP_18_V21) < (bdegs & EXP_18_V21) ||
			   (adegs & EXP_19_V21) < (bdegs & EXP_19_V21) ||
			   (adegs & EXP_20_V21) < (bdegs & EXP_20_V21) ||
			   (adegs & EXP_21_V21) < (bdegs & EXP_21_V21)  );
}

//monomial divide test for nvar 22
static inline int monomialDivideTest_22(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V22) < (bdegs & EXP_1_V22) ||
			   (adegs & EXP_2_V22) < (bdegs & EXP_2_V22) ||
			   (adegs & EXP_3_V22) < (bdegs & EXP_3_V22) ||
			   (adegs & EXP_4_V22) < (bdegs & EXP_4_V22) ||
			   (adegs & EXP_5_V22) < (bdegs & EXP_5_V22) ||
			   (adegs & EXP_6_V22) < (bdegs & EXP_6_V22) ||
			   (adegs & EXP_7_V22) < (bdegs & EXP_7_V22) ||
			   (adegs & EXP_8_V22) < (bdegs & EXP_8_V22) ||
			   (adegs & EXP_9_V22) < (bdegs & EXP_9_V22) ||
			   (adegs & EXP_10_V22) < (bdegs & EXP_10_V22) ||
			   (adegs & EXP_11_V22) < (bdegs & EXP_11_V22) ||
			   (adegs & EXP_12_V22) < (bdegs & EXP_12_V22) ||
			   (adegs & EXP_13_V22) < (bdegs & EXP_13_V22) ||
			   (adegs & EXP_14_V22) < (bdegs & EXP_14_V22) ||
			   (adegs & EXP_15_V22) < (bdegs & EXP_15_V22) ||
			   (adegs & EXP_16_V22) < (bdegs & EXP_16_V22) ||
			   (adegs & EXP_17_V22) < (bdegs & EXP_17_V22) ||
			   (adegs & EXP_18_V22) < (bdegs & EXP_18_V22) ||
			   (adegs & EXP_19_V22) < (bdegs & EXP_19_V22) ||
			   (adegs & EXP_20_V22) < (bdegs & EXP_20_V22) ||
			   (adegs & EXP_21_V22) < (bdegs & EXP_21_V22) ||
			   (adegs & EXP_22_V22) < (bdegs & EXP_22_V22)  );
}

//monomial divide test for nvar 23
static inline int monomialDivideTest_23(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V23) < (bdegs & EXP_1_V23) ||
			   (adegs & EXP_2_V23) < (bdegs & EXP_2_V23) ||
			   (adegs & EXP_3_V23) < (bdegs & EXP_3_V23) ||
			   (adegs & EXP_4_V23) < (bdegs & EXP_4_V23) ||
			   (adegs & EXP_5_V23) < (bdegs & EXP_5_V23) ||
			   (adegs & EXP_6_V23) < (bdegs & EXP_6_V23) ||
			   (adegs & EXP_7_V23) < (bdegs & EXP_7_V23) ||
			   (adegs & EXP_8_V23) < (bdegs & EXP_8_V23) ||
			   (adegs & EXP_9_V23) < (bdegs & EXP_9_V23) ||
			   (adegs & EXP_10_V23) < (bdegs & EXP_10_V23) ||
			   (adegs & EXP_11_V23) < (bdegs & EXP_11_V23) ||
			   (adegs & EXP_12_V23) < (bdegs & EXP_12_V23) ||
			   (adegs & EXP_13_V23) < (bdegs & EXP_13_V23) ||
			   (adegs & EXP_14_V23) < (bdegs & EXP_14_V23) ||
			   (adegs & EXP_15_V23) < (bdegs & EXP_15_V23) ||
			   (adegs & EXP_16_V23) < (bdegs & EXP_16_V23) ||
			   (adegs & EXP_17_V23) < (bdegs & EXP_17_V23) ||
			   (adegs & EXP_18_V23) < (bdegs & EXP_18_V23) ||
			   (adegs & EXP_19_V23) < (bdegs & EXP_19_V23) ||
			   (adegs & EXP_20_V23) < (bdegs & EXP_20_V23) ||
			   (adegs & EXP_21_V23) < (bdegs & EXP_21_V23) ||
			   (adegs & EXP_22_V23) < (bdegs & EXP_22_V23) ||
			   (adegs & EXP_23_V23) < (bdegs & EXP_23_V23)  );
}

//monomial divide test for nvar 24
static inline int monomialDivideTest_24(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V24) < (bdegs & EXP_1_V24) ||
			   (adegs & EXP_2_V24) < (bdegs & EXP_2_V24) ||
			   (adegs & EXP_3_V24) < (bdegs & EXP_3_V24) ||
			   (adegs & EXP_4_V24) < (bdegs & EXP_4_V24) ||
			   (adegs & EXP_5_V24) < (bdegs & EXP_5_V24) ||
			   (adegs & EXP_6_V24) < (bdegs & EXP_6_V24) ||
			   (adegs & EXP_7_V24) < (bdegs & EXP_7_V24) ||
			   (adegs & EXP_8_V24) < (bdegs & EXP_8_V24) ||
			   (adegs & EXP_9_V24) < (bdegs & EXP_9_V24) ||
			   (adegs & EXP_10_V24) < (bdegs & EXP_10_V24) ||
			   (adegs & EXP_11_V24) < (bdegs & EXP_11_V24) ||
			   (adegs & EXP_12_V24) < (bdegs & EXP_12_V24) ||
			   (adegs & EXP_13_V24) < (bdegs & EXP_13_V24) ||
			   (adegs & EXP_14_V24) < (bdegs & EXP_14_V24) ||
			   (adegs & EXP_15_V24) < (bdegs & EXP_15_V24) ||
			   (adegs & EXP_16_V24) < (bdegs & EXP_16_V24) ||
			   (adegs & EXP_17_V24) < (bdegs & EXP_17_V24) ||
			   (adegs & EXP_18_V24) < (bdegs & EXP_18_V24) ||
			   (adegs & EXP_19_V24) < (bdegs & EXP_19_V24) ||
			   (adegs & EXP_20_V24) < (bdegs & EXP_20_V24) ||
			   (adegs & EXP_21_V24) < (bdegs & EXP_21_V24) ||
			   (adegs & EXP_22_V24) < (bdegs & EXP_22_V24) ||
			   (adegs & EXP_23_V24) < (bdegs & EXP_23_V24) ||
			   (adegs & EXP_24_V24) < (bdegs & EXP_24_V24)  );
}

//monomial divide test for nvar 25
static inline int monomialDivideTest_25(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V25) < (bdegs & EXP_1_V25) ||
			   (adegs & EXP_2_V25) < (bdegs & EXP_2_V25) ||
			   (adegs & EXP_3_V25) < (bdegs & EXP_3_V25) ||
			   (adegs & EXP_4_V25) < (bdegs & EXP_4_V25) ||
			   (adegs & EXP_5_V25) < (bdegs & EXP_5_V25) ||
			   (adegs & EXP_6_V25) < (bdegs & EXP_6_V25) ||
			   (adegs & EXP_7_V25) < (bdegs & EXP_7_V25) ||
			   (adegs & EXP_8_V25) < (bdegs & EXP_8_V25) ||
			   (adegs & EXP_9_V25) < (bdegs & EXP_9_V25) ||
			   (adegs & EXP_10_V25) < (bdegs & EXP_10_V25) ||
			   (adegs & EXP_11_V25) < (bdegs & EXP_11_V25) ||
			   (adegs & EXP_12_V25) < (bdegs & EXP_12_V25) ||
			   (adegs & EXP_13_V25) < (bdegs & EXP_13_V25) ||
			   (adegs & EXP_14_V25) < (bdegs & EXP_14_V25) ||
			   (adegs & EXP_15_V25) < (bdegs & EXP_15_V25) ||
			   (adegs & EXP_16_V25) < (bdegs & EXP_16_V25) ||
			   (adegs & EXP_17_V25) < (bdegs & EXP_17_V25) ||
			   (adegs & EXP_18_V25) < (bdegs & EXP_18_V25) ||
			   (adegs & EXP_19_V25) < (bdegs & EXP_19_V25) ||
			   (adegs & EXP_20_V25) < (bdegs & EXP_20_V25) ||
			   (adegs & EXP_21_V25) < (bdegs & EXP_21_V25) ||
			   (adegs & EXP_22_V25) < (bdegs & EXP_22_V25) ||
			   (adegs & EXP_23_V25) < (bdegs & EXP_23_V25) ||
			   (adegs & EXP_24_V25) < (bdegs & EXP_24_V25) ||
			   (adegs & EXP_25_V25) < (bdegs & EXP_25_V25)  );
}

//monomial divide test for nvar 26
static inline int monomialDivideTest_26(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V26) < (bdegs & EXP_1_V26) ||
			   (adegs & EXP_2_V26) < (bdegs & EXP_2_V26) ||
			   (adegs & EXP_3_V26) < (bdegs & EXP_3_V26) ||
			   (adegs & EXP_4_V26) < (bdegs & EXP_4_V26) ||
			   (adegs & EXP_5_V26) < (bdegs & EXP_5_V26) ||
			   (adegs & EXP_6_V26) < (bdegs & EXP_6_V26) ||
			   (adegs & EXP_7_V26) < (bdegs & EXP_7_V26) ||
			   (adegs & EXP_8_V26) < (bdegs & EXP_8_V26) ||
			   (adegs & EXP_9_V26) < (bdegs & EXP_9_V26) ||
			   (adegs & EXP_10_V26) < (bdegs & EXP_10_V26) ||
			   (adegs & EXP_11_V26) < (bdegs & EXP_11_V26) ||
			   (adegs & EXP_12_V26) < (bdegs & EXP_12_V26) ||
			   (adegs & EXP_13_V26) < (bdegs & EXP_13_V26) ||
			   (adegs & EXP_14_V26) < (bdegs & EXP_14_V26) ||
			   (adegs & EXP_15_V26) < (bdegs & EXP_15_V26) ||
			   (adegs & EXP_16_V26) < (bdegs & EXP_16_V26) ||
			   (adegs & EXP_17_V26) < (bdegs & EXP_17_V26) ||
			   (adegs & EXP_18_V26) < (bdegs & EXP_18_V26) ||
			   (adegs & EXP_19_V26) < (bdegs & EXP_19_V26) ||
			   (adegs & EXP_20_V26) < (bdegs & EXP_20_V26) ||
			   (adegs & EXP_21_V26) < (bdegs & EXP_21_V26) ||
			   (adegs & EXP_22_V26) < (bdegs & EXP_22_V26) ||
			   (adegs & EXP_23_V26) < (bdegs & EXP_23_V26) ||
			   (adegs & EXP_24_V26) < (bdegs & EXP_24_V26) ||
			   (adegs & EXP_25_V26) < (bdegs & EXP_25_V26) ||
			   (adegs & EXP_26_V26) < (bdegs & EXP_26_V26)  );
}

//monomial divide test for nvar 27
static inline int monomialDivideTest_27(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V27) < (bdegs & EXP_1_V27) ||
			   (adegs & EXP_2_V27) < (bdegs & EXP_2_V27) ||
			   (adegs & EXP_3_V27) < (bdegs & EXP_3_V27) ||
			   (adegs & EXP_4_V27) < (bdegs & EXP_4_V27) ||
			   (adegs & EXP_5_V27) < (bdegs & EXP_5_V27) ||
			   (adegs & EXP_6_V27) < (bdegs & EXP_6_V27) ||
			   (adegs & EXP_7_V27) < (bdegs & EXP_7_V27) ||
			   (adegs & EXP_8_V27) < (bdegs & EXP_8_V27) ||
			   (adegs & EXP_9_V27) < (bdegs & EXP_9_V27) ||
			   (adegs & EXP_10_V27) < (bdegs & EXP_10_V27) ||
			   (adegs & EXP_11_V27) < (bdegs & EXP_11_V27) ||
			   (adegs & EXP_12_V27) < (bdegs & EXP_12_V27) ||
			   (adegs & EXP_13_V27) < (bdegs & EXP_13_V27) ||
			   (adegs & EXP_14_V27) < (bdegs & EXP_14_V27) ||
			   (adegs & EXP_15_V27) < (bdegs & EXP_15_V27) ||
			   (adegs & EXP_16_V27) < (bdegs & EXP_16_V27) ||
			   (adegs & EXP_17_V27) < (bdegs & EXP_17_V27) ||
			   (adegs & EXP_18_V27) < (bdegs & EXP_18_V27) ||
			   (adegs & EXP_19_V27) < (bdegs & EXP_19_V27) ||
			   (adegs & EXP_20_V27) < (bdegs & EXP_20_V27) ||
			   (adegs & EXP_21_V27) < (bdegs & EXP_21_V27) ||
			   (adegs & EXP_22_V27) < (bdegs & EXP_22_V27) ||
			   (adegs & EXP_23_V27) < (bdegs & EXP_23_V27) ||
			   (adegs & EXP_24_V27) < (bdegs & EXP_24_V27) ||
			   (adegs & EXP_25_V27) < (bdegs & EXP_25_V27) ||
			   (adegs & EXP_26_V27) < (bdegs & EXP_26_V27) ||
			   (adegs & EXP_27_V27) < (bdegs & EXP_27_V27)  );
}

//monomial divide test for nvar 28
static inline int monomialDivideTest_28(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V28) < (bdegs & EXP_1_V28) ||
			   (adegs & EXP_2_V28) < (bdegs & EXP_2_V28) ||
			   (adegs & EXP_3_V28) < (bdegs & EXP_3_V28) ||
			   (adegs & EXP_4_V28) < (bdegs & EXP_4_V28) ||
			   (adegs & EXP_5_V28) < (bdegs & EXP_5_V28) ||
			   (adegs & EXP_6_V28) < (bdegs & EXP_6_V28) ||
			   (adegs & EXP_7_V28) < (bdegs & EXP_7_V28) ||
			   (adegs & EXP_8_V28) < (bdegs & EXP_8_V28) ||
			   (adegs & EXP_9_V28) < (bdegs & EXP_9_V28) ||
			   (adegs & EXP_10_V28) < (bdegs & EXP_10_V28) ||
			   (adegs & EXP_11_V28) < (bdegs & EXP_11_V28) ||
			   (adegs & EXP_12_V28) < (bdegs & EXP_12_V28) ||
			   (adegs & EXP_13_V28) < (bdegs & EXP_13_V28) ||
			   (adegs & EXP_14_V28) < (bdegs & EXP_14_V28) ||
			   (adegs & EXP_15_V28) < (bdegs & EXP_15_V28) ||
			   (adegs & EXP_16_V28) < (bdegs & EXP_16_V28) ||
			   (adegs & EXP_17_V28) < (bdegs & EXP_17_V28) ||
			   (adegs & EXP_18_V28) < (bdegs & EXP_18_V28) ||
			   (adegs & EXP_19_V28) < (bdegs & EXP_19_V28) ||
			   (adegs & EXP_20_V28) < (bdegs & EXP_20_V28) ||
			   (adegs & EXP_21_V28) < (bdegs & EXP_21_V28) ||
			   (adegs & EXP_22_V28) < (bdegs & EXP_22_V28) ||
			   (adegs & EXP_23_V28) < (bdegs & EXP_23_V28) ||
			   (adegs & EXP_24_V28) < (bdegs & EXP_24_V28) ||
			   (adegs & EXP_25_V28) < (bdegs & EXP_25_V28) ||
			   (adegs & EXP_26_V28) < (bdegs & EXP_26_V28) ||
			   (adegs & EXP_27_V28) < (bdegs & EXP_27_V28) ||
			   (adegs & EXP_28_V28) < (bdegs & EXP_28_V28)  );
}

//monomial divide test for nvar 29
static inline int monomialDivideTest_29(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V29) < (bdegs & EXP_1_V29) ||
			   (adegs & EXP_2_V29) < (bdegs & EXP_2_V29) ||
			   (adegs & EXP_3_V29) < (bdegs & EXP_3_V29) ||
			   (adegs & EXP_4_V29) < (bdegs & EXP_4_V29) ||
			   (adegs & EXP_5_V29) < (bdegs & EXP_5_V29) ||
			   (adegs & EXP_6_V29) < (bdegs & EXP_6_V29) ||
			   (adegs & EXP_7_V29) < (bdegs & EXP_7_V29) ||
			   (adegs & EXP_8_V29) < (bdegs & EXP_8_V29) ||
			   (adegs & EXP_9_V29) < (bdegs & EXP_9_V29) ||
			   (adegs & EXP_10_V29) < (bdegs & EXP_10_V29) ||
			   (adegs & EXP_11_V29) < (bdegs & EXP_11_V29) ||
			   (adegs & EXP_12_V29) < (bdegs & EXP_12_V29) ||
			   (adegs & EXP_13_V29) < (bdegs & EXP_13_V29) ||
			   (adegs & EXP_14_V29) < (bdegs & EXP_14_V29) ||
			   (adegs & EXP_15_V29) < (bdegs & EXP_15_V29) ||
			   (adegs & EXP_16_V29) < (bdegs & EXP_16_V29) ||
			   (adegs & EXP_17_V29) < (bdegs & EXP_17_V29) ||
			   (adegs & EXP_18_V29) < (bdegs & EXP_18_V29) ||
			   (adegs & EXP_19_V29) < (bdegs & EXP_19_V29) ||
			   (adegs & EXP_20_V29) < (bdegs & EXP_20_V29) ||
			   (adegs & EXP_21_V29) < (bdegs & EXP_21_V29) ||
			   (adegs & EXP_22_V29) < (bdegs & EXP_22_V29) ||
			   (adegs & EXP_23_V29) < (bdegs & EXP_23_V29) ||
			   (adegs & EXP_24_V29) < (bdegs & EXP_24_V29) ||
			   (adegs & EXP_25_V29) < (bdegs & EXP_25_V29) ||
			   (adegs & EXP_26_V29) < (bdegs & EXP_26_V29) ||
			   (adegs & EXP_27_V29) < (bdegs & EXP_27_V29) ||
			   (adegs & EXP_28_V29) < (bdegs & EXP_28_V29) ||
			   (adegs & EXP_29_V29) < (bdegs & EXP_29_V29)  );
}

//monomial divide test for nvar 30
static inline int monomialDivideTest_30(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V30) < (bdegs & EXP_1_V30) ||
			   (adegs & EXP_2_V30) < (bdegs & EXP_2_V30) ||
			   (adegs & EXP_3_V30) < (bdegs & EXP_3_V30) ||
			   (adegs & EXP_4_V30) < (bdegs & EXP_4_V30) ||
			   (adegs & EXP_5_V30) < (bdegs & EXP_5_V30) ||
			   (adegs & EXP_6_V30) < (bdegs & EXP_6_V30) ||
			   (adegs & EXP_7_V30) < (bdegs & EXP_7_V30) ||
			   (adegs & EXP_8_V30) < (bdegs & EXP_8_V30) ||
			   (adegs & EXP_9_V30) < (bdegs & EXP_9_V30) ||
			   (adegs & EXP_10_V30) < (bdegs & EXP_10_V30) ||
			   (adegs & EXP_11_V30) < (bdegs & EXP_11_V30) ||
			   (adegs & EXP_12_V30) < (bdegs & EXP_12_V30) ||
			   (adegs & EXP_13_V30) < (bdegs & EXP_13_V30) ||
			   (adegs & EXP_14_V30) < (bdegs & EXP_14_V30) ||
			   (adegs & EXP_15_V30) < (bdegs & EXP_15_V30) ||
			   (adegs & EXP_16_V30) < (bdegs & EXP_16_V30) ||
			   (adegs & EXP_17_V30) < (bdegs & EXP_17_V30) ||
			   (adegs & EXP_18_V30) < (bdegs & EXP_18_V30) ||
			   (adegs & EXP_19_V30) < (bdegs & EXP_19_V30) ||
			   (adegs & EXP_20_V30) < (bdegs & EXP_20_V30) ||
			   (adegs & EXP_21_V30) < (bdegs & EXP_21_V30) ||
			   (adegs & EXP_22_V30) < (bdegs & EXP_22_V30) ||
			   (adegs & EXP_23_V30) < (bdegs & EXP_23_V30) ||
			   (adegs & EXP_24_V30) < (bdegs & EXP_24_V30) ||
			   (adegs & EXP_25_V30) < (bdegs & EXP_25_V30) ||
			   (adegs & EXP_26_V30) < (bdegs & EXP_26_V30) ||
			   (adegs & EXP_27_V30) < (bdegs & EXP_27_V30) ||
			   (adegs & EXP_28_V30) < (bdegs & EXP_28_V30) ||
			   (adegs & EXP_29_V30) < (bdegs & EXP_29_V30) ||
			   (adegs & EXP_30_V30) < (bdegs & EXP_30_V30)  );
}

//monomial divide test for nvar 31
static inline int monomialDivideTest_31(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V31) < (bdegs & EXP_1_V31) ||
			   (adegs & EXP_2_V31) < (bdegs & EXP_2_V31) ||
			   (adegs & EXP_3_V31) < (bdegs & EXP_3_V31) ||
			   (adegs & EXP_4_V31) < (bdegs & EXP_4_V31) ||
			   (adegs & EXP_5_V31) < (bdegs & EXP_5_V31) ||
			   (adegs & EXP_6_V31) < (bdegs & EXP_6_V31) ||
			   (adegs & EXP_7_V31) < (bdegs & EXP_7_V31) ||
			   (adegs & EXP_8_V31) < (bdegs & EXP_8_V31) ||
			   (adegs & EXP_9_V31) < (bdegs & EXP_9_V31) ||
			   (adegs & EXP_10_V31) < (bdegs & EXP_10_V31) ||
			   (adegs & EXP_11_V31) < (bdegs & EXP_11_V31) ||
			   (adegs & EXP_12_V31) < (bdegs & EXP_12_V31) ||
			   (adegs & EXP_13_V31) < (bdegs & EXP_13_V31) ||
			   (adegs & EXP_14_V31) < (bdegs & EXP_14_V31) ||
			   (adegs & EXP_15_V31) < (bdegs & EXP_15_V31) ||
			   (adegs & EXP_16_V31) < (bdegs & EXP_16_V31) ||
			   (adegs & EXP_17_V31) < (bdegs & EXP_17_V31) ||
			   (adegs & EXP_18_V31) < (bdegs & EXP_18_V31) ||
			   (adegs & EXP_19_V31) < (bdegs & EXP_19_V31) ||
			   (adegs & EXP_20_V31) < (bdegs & EXP_20_V31) ||
			   (adegs & EXP_21_V31) < (bdegs & EXP_21_V31) ||
			   (adegs & EXP_22_V31) < (bdegs & EXP_22_V31) ||
			   (adegs & EXP_23_V31) < (bdegs & EXP_23_V31) ||
			   (adegs & EXP_24_V31) < (bdegs & EXP_24_V31) ||
			   (adegs & EXP_25_V31) < (bdegs & EXP_25_V31) ||
			   (adegs & EXP_26_V31) < (bdegs & EXP_26_V31) ||
			   (adegs & EXP_27_V31) < (bdegs & EXP_27_V31) ||
			   (adegs & EXP_28_V31) < (bdegs & EXP_28_V31) ||
			   (adegs & EXP_29_V31) < (bdegs & EXP_29_V31) ||
			   (adegs & EXP_30_V31) < (bdegs & EXP_30_V31) ||
			   (adegs & EXP_31_V31) < (bdegs & EXP_31_V31)  );
}

//monomial divide test for nvar 32
static inline int monomialDivideTest_32(degrees_t adegs, degrees_t bdegs) {
	return !(  (adegs & EXP_1_V32) < (bdegs & EXP_1_V32) ||
			   (adegs & EXP_2_V32) < (bdegs & EXP_2_V32) ||
			   (adegs & EXP_3_V32) < (bdegs & EXP_3_V32) ||
			   (adegs & EXP_4_V32) < (bdegs & EXP_4_V32) ||
			   (adegs & EXP_5_V32) < (bdegs & EXP_5_V32) ||
			   (adegs & EXP_6_V32) < (bdegs & EXP_6_V32) ||
			   (adegs & EXP_7_V32) < (bdegs & EXP_7_V32) ||
			   (adegs & EXP_8_V32) < (bdegs & EXP_8_V32) ||
			   (adegs & EXP_9_V32) < (bdegs & EXP_9_V32) ||
			   (adegs & EXP_10_V32) < (bdegs & EXP_10_V32) ||
			   (adegs & EXP_11_V32) < (bdegs & EXP_11_V32) ||
			   (adegs & EXP_12_V32) < (bdegs & EXP_12_V32) ||
			   (adegs & EXP_13_V32) < (bdegs & EXP_13_V32) ||
			   (adegs & EXP_14_V32) < (bdegs & EXP_14_V32) ||
			   (adegs & EXP_15_V32) < (bdegs & EXP_15_V32) ||
			   (adegs & EXP_16_V32) < (bdegs & EXP_16_V32) ||
			   (adegs & EXP_17_V32) < (bdegs & EXP_17_V32) ||
			   (adegs & EXP_18_V32) < (bdegs & EXP_18_V32) ||
			   (adegs & EXP_19_V32) < (bdegs & EXP_19_V32) ||
			   (adegs & EXP_20_V32) < (bdegs & EXP_20_V32) ||
			   (adegs & EXP_21_V32) < (bdegs & EXP_21_V32) ||
			   (adegs & EXP_22_V32) < (bdegs & EXP_22_V32) ||
			   (adegs & EXP_23_V32) < (bdegs & EXP_23_V32) ||
			   (adegs & EXP_24_V32) < (bdegs & EXP_24_V32) ||
			   (adegs & EXP_25_V32) < (bdegs & EXP_25_V32) ||
			   (adegs & EXP_26_V32) < (bdegs & EXP_26_V32) ||
			   (adegs & EXP_27_V32) < (bdegs & EXP_27_V32) ||
			   (adegs & EXP_28_V32) < (bdegs & EXP_28_V32) ||
			   (adegs & EXP_29_V32) < (bdegs & EXP_29_V32) ||
			   (adegs & EXP_30_V32) < (bdegs & EXP_30_V32) ||
			   (adegs & EXP_31_V32) < (bdegs & EXP_31_V32) ||
			   (adegs & EXP_32_V32) < (bdegs & EXP_32_V32)  );
}


static DivTest_ptr getMonomialDivideTestFuncPtr(int nvar) {
	switch (nvar)  {
		case 1: { return monomialDivideTest_1; }
		case 2: { return monomialDivideTest_2; }
		case 3: { return monomialDivideTest_3; }
		case 4: { return monomialDivideTest_4; }
		case 5: { return monomialDivideTest_5; }
		case 6: { return monomialDivideTest_6; }
		case 7: { return monomialDivideTest_7; }
		case 8: { return monomialDivideTest_8; }
		case 9: { return monomialDivideTest_9; }
		case 10: { return monomialDivideTest_10; }
		case 11: { return monomialDivideTest_11; }
		case 12: { return monomialDivideTest_12; }
		case 13: { return monomialDivideTest_13; }
		case 14: { return monomialDivideTest_14; }
		case 15: { return monomialDivideTest_15; }
		case 16: { return monomialDivideTest_16; }
		case 17: { return monomialDivideTest_17; }
		case 18: { return monomialDivideTest_18; }
		case 19: { return monomialDivideTest_19; }
		case 20: { return monomialDivideTest_20; }
		case 21: { return monomialDivideTest_21; }
		case 22: { return monomialDivideTest_22; }
		case 23: { return monomialDivideTest_23; }
		case 24: { return monomialDivideTest_24; }
		case 25: { return monomialDivideTest_25; }
		case 26: { return monomialDivideTest_26; }
		case 27: { return monomialDivideTest_27; }
		case 28: { return monomialDivideTest_28; }
		case 29: { return monomialDivideTest_29; }
		case 30: { return monomialDivideTest_30; }
		case 31: { return monomialDivideTest_31; }
		case 32: { return monomialDivideTest_32; }
	}
	return NULL;
}


/**
 * Helper to determine if monomial b divides monomial a.
 *
 * Note: since we assume working in Q, do not need to check coefficients 
 * nvar: number of variables of monomials a and b
 */
static inline int monomialDivideTest(degrees_t adegs, degrees_t bdegs, int nvar) {
	switch (nvar) {
		case 1: {
			return adegs >= bdegs;
		}
		case 2: {
			return monomialDivideTest_2(adegs,bdegs);
		}
		case 3: {
			return monomialDivideTest_3(adegs,bdegs);
		}
		case 4: {
			return monomialDivideTest_4(adegs,bdegs);
		}
		case 5: {
			return monomialDivideTest_5(adegs,bdegs);
		}
		case 6: {
			return monomialDivideTest_6(adegs,bdegs);
		}
		case 7: {
			return monomialDivideTest_7(adegs,bdegs);
		}
		case 8: {
			return monomialDivideTest_8(adegs,bdegs);
		}
		case 9: {
			return monomialDivideTest_9(adegs,bdegs);
		}
		case 10: {
			return monomialDivideTest_10(adegs,bdegs);
		}
		case 11: {
			return monomialDivideTest_11(adegs,bdegs);
		}
		case 12: {
			return monomialDivideTest_12(adegs,bdegs);
		}
		case 13: {
			return monomialDivideTest_13(adegs,bdegs);
		}
		case 14: {
			return monomialDivideTest_14(adegs,bdegs);
		}
		case 15: {
			return monomialDivideTest_15(adegs,bdegs);
		}
		case 16: {
			return monomialDivideTest_16(adegs,bdegs);
		}
		case 17: {
			return monomialDivideTest_17(adegs,bdegs);
		}
		case 18: {
			return monomialDivideTest_18(adegs,bdegs);
		}
		case 19: {
			return monomialDivideTest_19(adegs,bdegs);
		}
		case 20: {
			return monomialDivideTest_20(adegs,bdegs);
		}
		case 21: {
			return monomialDivideTest_21(adegs,bdegs);
		}
		case 22: {
			return monomialDivideTest_22(adegs,bdegs);
		}
		case 23: {
			return monomialDivideTest_23(adegs,bdegs);
		}
		case 24: {
			return monomialDivideTest_24(adegs,bdegs);
		}
		case 25: {
			return monomialDivideTest_25(adegs,bdegs);
		}
		case 26: {
			return monomialDivideTest_26(adegs,bdegs);
		}
		case 27: {
			return monomialDivideTest_27(adegs,bdegs);
		}
		case 28: {
			return monomialDivideTest_28(adegs,bdegs);
		}
		case 29: {
			return monomialDivideTest_29(adegs,bdegs);
		}
		case 30: {
			return monomialDivideTest_30(adegs,bdegs);
		}
		case 31: {
			return monomialDivideTest_31(adegs,bdegs);
		}
		case 32: {
			return monomialDivideTest_32(adegs,bdegs);
		}
		default : {
			fprintf(stderr, "MONOMIAL DIVIDE TEST NOT IMPLEMENTED FOR NVAR %d\n", nvar);
			exit(-1);
		}
	}

	return 0;
}

static int getMVarExpOffset(int nvar) {
	switch(nvar) {
    	case 1: {
			return EXP_OFFSET_1_V1;    		
    	}
    	case 2: {
			return EXP_OFFSET_1_V2;
    	}
    	case 3: {
			return EXP_OFFSET_1_V3;
    	}
    	case 4: {
			return EXP_OFFSET_1_V4;
    	}
    	case 5: {
			return EXP_OFFSET_1_V5;
    	}
    	case 6: {
			return EXP_OFFSET_1_V6;
    	}
    	case 7: {
			return EXP_OFFSET_1_V7;
		}
    	case 8: {
    		return EXP_OFFSET_1_V8;
    	}
    	case 9: {
    		return EXP_OFFSET_1_V9;
    	}
    	case 10: {
			return EXP_OFFSET_1_V10;
    	}
    	case 11: {
			return EXP_OFFSET_1_V11;
    	}
    	case 12: {
			return EXP_OFFSET_1_V12;
    	}
    	case 13: {
			return EXP_OFFSET_1_V13;
    	}
    	case 14: {
			return EXP_OFFSET_1_V14;
    	}
    	case 15: {
			return EXP_OFFSET_1_V15;
    	}
    	case 16: {
			return EXP_OFFSET_1_V16;
    	}
    	case 17: {
			return EXP_OFFSET_1_V17;
    	}
    	case 18: {
			return EXP_OFFSET_1_V18;
		}
    	case 19: {
			return EXP_OFFSET_1_V19;
    	}
    	case 20: {
			return EXP_OFFSET_1_V20;
    	}
    	case 21: {
			return EXP_OFFSET_1_V21;
    	}
    	case 22: {
			return EXP_OFFSET_1_V22;
    	}
    	case 23: {
			return EXP_OFFSET_1_V23;
    	}
    	case 24: {
			return EXP_OFFSET_1_V24;
    	}
    	case 25: {
			return EXP_OFFSET_1_V25;
    	}
    	case 26: {
			return EXP_OFFSET_1_V26;
    	}
    	case 27: {
			return EXP_OFFSET_1_V27;
		}
    	case 28: {
			return EXP_OFFSET_1_V28;
    	}
    	case 29: {
			return EXP_OFFSET_1_V29;
    	}
    	case 30: {
			return EXP_OFFSET_1_V30;
    	}
    	case 31: {
			return EXP_OFFSET_1_V31;
    	}
    	case 32: {
			return EXP_OFFSET_1_V32;
    	}
    	default : {
    		fprintf(stderr, "EXP SIZES NOT DEFINED FOR NVAR %d\n",nvar);
    		return -1;
    	}
    }
}

static int* getExpOffsetArray (int nvar) {
	int* sizes = (int*) malloc(sizeof(int)*nvar);
    switch(nvar) {
    	case 1: {
    		sizes[0] = EXP_OFFSET_1_V1;    		
    		break;
    	}
    	case 2: {
			sizes[0] = EXP_OFFSET_1_V2;
			sizes[1] = EXP_OFFSET_2_V2;
    		break;
    	}
    	case 3: {
			sizes[0] = EXP_OFFSET_1_V3;
			sizes[1] = EXP_OFFSET_2_V3;
			sizes[2] = EXP_OFFSET_3_V3;
    		break;
    	}
    	case 4: {
			sizes[0] = EXP_OFFSET_1_V4;
			sizes[1] = EXP_OFFSET_2_V4;
			sizes[2] = EXP_OFFSET_3_V4;
			sizes[3] = EXP_OFFSET_4_V4;
    		break;
    	}
    	case 5: {
			sizes[0] = EXP_OFFSET_1_V5;
			sizes[1] = EXP_OFFSET_2_V5;
			sizes[2] = EXP_OFFSET_3_V5;
			sizes[3] = EXP_OFFSET_4_V5;
			sizes[4] = EXP_OFFSET_5_V5;
    		break;
    	}
    	case 6: {
			sizes[0] = EXP_OFFSET_1_V6;
			sizes[1] = EXP_OFFSET_2_V6;
			sizes[2] = EXP_OFFSET_3_V6;
			sizes[3] = EXP_OFFSET_4_V6;
			sizes[4] = EXP_OFFSET_5_V6;
			sizes[5] = EXP_OFFSET_6_V6;
			break;
    	}
    	case 7: {
			sizes[0] = EXP_OFFSET_1_V7;
			sizes[1] = EXP_OFFSET_2_V7;
			sizes[2] = EXP_OFFSET_3_V7;
			sizes[3] = EXP_OFFSET_4_V7;
			sizes[4] = EXP_OFFSET_5_V7;
			sizes[5] = EXP_OFFSET_6_V7;
			sizes[6] = EXP_OFFSET_7_V7;
			break;
		}
    	case 8: {
    		sizes[0] = EXP_OFFSET_1_V8;
    		sizes[1] = EXP_OFFSET_2_V8;
    		sizes[2] = EXP_OFFSET_3_V8;
    		sizes[3] = EXP_OFFSET_4_V8;
    		sizes[4] = EXP_OFFSET_5_V8;
    		sizes[5] = EXP_OFFSET_6_V8;
    		sizes[6] = EXP_OFFSET_7_V8;
    		sizes[7] = EXP_OFFSET_8_V8;
    		break;
    	}
    	case 9: {
    		sizes[0] = EXP_OFFSET_1_V9;
    		sizes[1] = EXP_OFFSET_2_V9;
    		sizes[2] = EXP_OFFSET_3_V9;
    		sizes[3] = EXP_OFFSET_4_V9;
    		sizes[4] = EXP_OFFSET_5_V9;
    		sizes[5] = EXP_OFFSET_6_V9;
    		sizes[6] = EXP_OFFSET_7_V9;
    		sizes[7] = EXP_OFFSET_8_V9;
    		sizes[8] = EXP_OFFSET_9_V9;
    		break;
    	}
    	case 10: {
			sizes[0] = EXP_OFFSET_1_V10;
			sizes[1] = EXP_OFFSET_2_V10;
			sizes[2] = EXP_OFFSET_3_V10;
			sizes[3] = EXP_OFFSET_4_V10;
			sizes[4] = EXP_OFFSET_5_V10;
			sizes[5] = EXP_OFFSET_6_V10;
			sizes[6] = EXP_OFFSET_7_V10;
			sizes[7] = EXP_OFFSET_8_V10;
			sizes[8] = EXP_OFFSET_9_V10;
			sizes[9] = EXP_OFFSET_10_V10;
    		break;
    	}
    	case 11: {
			sizes[0] = EXP_OFFSET_1_V11;
			sizes[1] = EXP_OFFSET_2_V11;
			sizes[2] = EXP_OFFSET_3_V11;
			sizes[3] = EXP_OFFSET_4_V11;
			sizes[4] = EXP_OFFSET_5_V11;
			sizes[5] = EXP_OFFSET_6_V11;
			sizes[6] = EXP_OFFSET_7_V11;
			sizes[7] = EXP_OFFSET_8_V11;
			sizes[8] = EXP_OFFSET_9_V11;
			sizes[9] = EXP_OFFSET_10_V11;
			sizes[10] = EXP_OFFSET_11_V11;
			break;
    	}
    	case 12: {
			sizes[0] = EXP_OFFSET_1_V12;
			sizes[1] = EXP_OFFSET_2_V12;
			sizes[2] = EXP_OFFSET_3_V12;
			sizes[3] = EXP_OFFSET_4_V12;
			sizes[4] = EXP_OFFSET_5_V12;
			sizes[5] = EXP_OFFSET_6_V12;
			sizes[6] = EXP_OFFSET_7_V12;
			sizes[7] = EXP_OFFSET_8_V12;
			sizes[8] = EXP_OFFSET_9_V12;
			sizes[9] = EXP_OFFSET_10_V12;
			sizes[10] = EXP_OFFSET_11_V12;
			sizes[11] = EXP_OFFSET_12_V12;
			break;
    	}
    	case 13: {
			sizes[0] = EXP_OFFSET_1_V13;
			sizes[1] = EXP_OFFSET_2_V13;
			sizes[2] = EXP_OFFSET_3_V13;
			sizes[3] = EXP_OFFSET_4_V13;
			sizes[4] = EXP_OFFSET_5_V13;
			sizes[5] = EXP_OFFSET_6_V13;
			sizes[6] = EXP_OFFSET_7_V13;
			sizes[7] = EXP_OFFSET_8_V13;
			sizes[8] = EXP_OFFSET_9_V13;
			sizes[9] = EXP_OFFSET_10_V13;
			sizes[10] = EXP_OFFSET_11_V13;
			sizes[11] = EXP_OFFSET_12_V13;
			sizes[12] = EXP_OFFSET_13_V13;
    		break;
    	}
    	case 14: {
			sizes[0] = EXP_OFFSET_1_V14;
			sizes[1] = EXP_OFFSET_2_V14;
			sizes[2] = EXP_OFFSET_3_V14;
			sizes[3] = EXP_OFFSET_4_V14;
			sizes[4] = EXP_OFFSET_5_V14;
			sizes[5] = EXP_OFFSET_6_V14;
			sizes[6] = EXP_OFFSET_7_V14;
			sizes[7] = EXP_OFFSET_8_V14;
			sizes[8] = EXP_OFFSET_9_V14;
			sizes[9] = EXP_OFFSET_10_V14;
			sizes[10] = EXP_OFFSET_11_V14;
			sizes[11] = EXP_OFFSET_12_V14;
			sizes[12] = EXP_OFFSET_13_V14;
			sizes[13] = EXP_OFFSET_14_V14;
    		break;
    	}
    	case 15: {
			sizes[0] = EXP_OFFSET_1_V15;
			sizes[1] = EXP_OFFSET_2_V15;
			sizes[2] = EXP_OFFSET_3_V15;
			sizes[3] = EXP_OFFSET_4_V15;
			sizes[4] = EXP_OFFSET_5_V15;
			sizes[5] = EXP_OFFSET_6_V15;
			sizes[6] = EXP_OFFSET_7_V15;
			sizes[7] = EXP_OFFSET_8_V15;
			sizes[8] = EXP_OFFSET_9_V15;
			sizes[9] = EXP_OFFSET_10_V15;
			sizes[10] = EXP_OFFSET_11_V15;
			sizes[11] = EXP_OFFSET_12_V15;
			sizes[12] = EXP_OFFSET_13_V15;
			sizes[13] = EXP_OFFSET_14_V15;
			sizes[14] = EXP_OFFSET_15_V15;
    		break;
    	}
    	case 16: {
			sizes[0] = EXP_OFFSET_1_V16;
			sizes[1] = EXP_OFFSET_2_V16;
			sizes[2] = EXP_OFFSET_3_V16;
			sizes[3] = EXP_OFFSET_4_V16;
			sizes[4] = EXP_OFFSET_5_V16;
			sizes[5] = EXP_OFFSET_6_V16;
			sizes[6] = EXP_OFFSET_7_V16;
			sizes[7] = EXP_OFFSET_8_V16;
			sizes[8] = EXP_OFFSET_9_V16;
			sizes[9] = EXP_OFFSET_10_V16;
			sizes[10] = EXP_OFFSET_11_V16;
			sizes[11] = EXP_OFFSET_12_V16;
			sizes[12] = EXP_OFFSET_13_V16;
			sizes[13] = EXP_OFFSET_14_V16;
			sizes[14] = EXP_OFFSET_15_V16;
			sizes[15] = EXP_OFFSET_16_V16;
    		break;
    	}
    	case 17: {
			sizes[0] = EXP_OFFSET_1_V17;
			sizes[1] = EXP_OFFSET_2_V17;
			sizes[2] = EXP_OFFSET_3_V17;
			sizes[3] = EXP_OFFSET_4_V17;
			sizes[4] = EXP_OFFSET_5_V17;
			sizes[5] = EXP_OFFSET_6_V17;
			sizes[6] = EXP_OFFSET_7_V17;
			sizes[7] = EXP_OFFSET_8_V17;
			sizes[8] = EXP_OFFSET_9_V17;
			sizes[9] = EXP_OFFSET_10_V17;
			sizes[10] = EXP_OFFSET_11_V17;
			sizes[11] = EXP_OFFSET_12_V17;
			sizes[12] = EXP_OFFSET_13_V17;
			sizes[13] = EXP_OFFSET_14_V17;
			sizes[14] = EXP_OFFSET_15_V17;
			sizes[15] = EXP_OFFSET_16_V17;
			sizes[16] = EXP_OFFSET_17_V17;
    		break;
    	}
    	case 18: {
			sizes[0] = EXP_OFFSET_1_V18;
			sizes[1] = EXP_OFFSET_2_V18;
			sizes[2] = EXP_OFFSET_3_V18;
			sizes[3] = EXP_OFFSET_4_V18;
			sizes[4] = EXP_OFFSET_5_V18;
			sizes[5] = EXP_OFFSET_6_V18;
			sizes[6] = EXP_OFFSET_7_V18;
			sizes[7] = EXP_OFFSET_8_V18;
			sizes[8] = EXP_OFFSET_9_V18;
			sizes[9] = EXP_OFFSET_10_V18;
			sizes[10] = EXP_OFFSET_11_V18;
			sizes[11] = EXP_OFFSET_12_V18;
			sizes[12] = EXP_OFFSET_13_V18;
			sizes[13] = EXP_OFFSET_14_V18;
			sizes[14] = EXP_OFFSET_15_V18;
			sizes[15] = EXP_OFFSET_16_V18;
			sizes[16] = EXP_OFFSET_17_V18;
			sizes[17] = EXP_OFFSET_18_V18;
    		break;
    	}
    	case 19: {
			sizes[0] = EXP_OFFSET_1_V19;
			sizes[1] = EXP_OFFSET_2_V19;
			sizes[2] = EXP_OFFSET_3_V19;
			sizes[3] = EXP_OFFSET_4_V19;
			sizes[4] = EXP_OFFSET_5_V19;
			sizes[5] = EXP_OFFSET_6_V19;
			sizes[6] = EXP_OFFSET_7_V19;
			sizes[7] = EXP_OFFSET_8_V19;
			sizes[8] = EXP_OFFSET_9_V19;
			sizes[9] = EXP_OFFSET_10_V19;
			sizes[10] = EXP_OFFSET_11_V19;
			sizes[11] = EXP_OFFSET_12_V19;
			sizes[12] = EXP_OFFSET_13_V19;
			sizes[13] = EXP_OFFSET_14_V19;
			sizes[14] = EXP_OFFSET_15_V19;
			sizes[15] = EXP_OFFSET_16_V19;
			sizes[16] = EXP_OFFSET_17_V19;
			sizes[17] = EXP_OFFSET_18_V19;
			sizes[18] = EXP_OFFSET_19_V19;
    		break;
    	}
    	case 20: {
			sizes[0] = EXP_OFFSET_1_V20;
			sizes[1] = EXP_OFFSET_2_V20;
			sizes[2] = EXP_OFFSET_3_V20;
			sizes[3] = EXP_OFFSET_4_V20;
			sizes[4] = EXP_OFFSET_5_V20;
			sizes[5] = EXP_OFFSET_6_V20;
			sizes[6] = EXP_OFFSET_7_V20;
			sizes[7] = EXP_OFFSET_8_V20;
			sizes[8] = EXP_OFFSET_9_V20;
			sizes[9] = EXP_OFFSET_10_V20;
			sizes[10] = EXP_OFFSET_11_V20;
			sizes[11] = EXP_OFFSET_12_V20;
			sizes[12] = EXP_OFFSET_13_V20;
			sizes[13] = EXP_OFFSET_14_V20;
			sizes[14] = EXP_OFFSET_15_V20;
			sizes[15] = EXP_OFFSET_16_V20;
			sizes[16] = EXP_OFFSET_17_V20;
			sizes[17] = EXP_OFFSET_18_V20;
			sizes[18] = EXP_OFFSET_19_V20;
			sizes[19] = EXP_OFFSET_20_V20;
    		break;
    	}
    	case 21: {
			sizes[0] = EXP_OFFSET_1_V21;
			sizes[1] = EXP_OFFSET_2_V21;
			sizes[2] = EXP_OFFSET_3_V21;
			sizes[3] = EXP_OFFSET_4_V21;
			sizes[4] = EXP_OFFSET_5_V21;
			sizes[5] = EXP_OFFSET_6_V21;
			sizes[6] = EXP_OFFSET_7_V21;
			sizes[7] = EXP_OFFSET_8_V21;
			sizes[8] = EXP_OFFSET_9_V21;
			sizes[9] = EXP_OFFSET_10_V21;
			sizes[10] = EXP_OFFSET_11_V21;
			sizes[11] = EXP_OFFSET_12_V21;
			sizes[12] = EXP_OFFSET_13_V21;
			sizes[13] = EXP_OFFSET_14_V21;
			sizes[14] = EXP_OFFSET_15_V21;
			sizes[15] = EXP_OFFSET_16_V21;
			sizes[16] = EXP_OFFSET_17_V21;
			sizes[17] = EXP_OFFSET_18_V21;
			sizes[18] = EXP_OFFSET_19_V21;
			sizes[19] = EXP_OFFSET_20_V21;
			sizes[20] = EXP_OFFSET_21_V21;
    		break;
    	}
    	case 22: {
			sizes[0] = EXP_OFFSET_1_V22;
			sizes[1] = EXP_OFFSET_2_V22;
			sizes[2] = EXP_OFFSET_3_V22;
			sizes[3] = EXP_OFFSET_4_V22;
			sizes[4] = EXP_OFFSET_5_V22;
			sizes[5] = EXP_OFFSET_6_V22;
			sizes[6] = EXP_OFFSET_7_V22;
			sizes[7] = EXP_OFFSET_8_V22;
			sizes[8] = EXP_OFFSET_9_V22;
			sizes[9] = EXP_OFFSET_10_V22;
			sizes[10] = EXP_OFFSET_11_V22;
			sizes[11] = EXP_OFFSET_12_V22;
			sizes[12] = EXP_OFFSET_13_V22;
			sizes[13] = EXP_OFFSET_14_V22;
			sizes[14] = EXP_OFFSET_15_V22;
			sizes[15] = EXP_OFFSET_16_V22;
			sizes[16] = EXP_OFFSET_17_V22;
			sizes[17] = EXP_OFFSET_18_V22;
			sizes[18] = EXP_OFFSET_19_V22;
			sizes[19] = EXP_OFFSET_20_V22;
			sizes[20] = EXP_OFFSET_21_V22;
			sizes[21] = EXP_OFFSET_22_V22;
    		break;
    	}
    	case 23: {
			sizes[0] = EXP_OFFSET_1_V23;
			sizes[1] = EXP_OFFSET_2_V23;
			sizes[2] = EXP_OFFSET_3_V23;
			sizes[3] = EXP_OFFSET_4_V23;
			sizes[4] = EXP_OFFSET_5_V23;
			sizes[5] = EXP_OFFSET_6_V23;
			sizes[6] = EXP_OFFSET_7_V23;
			sizes[7] = EXP_OFFSET_8_V23;
			sizes[8] = EXP_OFFSET_9_V23;
			sizes[9] = EXP_OFFSET_10_V23;
			sizes[10] = EXP_OFFSET_11_V23;
			sizes[11] = EXP_OFFSET_12_V23;
			sizes[12] = EXP_OFFSET_13_V23;
			sizes[13] = EXP_OFFSET_14_V23;
			sizes[14] = EXP_OFFSET_15_V23;
			sizes[15] = EXP_OFFSET_16_V23;
			sizes[16] = EXP_OFFSET_17_V23;
			sizes[17] = EXP_OFFSET_18_V23;
			sizes[18] = EXP_OFFSET_19_V23;
			sizes[19] = EXP_OFFSET_20_V23;
			sizes[20] = EXP_OFFSET_21_V23;
			sizes[21] = EXP_OFFSET_22_V23;
			sizes[22] = EXP_OFFSET_23_V23;
    		break;
    	}
    	case 24: {
			sizes[0] = EXP_OFFSET_1_V24;
			sizes[1] = EXP_OFFSET_2_V24;
			sizes[2] = EXP_OFFSET_3_V24;
			sizes[3] = EXP_OFFSET_4_V24;
			sizes[4] = EXP_OFFSET_5_V24;
			sizes[5] = EXP_OFFSET_6_V24;
			sizes[6] = EXP_OFFSET_7_V24;
			sizes[7] = EXP_OFFSET_8_V24;
			sizes[8] = EXP_OFFSET_9_V24;
			sizes[9] = EXP_OFFSET_10_V24;
			sizes[10] = EXP_OFFSET_11_V24;
			sizes[11] = EXP_OFFSET_12_V24;
			sizes[12] = EXP_OFFSET_13_V24;
			sizes[13] = EXP_OFFSET_14_V24;
			sizes[14] = EXP_OFFSET_15_V24;
			sizes[15] = EXP_OFFSET_16_V24;
			sizes[16] = EXP_OFFSET_17_V24;
			sizes[17] = EXP_OFFSET_18_V24;
			sizes[18] = EXP_OFFSET_19_V24;
			sizes[19] = EXP_OFFSET_20_V24;
			sizes[20] = EXP_OFFSET_21_V24;
			sizes[21] = EXP_OFFSET_22_V24;
			sizes[22] = EXP_OFFSET_23_V24;
			sizes[23] = EXP_OFFSET_24_V24;
    		break;
    	}
    	case 25: {
			sizes[0] = EXP_OFFSET_1_V25;
			sizes[1] = EXP_OFFSET_2_V25;
			sizes[2] = EXP_OFFSET_3_V25;
			sizes[3] = EXP_OFFSET_4_V25;
			sizes[4] = EXP_OFFSET_5_V25;
			sizes[5] = EXP_OFFSET_6_V25;
			sizes[6] = EXP_OFFSET_7_V25;
			sizes[7] = EXP_OFFSET_8_V25;
			sizes[8] = EXP_OFFSET_9_V25;
			sizes[9] = EXP_OFFSET_10_V25;
			sizes[10] = EXP_OFFSET_11_V25;
			sizes[11] = EXP_OFFSET_12_V25;
			sizes[12] = EXP_OFFSET_13_V25;
			sizes[13] = EXP_OFFSET_14_V25;
			sizes[14] = EXP_OFFSET_15_V25;
			sizes[15] = EXP_OFFSET_16_V25;
			sizes[16] = EXP_OFFSET_17_V25;
			sizes[17] = EXP_OFFSET_18_V25;
			sizes[18] = EXP_OFFSET_19_V25;
			sizes[19] = EXP_OFFSET_20_V25;
			sizes[20] = EXP_OFFSET_21_V25;
			sizes[21] = EXP_OFFSET_22_V25;
			sizes[22] = EXP_OFFSET_23_V25;
			sizes[23] = EXP_OFFSET_24_V25;
			sizes[24] = EXP_OFFSET_25_V25;
    		break;
    	}
    	case 26: {
			sizes[0] = EXP_OFFSET_1_V26;
			sizes[1] = EXP_OFFSET_2_V26;
			sizes[2] = EXP_OFFSET_3_V26;
			sizes[3] = EXP_OFFSET_4_V26;
			sizes[4] = EXP_OFFSET_5_V26;
			sizes[5] = EXP_OFFSET_6_V26;
			sizes[6] = EXP_OFFSET_7_V26;
			sizes[7] = EXP_OFFSET_8_V26;
			sizes[8] = EXP_OFFSET_9_V26;
			sizes[9] = EXP_OFFSET_10_V26;
			sizes[10] = EXP_OFFSET_11_V26;
			sizes[11] = EXP_OFFSET_12_V26;
			sizes[12] = EXP_OFFSET_13_V26;
			sizes[13] = EXP_OFFSET_14_V26;
			sizes[14] = EXP_OFFSET_15_V26;
			sizes[15] = EXP_OFFSET_16_V26;
			sizes[16] = EXP_OFFSET_17_V26;
			sizes[17] = EXP_OFFSET_18_V26;
			sizes[18] = EXP_OFFSET_19_V26;
			sizes[19] = EXP_OFFSET_20_V26;
			sizes[20] = EXP_OFFSET_21_V26;
			sizes[21] = EXP_OFFSET_22_V26;
			sizes[22] = EXP_OFFSET_23_V26;
			sizes[23] = EXP_OFFSET_24_V26;
			sizes[24] = EXP_OFFSET_25_V26;
			sizes[25] = EXP_OFFSET_26_V26;
    		break;
    	}
    	case 27: {
			sizes[0] = EXP_OFFSET_1_V27;
			sizes[1] = EXP_OFFSET_2_V27;
			sizes[2] = EXP_OFFSET_3_V27;
			sizes[3] = EXP_OFFSET_4_V27;
			sizes[4] = EXP_OFFSET_5_V27;
			sizes[5] = EXP_OFFSET_6_V27;
			sizes[6] = EXP_OFFSET_7_V27;
			sizes[7] = EXP_OFFSET_8_V27;
			sizes[8] = EXP_OFFSET_9_V27;
			sizes[9] = EXP_OFFSET_10_V27;
			sizes[10] = EXP_OFFSET_11_V27;
			sizes[11] = EXP_OFFSET_12_V27;
			sizes[12] = EXP_OFFSET_13_V27;
			sizes[13] = EXP_OFFSET_14_V27;
			sizes[14] = EXP_OFFSET_15_V27;
			sizes[15] = EXP_OFFSET_16_V27;
			sizes[16] = EXP_OFFSET_17_V27;
			sizes[17] = EXP_OFFSET_18_V27;
			sizes[18] = EXP_OFFSET_19_V27;
			sizes[19] = EXP_OFFSET_20_V27;
			sizes[20] = EXP_OFFSET_21_V27;
			sizes[21] = EXP_OFFSET_22_V27;
			sizes[22] = EXP_OFFSET_23_V27;
			sizes[23] = EXP_OFFSET_24_V27;
			sizes[24] = EXP_OFFSET_25_V27;
			sizes[25] = EXP_OFFSET_26_V27;
			sizes[26] = EXP_OFFSET_27_V27;
    		break;
    	}
    	case 28: {
			sizes[0] = EXP_OFFSET_1_V28;
			sizes[1] = EXP_OFFSET_2_V28;
			sizes[2] = EXP_OFFSET_3_V28;
			sizes[3] = EXP_OFFSET_4_V28;
			sizes[4] = EXP_OFFSET_5_V28;
			sizes[5] = EXP_OFFSET_6_V28;
			sizes[6] = EXP_OFFSET_7_V28;
			sizes[7] = EXP_OFFSET_8_V28;
			sizes[8] = EXP_OFFSET_9_V28;
			sizes[9] = EXP_OFFSET_10_V28;
			sizes[10] = EXP_OFFSET_11_V28;
			sizes[11] = EXP_OFFSET_12_V28;
			sizes[12] = EXP_OFFSET_13_V28;
			sizes[13] = EXP_OFFSET_14_V28;
			sizes[14] = EXP_OFFSET_15_V28;
			sizes[15] = EXP_OFFSET_16_V28;
			sizes[16] = EXP_OFFSET_17_V28;
			sizes[17] = EXP_OFFSET_18_V28;
			sizes[18] = EXP_OFFSET_19_V28;
			sizes[19] = EXP_OFFSET_20_V28;
			sizes[20] = EXP_OFFSET_21_V28;
			sizes[21] = EXP_OFFSET_22_V28;
			sizes[22] = EXP_OFFSET_23_V28;
			sizes[23] = EXP_OFFSET_24_V28;
			sizes[24] = EXP_OFFSET_25_V28;
			sizes[25] = EXP_OFFSET_26_V28;
			sizes[26] = EXP_OFFSET_27_V28;
			sizes[27] = EXP_OFFSET_28_V28;
    		break;
    	}
    	case 29: {
			sizes[0] = EXP_OFFSET_1_V29;
			sizes[1] = EXP_OFFSET_2_V29;
			sizes[2] = EXP_OFFSET_3_V29;
			sizes[3] = EXP_OFFSET_4_V29;
			sizes[4] = EXP_OFFSET_5_V29;
			sizes[5] = EXP_OFFSET_6_V29;
			sizes[6] = EXP_OFFSET_7_V29;
			sizes[7] = EXP_OFFSET_8_V29;
			sizes[8] = EXP_OFFSET_9_V29;
			sizes[9] = EXP_OFFSET_10_V29;
			sizes[10] = EXP_OFFSET_11_V29;
			sizes[11] = EXP_OFFSET_12_V29;
			sizes[12] = EXP_OFFSET_13_V29;
			sizes[13] = EXP_OFFSET_14_V29;
			sizes[14] = EXP_OFFSET_15_V29;
			sizes[15] = EXP_OFFSET_16_V29;
			sizes[16] = EXP_OFFSET_17_V29;
			sizes[17] = EXP_OFFSET_18_V29;
			sizes[18] = EXP_OFFSET_19_V29;
			sizes[19] = EXP_OFFSET_20_V29;
			sizes[20] = EXP_OFFSET_21_V29;
			sizes[21] = EXP_OFFSET_22_V29;
			sizes[22] = EXP_OFFSET_23_V29;
			sizes[23] = EXP_OFFSET_24_V29;
			sizes[24] = EXP_OFFSET_25_V29;
			sizes[25] = EXP_OFFSET_26_V29;
			sizes[26] = EXP_OFFSET_27_V29;
			sizes[27] = EXP_OFFSET_28_V29;
			sizes[28] = EXP_OFFSET_29_V29;
    		break;
    	}
    	case 30: {
			sizes[0] = EXP_OFFSET_1_V30;
			sizes[1] = EXP_OFFSET_2_V30;
			sizes[2] = EXP_OFFSET_3_V30;
			sizes[3] = EXP_OFFSET_4_V30;
			sizes[4] = EXP_OFFSET_5_V30;
			sizes[5] = EXP_OFFSET_6_V30;
			sizes[6] = EXP_OFFSET_7_V30;
			sizes[7] = EXP_OFFSET_8_V30;
			sizes[8] = EXP_OFFSET_9_V30;
			sizes[9] = EXP_OFFSET_10_V30;
			sizes[10] = EXP_OFFSET_11_V30;
			sizes[11] = EXP_OFFSET_12_V30;
			sizes[12] = EXP_OFFSET_13_V30;
			sizes[13] = EXP_OFFSET_14_V30;
			sizes[14] = EXP_OFFSET_15_V30;
			sizes[15] = EXP_OFFSET_16_V30;
			sizes[16] = EXP_OFFSET_17_V30;
			sizes[17] = EXP_OFFSET_18_V30;
			sizes[18] = EXP_OFFSET_19_V30;
			sizes[19] = EXP_OFFSET_20_V30;
			sizes[20] = EXP_OFFSET_21_V30;
			sizes[21] = EXP_OFFSET_22_V30;
			sizes[22] = EXP_OFFSET_23_V30;
			sizes[23] = EXP_OFFSET_24_V30;
			sizes[24] = EXP_OFFSET_25_V30;
			sizes[25] = EXP_OFFSET_26_V30;
			sizes[26] = EXP_OFFSET_27_V30;
			sizes[27] = EXP_OFFSET_28_V30;
			sizes[28] = EXP_OFFSET_29_V30;
			sizes[29] = EXP_OFFSET_30_V30;
    		break;
    	}
    	case 31: {
			sizes[0] = EXP_OFFSET_1_V31;
			sizes[1] = EXP_OFFSET_2_V31;
			sizes[2] = EXP_OFFSET_3_V31;
			sizes[3] = EXP_OFFSET_4_V31;
			sizes[4] = EXP_OFFSET_5_V31;
			sizes[5] = EXP_OFFSET_6_V31;
			sizes[6] = EXP_OFFSET_7_V31;
			sizes[7] = EXP_OFFSET_8_V31;
			sizes[8] = EXP_OFFSET_9_V31;
			sizes[9] = EXP_OFFSET_10_V31;
			sizes[10] = EXP_OFFSET_11_V31;
			sizes[11] = EXP_OFFSET_12_V31;
			sizes[12] = EXP_OFFSET_13_V31;
			sizes[13] = EXP_OFFSET_14_V31;
			sizes[14] = EXP_OFFSET_15_V31;
			sizes[15] = EXP_OFFSET_16_V31;
			sizes[16] = EXP_OFFSET_17_V31;
			sizes[17] = EXP_OFFSET_18_V31;
			sizes[18] = EXP_OFFSET_19_V31;
			sizes[19] = EXP_OFFSET_20_V31;
			sizes[20] = EXP_OFFSET_21_V31;
			sizes[21] = EXP_OFFSET_22_V31;
			sizes[22] = EXP_OFFSET_23_V31;
			sizes[23] = EXP_OFFSET_24_V31;
			sizes[24] = EXP_OFFSET_25_V31;
			sizes[25] = EXP_OFFSET_26_V31;
			sizes[26] = EXP_OFFSET_27_V31;
			sizes[27] = EXP_OFFSET_28_V31;
			sizes[28] = EXP_OFFSET_29_V31;
			sizes[29] = EXP_OFFSET_30_V31;
			sizes[30] = EXP_OFFSET_31_V31;
    		break;
    	}
    	case 32: {
			sizes[0] = EXP_OFFSET_1_V32;
			sizes[1] = EXP_OFFSET_2_V32;
			sizes[2] = EXP_OFFSET_3_V32;
			sizes[3] = EXP_OFFSET_4_V32;
			sizes[4] = EXP_OFFSET_5_V32;
			sizes[5] = EXP_OFFSET_6_V32;
			sizes[6] = EXP_OFFSET_7_V32;
			sizes[7] = EXP_OFFSET_8_V32;
			sizes[8] = EXP_OFFSET_9_V32;
			sizes[9] = EXP_OFFSET_10_V32;
			sizes[10] = EXP_OFFSET_11_V32;
			sizes[11] = EXP_OFFSET_12_V32;
			sizes[12] = EXP_OFFSET_13_V32;
			sizes[13] = EXP_OFFSET_14_V32;
			sizes[14] = EXP_OFFSET_15_V32;
			sizes[15] = EXP_OFFSET_16_V32;
			sizes[16] = EXP_OFFSET_17_V32;
			sizes[17] = EXP_OFFSET_18_V32;
			sizes[18] = EXP_OFFSET_19_V32;
			sizes[19] = EXP_OFFSET_20_V32;
			sizes[20] = EXP_OFFSET_21_V32;
			sizes[21] = EXP_OFFSET_22_V32;
			sizes[22] = EXP_OFFSET_23_V32;
			sizes[23] = EXP_OFFSET_24_V32;
			sizes[24] = EXP_OFFSET_25_V32;
			sizes[25] = EXP_OFFSET_26_V32;
			sizes[26] = EXP_OFFSET_27_V32;
			sizes[27] = EXP_OFFSET_28_V32;
			sizes[28] = EXP_OFFSET_29_V32;
			sizes[29] = EXP_OFFSET_30_V32;
			sizes[30] = EXP_OFFSET_31_V32;
			sizes[31] = EXP_OFFSET_32_V32;
    		break;
    	}
    	default : {
    		fprintf(stderr, "EXP SIZES NOT DEFINED FOR NVAR %d\n",nvar);
    		return NULL;
    	}
    }
    return sizes;
}

static unsigned long long int getMVarExpMask(int nvar) {
	switch(nvar) {
    	case 1: {
			return EXP_1_V1;    		
    	}
    	case 2: {
			return EXP_1_V2;
    	}
    	case 3: {
			return EXP_1_V3;
    	}
    	case 4: {
			return EXP_1_V4;
    	}
    	case 5: {
			return EXP_1_V5;
    	}
    	case 6: {
			return EXP_1_V6;
    	}
    	case 7: {
			return EXP_1_V7;
		}
    	case 8: {
    		return EXP_1_V8;
    	}
    	case 9: {
    		return EXP_1_V9;
    	}
    	case 10: {
			return EXP_1_V10;
    	}
    	case 11: {
			return EXP_1_V11;
    	}
    	case 12: {
			return EXP_1_V12;
    	}
    	case 13: {
			return EXP_1_V13;
    	}
    	case 14: {
			return EXP_1_V14;
    	}
    	case 15: {
			return EXP_1_V15;
    	}
    	case 16: {
			return EXP_1_V16;
    	}
    	case 17: {
			return EXP_1_V17;
    	}
    	case 18: {
			return EXP_1_V18;
		}
    	case 19: {
			return EXP_1_V19;
    	}
    	case 20: {
			return EXP_1_V20;
    	}
    	case 21: {
			return EXP_1_V21;
    	}
    	case 22: {
			return EXP_1_V22;
    	}
    	case 23: {
			return EXP_1_V23;
    	}
    	case 24: {
			return EXP_1_V24;
    	}
    	case 25: {
			return EXP_1_V25;
    	}
    	case 26: {
			return EXP_1_V26;
    	}
    	case 27: {
			return EXP_1_V27;
		}
    	case 28: {
			return EXP_1_V28;
    	}
    	case 29: {
			return EXP_1_V29;
    	}
    	case 30: {
			return EXP_1_V30;
    	}
    	case 31: {
			return EXP_1_V31;
    	}
    	case 32: {
			return EXP_1_V32;
    	}
    	default : {
    		fprintf(stderr, "EXP MASKS NOT DEFINED FOR NVAR %d\n",nvar);
    		return 0;
    	}
    }
}

static long long unsigned int* getExpMaskArray (int nvar) {
	long long unsigned int* masks = (long long unsigned int*) malloc(sizeof(long long unsigned int)*nvar);
    switch(nvar) {
    	case 1: {
    		masks[0] = EXP_1_V1;    		
    		break;
    	}
    	case 2: {
			masks[0] = EXP_1_V2;
			masks[1] = EXP_2_V2;
    		break;
    	}
    	case 3: {
			masks[0] = EXP_1_V3;
			masks[1] = EXP_2_V3;
			masks[2] = EXP_3_V3;
    		break;
    	}
    	case 4: {
			masks[0] = EXP_1_V4;
			masks[1] = EXP_2_V4;
			masks[2] = EXP_3_V4;
			masks[3] = EXP_4_V4;
    		break;
    	}
    	case 5: {
			masks[0] = EXP_1_V5;
			masks[1] = EXP_2_V5;
			masks[2] = EXP_3_V5;
			masks[3] = EXP_4_V5;
			masks[4] = EXP_5_V5;
    		break;
    	}
    	case 6: {
			masks[0] = EXP_1_V6;
			masks[1] = EXP_2_V6;
			masks[2] = EXP_3_V6;
			masks[3] = EXP_4_V6;
			masks[4] = EXP_5_V6;
			masks[5] = EXP_6_V6;
			break;
    	}
    	case 7: {
			masks[0] = EXP_1_V7;
			masks[1] = EXP_2_V7;
			masks[2] = EXP_3_V7;
			masks[3] = EXP_4_V7;
			masks[4] = EXP_5_V7;
			masks[5] = EXP_6_V7;
			masks[6] = EXP_7_V7;
			break;
		}
    	case 8: {
			masks[0] = EXP_1_V8;
			masks[1] = EXP_2_V8;
			masks[2] = EXP_3_V8;
			masks[3] = EXP_4_V8;
			masks[4] = EXP_5_V8;
			masks[5] = EXP_6_V8;
			masks[6] = EXP_7_V8;
			masks[7] = EXP_8_V8;
    		break;
    	}
    	case 9: {
			masks[0] = EXP_1_V9;
			masks[1] = EXP_2_V9;
			masks[2] = EXP_3_V9;
			masks[3] = EXP_4_V9;
			masks[4] = EXP_5_V9;
			masks[5] = EXP_6_V9;
			masks[6] = EXP_7_V9;
			masks[7] = EXP_8_V9;
			masks[8] = EXP_9_V9;
    		break;
    	}
    	case 10: {
			masks[0] = EXP_1_V10;
			masks[1] = EXP_2_V10;
			masks[2] = EXP_3_V10;
			masks[3] = EXP_4_V10;
			masks[4] = EXP_5_V10;
			masks[5] = EXP_6_V10;
			masks[6] = EXP_7_V10;
			masks[7] = EXP_8_V10;
			masks[8] = EXP_9_V10;
			masks[9] = EXP_10_V10;
    		break;
    	}
    	case 11: {
			masks[0] = EXP_1_V11;
			masks[1] = EXP_2_V11;
			masks[2] = EXP_3_V11;
			masks[3] = EXP_4_V11;
			masks[4] = EXP_5_V11;
			masks[5] = EXP_6_V11;
			masks[6] = EXP_7_V11;
			masks[7] = EXP_8_V11;
			masks[8] = EXP_9_V11;
			masks[9] = EXP_10_V11;
			masks[10] = EXP_11_V11;
			break;
    	}
    	case 12: {
			masks[0] = EXP_1_V12;
			masks[1] = EXP_2_V12;
			masks[2] = EXP_3_V12;
			masks[3] = EXP_4_V12;
			masks[4] = EXP_5_V12;
			masks[5] = EXP_6_V12;
			masks[6] = EXP_7_V12;
			masks[7] = EXP_8_V12;
			masks[8] = EXP_9_V12;
			masks[9] = EXP_10_V12;
			masks[10] = EXP_11_V12;
			masks[11] = EXP_12_V12;
			break;
    	}
    	case 13: {
			masks[0] = EXP_1_V13;
			masks[1] = EXP_2_V13;
			masks[2] = EXP_3_V13;
			masks[3] = EXP_4_V13;
			masks[4] = EXP_5_V13;
			masks[5] = EXP_6_V13;
			masks[6] = EXP_7_V13;
			masks[7] = EXP_8_V13;
			masks[8] = EXP_9_V13;
			masks[9] = EXP_10_V13;
			masks[10] = EXP_11_V13;
			masks[11] = EXP_12_V13;
			masks[12] = EXP_13_V13;
    		break;
    	}
    	case 14: {
			masks[0] = EXP_1_V14;
			masks[1] = EXP_2_V14;
			masks[2] = EXP_3_V14;
			masks[3] = EXP_4_V14;
			masks[4] = EXP_5_V14;
			masks[5] = EXP_6_V14;
			masks[6] = EXP_7_V14;
			masks[7] = EXP_8_V14;
			masks[8] = EXP_9_V14;
			masks[9] = EXP_10_V14;
			masks[10] = EXP_11_V14;
			masks[11] = EXP_12_V14;
			masks[12] = EXP_13_V14;
			masks[13] = EXP_14_V14;
    		break;
    	}
    	case 15: {
			masks[0] = EXP_1_V15;
			masks[1] = EXP_2_V15;
			masks[2] = EXP_3_V15;
			masks[3] = EXP_4_V15;
			masks[4] = EXP_5_V15;
			masks[5] = EXP_6_V15;
			masks[6] = EXP_7_V15;
			masks[7] = EXP_8_V15;
			masks[8] = EXP_9_V15;
			masks[9] = EXP_10_V15;
			masks[10] = EXP_11_V15;
			masks[11] = EXP_12_V15;
			masks[12] = EXP_13_V15;
			masks[13] = EXP_14_V15;
			masks[14] = EXP_15_V15;
    		break;
    	}
    	case 16: {
			masks[0] = EXP_1_V16;
			masks[1] = EXP_2_V16;
			masks[2] = EXP_3_V16;
			masks[3] = EXP_4_V16;
			masks[4] = EXP_5_V16;
			masks[5] = EXP_6_V16;
			masks[6] = EXP_7_V16;
			masks[7] = EXP_8_V16;
			masks[8] = EXP_9_V16;
			masks[9] = EXP_10_V16;
			masks[10] = EXP_11_V16;
			masks[11] = EXP_12_V16;
			masks[12] = EXP_13_V16;
			masks[13] = EXP_14_V16;
			masks[14] = EXP_15_V16;
			masks[15] = EXP_16_V16;
    		break;
    	}
    	case 17: {
			masks[0] = EXP_1_V17;
			masks[1] = EXP_2_V17;
			masks[2] = EXP_3_V17;
			masks[3] = EXP_4_V17;
			masks[4] = EXP_5_V17;
			masks[5] = EXP_6_V17;
			masks[6] = EXP_7_V17;
			masks[7] = EXP_8_V17;
			masks[8] = EXP_9_V17;
			masks[9] = EXP_10_V17;
			masks[10] = EXP_11_V17;
			masks[11] = EXP_12_V17;
			masks[12] = EXP_13_V17;
			masks[13] = EXP_14_V17;
			masks[14] = EXP_15_V17;
			masks[15] = EXP_16_V17;
			masks[16] = EXP_17_V17;
    		break;
    	}
    	case 18: {
			masks[0] = EXP_1_V18;
			masks[1] = EXP_2_V18;
			masks[2] = EXP_3_V18;
			masks[3] = EXP_4_V18;
			masks[4] = EXP_5_V18;
			masks[5] = EXP_6_V18;
			masks[6] = EXP_7_V18;
			masks[7] = EXP_8_V18;
			masks[8] = EXP_9_V18;
			masks[9] = EXP_10_V18;
			masks[10] = EXP_11_V18;
			masks[11] = EXP_12_V18;
			masks[12] = EXP_13_V18;
			masks[13] = EXP_14_V18;
			masks[14] = EXP_15_V18;
			masks[15] = EXP_16_V18;
			masks[16] = EXP_17_V18;
			masks[17] = EXP_18_V18;
    		break;
    	}
    	case 19: {
			masks[0] = EXP_1_V19;
			masks[1] = EXP_2_V19;
			masks[2] = EXP_3_V19;
			masks[3] = EXP_4_V19;
			masks[4] = EXP_5_V19;
			masks[5] = EXP_6_V19;
			masks[6] = EXP_7_V19;
			masks[7] = EXP_8_V19;
			masks[8] = EXP_9_V19;
			masks[9] = EXP_10_V19;
			masks[10] = EXP_11_V19;
			masks[11] = EXP_12_V19;
			masks[12] = EXP_13_V19;
			masks[13] = EXP_14_V19;
			masks[14] = EXP_15_V19;
			masks[15] = EXP_16_V19;
			masks[16] = EXP_17_V19;
			masks[17] = EXP_18_V19;
			masks[18] = EXP_19_V19;
    		break;
    	}
    	case 20: {
			masks[0] = EXP_1_V20;
			masks[1] = EXP_2_V20;
			masks[2] = EXP_3_V20;
			masks[3] = EXP_4_V20;
			masks[4] = EXP_5_V20;
			masks[5] = EXP_6_V20;
			masks[6] = EXP_7_V20;
			masks[7] = EXP_8_V20;
			masks[8] = EXP_9_V20;
			masks[9] = EXP_10_V20;
			masks[10] = EXP_11_V20;
			masks[11] = EXP_12_V20;
			masks[12] = EXP_13_V20;
			masks[13] = EXP_14_V20;
			masks[14] = EXP_15_V20;
			masks[15] = EXP_16_V20;
			masks[16] = EXP_17_V20;
			masks[17] = EXP_18_V20;
			masks[18] = EXP_19_V20;
			masks[19] = EXP_20_V20;
    		break;
    	}
    	case 21: {
			masks[0] = EXP_1_V21;
			masks[1] = EXP_2_V21;
			masks[2] = EXP_3_V21;
			masks[3] = EXP_4_V21;
			masks[4] = EXP_5_V21;
			masks[5] = EXP_6_V21;
			masks[6] = EXP_7_V21;
			masks[7] = EXP_8_V21;
			masks[8] = EXP_9_V21;
			masks[9] = EXP_10_V21;
			masks[10] = EXP_11_V21;
			masks[11] = EXP_12_V21;
			masks[12] = EXP_13_V21;
			masks[13] = EXP_14_V21;
			masks[14] = EXP_15_V21;
			masks[15] = EXP_16_V21;
			masks[16] = EXP_17_V21;
			masks[17] = EXP_18_V21;
			masks[18] = EXP_19_V21;
			masks[19] = EXP_20_V21;
			masks[20] = EXP_21_V21;
    		break;
    	}
    	case 22: {
			masks[0] = EXP_1_V22;
			masks[1] = EXP_2_V22;
			masks[2] = EXP_3_V22;
			masks[3] = EXP_4_V22;
			masks[4] = EXP_5_V22;
			masks[5] = EXP_6_V22;
			masks[6] = EXP_7_V22;
			masks[7] = EXP_8_V22;
			masks[8] = EXP_9_V22;
			masks[9] = EXP_10_V22;
			masks[10] = EXP_11_V22;
			masks[11] = EXP_12_V22;
			masks[12] = EXP_13_V22;
			masks[13] = EXP_14_V22;
			masks[14] = EXP_15_V22;
			masks[15] = EXP_16_V22;
			masks[16] = EXP_17_V22;
			masks[17] = EXP_18_V22;
			masks[18] = EXP_19_V22;
			masks[19] = EXP_20_V22;
			masks[20] = EXP_21_V22;
			masks[21] = EXP_22_V22;
    		break;
    	}
    	case 23: {
			masks[0] = EXP_1_V23;
			masks[1] = EXP_2_V23;
			masks[2] = EXP_3_V23;
			masks[3] = EXP_4_V23;
			masks[4] = EXP_5_V23;
			masks[5] = EXP_6_V23;
			masks[6] = EXP_7_V23;
			masks[7] = EXP_8_V23;
			masks[8] = EXP_9_V23;
			masks[9] = EXP_10_V23;
			masks[10] = EXP_11_V23;
			masks[11] = EXP_12_V23;
			masks[12] = EXP_13_V23;
			masks[13] = EXP_14_V23;
			masks[14] = EXP_15_V23;
			masks[15] = EXP_16_V23;
			masks[16] = EXP_17_V23;
			masks[17] = EXP_18_V23;
			masks[18] = EXP_19_V23;
			masks[19] = EXP_20_V23;
			masks[20] = EXP_21_V23;
			masks[21] = EXP_22_V23;
			masks[22] = EXP_23_V23;
    		break;
    	}
    	case 24: {
			masks[0] = EXP_1_V24;
			masks[1] = EXP_2_V24;
			masks[2] = EXP_3_V24;
			masks[3] = EXP_4_V24;
			masks[4] = EXP_5_V24;
			masks[5] = EXP_6_V24;
			masks[6] = EXP_7_V24;
			masks[7] = EXP_8_V24;
			masks[8] = EXP_9_V24;
			masks[9] = EXP_10_V24;
			masks[10] = EXP_11_V24;
			masks[11] = EXP_12_V24;
			masks[12] = EXP_13_V24;
			masks[13] = EXP_14_V24;
			masks[14] = EXP_15_V24;
			masks[15] = EXP_16_V24;
			masks[16] = EXP_17_V24;
			masks[17] = EXP_18_V24;
			masks[18] = EXP_19_V24;
			masks[19] = EXP_20_V24;
			masks[20] = EXP_21_V24;
			masks[21] = EXP_22_V24;
			masks[22] = EXP_23_V24;
			masks[23] = EXP_24_V24;
    		break;
    	}
    	case 25: {
			masks[0] = EXP_1_V25;
			masks[1] = EXP_2_V25;
			masks[2] = EXP_3_V25;
			masks[3] = EXP_4_V25;
			masks[4] = EXP_5_V25;
			masks[5] = EXP_6_V25;
			masks[6] = EXP_7_V25;
			masks[7] = EXP_8_V25;
			masks[8] = EXP_9_V25;
			masks[9] = EXP_10_V25;
			masks[10] = EXP_11_V25;
			masks[11] = EXP_12_V25;
			masks[12] = EXP_13_V25;
			masks[13] = EXP_14_V25;
			masks[14] = EXP_15_V25;
			masks[15] = EXP_16_V25;
			masks[16] = EXP_17_V25;
			masks[17] = EXP_18_V25;
			masks[18] = EXP_19_V25;
			masks[19] = EXP_20_V25;
			masks[20] = EXP_21_V25;
			masks[21] = EXP_22_V25;
			masks[22] = EXP_23_V25;
			masks[23] = EXP_24_V25;
			masks[24] = EXP_25_V25;
    		break;
    	}
    	case 26: {
			masks[0] = EXP_1_V26;
			masks[1] = EXP_2_V26;
			masks[2] = EXP_3_V26;
			masks[3] = EXP_4_V26;
			masks[4] = EXP_5_V26;
			masks[5] = EXP_6_V26;
			masks[6] = EXP_7_V26;
			masks[7] = EXP_8_V26;
			masks[8] = EXP_9_V26;
			masks[9] = EXP_10_V26;
			masks[10] = EXP_11_V26;
			masks[11] = EXP_12_V26;
			masks[12] = EXP_13_V26;
			masks[13] = EXP_14_V26;
			masks[14] = EXP_15_V26;
			masks[15] = EXP_16_V26;
			masks[16] = EXP_17_V26;
			masks[17] = EXP_18_V26;
			masks[18] = EXP_19_V26;
			masks[19] = EXP_20_V26;
			masks[20] = EXP_21_V26;
			masks[21] = EXP_22_V26;
			masks[22] = EXP_23_V26;
			masks[23] = EXP_24_V26;
			masks[24] = EXP_25_V26;
			masks[25] = EXP_26_V26;
    		break;
    	}
    	case 27: {
			masks[0] = EXP_1_V27;
			masks[1] = EXP_2_V27;
			masks[2] = EXP_3_V27;
			masks[3] = EXP_4_V27;
			masks[4] = EXP_5_V27;
			masks[5] = EXP_6_V27;
			masks[6] = EXP_7_V27;
			masks[7] = EXP_8_V27;
			masks[8] = EXP_9_V27;
			masks[9] = EXP_10_V27;
			masks[10] = EXP_11_V27;
			masks[11] = EXP_12_V27;
			masks[12] = EXP_13_V27;
			masks[13] = EXP_14_V27;
			masks[14] = EXP_15_V27;
			masks[15] = EXP_16_V27;
			masks[16] = EXP_17_V27;
			masks[17] = EXP_18_V27;
			masks[18] = EXP_19_V27;
			masks[19] = EXP_20_V27;
			masks[20] = EXP_21_V27;
			masks[21] = EXP_22_V27;
			masks[22] = EXP_23_V27;
			masks[23] = EXP_24_V27;
			masks[24] = EXP_25_V27;
			masks[25] = EXP_26_V27;
			masks[26] = EXP_27_V27;
    		break;
    	}
    	case 28: {
			masks[0] = EXP_1_V28;
			masks[1] = EXP_2_V28;
			masks[2] = EXP_3_V28;
			masks[3] = EXP_4_V28;
			masks[4] = EXP_5_V28;
			masks[5] = EXP_6_V28;
			masks[6] = EXP_7_V28;
			masks[7] = EXP_8_V28;
			masks[8] = EXP_9_V28;
			masks[9] = EXP_10_V28;
			masks[10] = EXP_11_V28;
			masks[11] = EXP_12_V28;
			masks[12] = EXP_13_V28;
			masks[13] = EXP_14_V28;
			masks[14] = EXP_15_V28;
			masks[15] = EXP_16_V28;
			masks[16] = EXP_17_V28;
			masks[17] = EXP_18_V28;
			masks[18] = EXP_19_V28;
			masks[19] = EXP_20_V28;
			masks[20] = EXP_21_V28;
			masks[21] = EXP_22_V28;
			masks[22] = EXP_23_V28;
			masks[23] = EXP_24_V28;
			masks[24] = EXP_25_V28;
			masks[25] = EXP_26_V28;
			masks[26] = EXP_27_V28;
			masks[27] = EXP_28_V28;
    		break;
    	}
    	case 29: {
			masks[0] = EXP_1_V29;
			masks[1] = EXP_2_V29;
			masks[2] = EXP_3_V29;
			masks[3] = EXP_4_V29;
			masks[4] = EXP_5_V29;
			masks[5] = EXP_6_V29;
			masks[6] = EXP_7_V29;
			masks[7] = EXP_8_V29;
			masks[8] = EXP_9_V29;
			masks[9] = EXP_10_V29;
			masks[10] = EXP_11_V29;
			masks[11] = EXP_12_V29;
			masks[12] = EXP_13_V29;
			masks[13] = EXP_14_V29;
			masks[14] = EXP_15_V29;
			masks[15] = EXP_16_V29;
			masks[16] = EXP_17_V29;
			masks[17] = EXP_18_V29;
			masks[18] = EXP_19_V29;
			masks[19] = EXP_20_V29;
			masks[20] = EXP_21_V29;
			masks[21] = EXP_22_V29;
			masks[22] = EXP_23_V29;
			masks[23] = EXP_24_V29;
			masks[24] = EXP_25_V29;
			masks[25] = EXP_26_V29;
			masks[26] = EXP_27_V29;
			masks[27] = EXP_28_V29;
			masks[28] = EXP_29_V29;
    		break;
    	}
    	case 30: {
			masks[0] = EXP_1_V30;
			masks[1] = EXP_2_V30;
			masks[2] = EXP_3_V30;
			masks[3] = EXP_4_V30;
			masks[4] = EXP_5_V30;
			masks[5] = EXP_6_V30;
			masks[6] = EXP_7_V30;
			masks[7] = EXP_8_V30;
			masks[8] = EXP_9_V30;
			masks[9] = EXP_10_V30;
			masks[10] = EXP_11_V30;
			masks[11] = EXP_12_V30;
			masks[12] = EXP_13_V30;
			masks[13] = EXP_14_V30;
			masks[14] = EXP_15_V30;
			masks[15] = EXP_16_V30;
			masks[16] = EXP_17_V30;
			masks[17] = EXP_18_V30;
			masks[18] = EXP_19_V30;
			masks[19] = EXP_20_V30;
			masks[20] = EXP_21_V30;
			masks[21] = EXP_22_V30;
			masks[22] = EXP_23_V30;
			masks[23] = EXP_24_V30;
			masks[24] = EXP_25_V30;
			masks[25] = EXP_26_V30;
			masks[26] = EXP_27_V30;
			masks[27] = EXP_28_V30;
			masks[28] = EXP_29_V30;
			masks[29] = EXP_30_V30;
    		break;
    	}
    	case 31: {
			masks[0] = EXP_1_V31;
			masks[1] = EXP_2_V31;
			masks[2] = EXP_3_V31;
			masks[3] = EXP_4_V31;
			masks[4] = EXP_5_V31;
			masks[5] = EXP_6_V31;
			masks[6] = EXP_7_V31;
			masks[7] = EXP_8_V31;
			masks[8] = EXP_9_V31;
			masks[9] = EXP_10_V31;
			masks[10] = EXP_11_V31;
			masks[11] = EXP_12_V31;
			masks[12] = EXP_13_V31;
			masks[13] = EXP_14_V31;
			masks[14] = EXP_15_V31;
			masks[15] = EXP_16_V31;
			masks[16] = EXP_17_V31;
			masks[17] = EXP_18_V31;
			masks[18] = EXP_19_V31;
			masks[19] = EXP_20_V31;
			masks[20] = EXP_21_V31;
			masks[21] = EXP_22_V31;
			masks[22] = EXP_23_V31;
			masks[23] = EXP_24_V31;
			masks[24] = EXP_25_V31;
			masks[25] = EXP_26_V31;
			masks[26] = EXP_27_V31;
			masks[27] = EXP_28_V31;
			masks[28] = EXP_29_V31;
			masks[29] = EXP_30_V31;
			masks[30] = EXP_31_V31;
    		break;
    	}
    	case 32: {
			masks[0] = EXP_1_V32;
			masks[1] = EXP_2_V32;
			masks[2] = EXP_3_V32;
			masks[3] = EXP_4_V32;
			masks[4] = EXP_5_V32;
			masks[5] = EXP_6_V32;
			masks[6] = EXP_7_V32;
			masks[7] = EXP_8_V32;
			masks[8] = EXP_9_V32;
			masks[9] = EXP_10_V32;
			masks[10] = EXP_11_V32;
			masks[11] = EXP_12_V32;
			masks[12] = EXP_13_V32;
			masks[13] = EXP_14_V32;
			masks[14] = EXP_15_V32;
			masks[15] = EXP_16_V32;
			masks[16] = EXP_17_V32;
			masks[17] = EXP_18_V32;
			masks[18] = EXP_19_V32;
			masks[19] = EXP_20_V32;
			masks[20] = EXP_21_V32;
			masks[21] = EXP_22_V32;
			masks[22] = EXP_23_V32;
			masks[23] = EXP_24_V32;
			masks[24] = EXP_25_V32;
			masks[25] = EXP_26_V32;
			masks[26] = EXP_27_V32;
			masks[27] = EXP_28_V32;
			masks[28] = EXP_29_V32;
			masks[29] = EXP_30_V32;
			masks[30] = EXP_31_V32;
			masks[31] = EXP_32_V32;
    		break;
    	}
    	default : {
    		fprintf(stderr, "EXP MASK ARRAY NOT DEFINED FOR NVAR %d\n",nvar);
    		return NULL;
    	}
    }
    return masks;
}

static degrees_t* getMaxExpArray (int nvar) {
	degrees_t* maxExps = (degrees_t*) malloc(nvar*sizeof(degrees_t));

	switch(nvar) {
		case 1: {
			maxExps[0] = MAX_EXP_1_V1;
			break;
		}
		case 2: {
			maxExps[0] = MAX_EXP_1_V2;
			maxExps[1] = MAX_EXP_2_V2;
			break;
		}
		case 3: {
			maxExps[0] = MAX_EXP_1_V3;
			maxExps[1] = MAX_EXP_2_V3;
			maxExps[2] = MAX_EXP_3_V3;
			break;
		}
		case 4: {
			maxExps[0] = MAX_EXP_1_V4;
			maxExps[1] = MAX_EXP_2_V4;
			maxExps[2] = MAX_EXP_3_V4;
			maxExps[3] = MAX_EXP_4_V4;
			break;
		}
		case 5: {
			maxExps[0] = MAX_EXP_1_V5;
			maxExps[1] = MAX_EXP_2_V5;
			maxExps[2] = MAX_EXP_3_V5;
			maxExps[3] = MAX_EXP_4_V5;
			maxExps[4] = MAX_EXP_5_V5;
			break;
		}
		case 6: {
			maxExps[0] = MAX_EXP_1_V6;
			maxExps[1] = MAX_EXP_2_V6;
			maxExps[2] = MAX_EXP_3_V6;
			maxExps[3] = MAX_EXP_4_V6;
			maxExps[4] = MAX_EXP_5_V6;
			maxExps[5] = MAX_EXP_6_V6;
			break;
		}
		case 7: {
			maxExps[0] = MAX_EXP_1_V7;
			maxExps[1] = MAX_EXP_2_V7;
			maxExps[2] = MAX_EXP_3_V7;
			maxExps[3] = MAX_EXP_4_V7;
			maxExps[4] = MAX_EXP_5_V7;
			maxExps[5] = MAX_EXP_6_V7;
			maxExps[6] = MAX_EXP_7_V7;
			break;
		}
		case 8: {
			maxExps[0] = MAX_EXP_1_V8;
			maxExps[1] = MAX_EXP_2_V8;
			maxExps[2] = MAX_EXP_3_V8;
			maxExps[3] = MAX_EXP_4_V8;
			maxExps[4] = MAX_EXP_5_V8;
			maxExps[5] = MAX_EXP_6_V8;
			maxExps[6] = MAX_EXP_7_V8;
			maxExps[7] = MAX_EXP_8_V8;
			break;
		}
		case 9: {
			maxExps[0] = MAX_EXP_1_V9;
			maxExps[1] = MAX_EXP_2_V9;
			maxExps[2] = MAX_EXP_3_V9;
			maxExps[3] = MAX_EXP_4_V9;
			maxExps[4] = MAX_EXP_5_V9;
			maxExps[5] = MAX_EXP_6_V9;
			maxExps[6] = MAX_EXP_7_V9;
			maxExps[7] = MAX_EXP_8_V9;
			maxExps[8] = MAX_EXP_9_V9;
			break;
		}
		case 10: {
			maxExps[0] = MAX_EXP_1_V10;
			maxExps[1] = MAX_EXP_2_V10;
			maxExps[2] = MAX_EXP_3_V10;
			maxExps[3] = MAX_EXP_4_V10;
			maxExps[4] = MAX_EXP_5_V10;
			maxExps[5] = MAX_EXP_6_V10;
			maxExps[6] = MAX_EXP_7_V10;
			maxExps[7] = MAX_EXP_8_V10;
			maxExps[8] = MAX_EXP_9_V10;
			maxExps[9] = MAX_EXP_10_V10;
			break;
		}
		case 11: {
			maxExps[0] = MAX_EXP_1_V11;
			maxExps[1] = MAX_EXP_2_V11;
			maxExps[2] = MAX_EXP_3_V11;
			maxExps[3] = MAX_EXP_4_V11;
			maxExps[4] = MAX_EXP_5_V11;
			maxExps[5] = MAX_EXP_6_V11;
			maxExps[6] = MAX_EXP_7_V11;
			maxExps[7] = MAX_EXP_8_V11;
			maxExps[8] = MAX_EXP_9_V11;
			maxExps[9] = MAX_EXP_10_V11;
			maxExps[10] = MAX_EXP_11_V11;
			break;
		}
		case 12: {
			maxExps[0] = MAX_EXP_1_V12;
			maxExps[1] = MAX_EXP_2_V12;
			maxExps[2] = MAX_EXP_3_V12;
			maxExps[3] = MAX_EXP_4_V12;
			maxExps[4] = MAX_EXP_5_V12;
			maxExps[5] = MAX_EXP_6_V12;
			maxExps[6] = MAX_EXP_7_V12;
			maxExps[7] = MAX_EXP_8_V12;
			maxExps[8] = MAX_EXP_9_V12;
			maxExps[9] = MAX_EXP_10_V12;
			maxExps[10] = MAX_EXP_11_V12;
			maxExps[11] = MAX_EXP_12_V12;
			break;
		}
		case 13: {
			maxExps[0] = MAX_EXP_1_V13;
			maxExps[1] = MAX_EXP_2_V13;
			maxExps[2] = MAX_EXP_3_V13;
			maxExps[3] = MAX_EXP_4_V13;
			maxExps[4] = MAX_EXP_5_V13;
			maxExps[5] = MAX_EXP_6_V13;
			maxExps[6] = MAX_EXP_7_V13;
			maxExps[7] = MAX_EXP_8_V13;
			maxExps[8] = MAX_EXP_9_V13;
			maxExps[9] = MAX_EXP_10_V13;
			maxExps[10] = MAX_EXP_11_V13;
			maxExps[11] = MAX_EXP_12_V13;
			maxExps[12] = MAX_EXP_13_V13;
			break;
		}
		case 14: {
			maxExps[0] = MAX_EXP_1_V14;
			maxExps[1] = MAX_EXP_2_V14;
			maxExps[2] = MAX_EXP_3_V14;
			maxExps[3] = MAX_EXP_4_V14;
			maxExps[4] = MAX_EXP_5_V14;
			maxExps[5] = MAX_EXP_6_V14;
			maxExps[6] = MAX_EXP_7_V14;
			maxExps[7] = MAX_EXP_8_V14;
			maxExps[8] = MAX_EXP_9_V14;
			maxExps[9] = MAX_EXP_10_V14;
			maxExps[10] = MAX_EXP_11_V14;
			maxExps[11] = MAX_EXP_12_V14;
			maxExps[12] = MAX_EXP_13_V14;
			maxExps[13] = MAX_EXP_14_V14;
			break;
		}
		case 15: {
			maxExps[0] = MAX_EXP_1_V15;
			maxExps[1] = MAX_EXP_2_V15;
			maxExps[2] = MAX_EXP_3_V15;
			maxExps[3] = MAX_EXP_4_V15;
			maxExps[4] = MAX_EXP_5_V15;
			maxExps[5] = MAX_EXP_6_V15;
			maxExps[6] = MAX_EXP_7_V15;
			maxExps[7] = MAX_EXP_8_V15;
			maxExps[8] = MAX_EXP_9_V15;
			maxExps[9] = MAX_EXP_10_V15;
			maxExps[10] = MAX_EXP_11_V15;
			maxExps[11] = MAX_EXP_12_V15;
			maxExps[12] = MAX_EXP_13_V15;
			maxExps[13] = MAX_EXP_14_V15;
			maxExps[14] = MAX_EXP_15_V15;
			break;
		}
		case 16: {
			maxExps[0] = MAX_EXP_1_V16;
			maxExps[1] = MAX_EXP_2_V16;
			maxExps[2] = MAX_EXP_3_V16;
			maxExps[3] = MAX_EXP_4_V16;
			maxExps[4] = MAX_EXP_5_V16;
			maxExps[5] = MAX_EXP_6_V16;
			maxExps[6] = MAX_EXP_7_V16;
			maxExps[7] = MAX_EXP_8_V16;
			maxExps[8] = MAX_EXP_9_V16;
			maxExps[9] = MAX_EXP_10_V16;
			maxExps[10] = MAX_EXP_11_V16;
			maxExps[11] = MAX_EXP_12_V16;
			maxExps[12] = MAX_EXP_13_V16;
			maxExps[13] = MAX_EXP_14_V16;
			maxExps[14] = MAX_EXP_15_V16;
			maxExps[15] = MAX_EXP_16_V16;
			break;
		}
		case 17: {
			maxExps[0] = MAX_EXP_1_V17;
			maxExps[1] = MAX_EXP_2_V17;
			maxExps[2] = MAX_EXP_3_V17;
			maxExps[3] = MAX_EXP_4_V17;
			maxExps[4] = MAX_EXP_5_V17;
			maxExps[5] = MAX_EXP_6_V17;
			maxExps[6] = MAX_EXP_7_V17;
			maxExps[7] = MAX_EXP_8_V17;
			maxExps[8] = MAX_EXP_9_V17;
			maxExps[9] = MAX_EXP_10_V17;
			maxExps[10] = MAX_EXP_11_V17;
			maxExps[11] = MAX_EXP_12_V17;
			maxExps[12] = MAX_EXP_13_V17;
			maxExps[13] = MAX_EXP_14_V17;
			maxExps[14] = MAX_EXP_15_V17;
			maxExps[15] = MAX_EXP_16_V17;
			maxExps[16] = MAX_EXP_17_V17;
			break;
		}
		case 18: {
			maxExps[0] = MAX_EXP_1_V18;
			maxExps[1] = MAX_EXP_2_V18;
			maxExps[2] = MAX_EXP_3_V18;
			maxExps[3] = MAX_EXP_4_V18;
			maxExps[4] = MAX_EXP_5_V18;
			maxExps[5] = MAX_EXP_6_V18;
			maxExps[6] = MAX_EXP_7_V18;
			maxExps[7] = MAX_EXP_8_V18;
			maxExps[8] = MAX_EXP_9_V18;
			maxExps[9] = MAX_EXP_10_V18;
			maxExps[10] = MAX_EXP_11_V18;
			maxExps[11] = MAX_EXP_12_V18;
			maxExps[12] = MAX_EXP_13_V18;
			maxExps[13] = MAX_EXP_14_V18;
			maxExps[14] = MAX_EXP_15_V18;
			maxExps[15] = MAX_EXP_16_V18;
			maxExps[16] = MAX_EXP_17_V18;
			maxExps[17] = MAX_EXP_18_V18;
			break;
		}
		case 19: {
			maxExps[0] = MAX_EXP_1_V19;
			maxExps[1] = MAX_EXP_2_V19;
			maxExps[2] = MAX_EXP_3_V19;
			maxExps[3] = MAX_EXP_4_V19;
			maxExps[4] = MAX_EXP_5_V19;
			maxExps[5] = MAX_EXP_6_V19;
			maxExps[6] = MAX_EXP_7_V19;
			maxExps[7] = MAX_EXP_8_V19;
			maxExps[8] = MAX_EXP_9_V19;
			maxExps[9] = MAX_EXP_10_V19;
			maxExps[10] = MAX_EXP_11_V19;
			maxExps[11] = MAX_EXP_12_V19;
			maxExps[12] = MAX_EXP_13_V19;
			maxExps[13] = MAX_EXP_14_V19;
			maxExps[14] = MAX_EXP_15_V19;
			maxExps[15] = MAX_EXP_16_V19;
			maxExps[16] = MAX_EXP_17_V19;
			maxExps[17] = MAX_EXP_18_V19;
			maxExps[18] = MAX_EXP_19_V19;
			break;
		}
		case 20: {
			maxExps[0] = MAX_EXP_1_V20;
			maxExps[1] = MAX_EXP_2_V20;
			maxExps[2] = MAX_EXP_3_V20;
			maxExps[3] = MAX_EXP_4_V20;
			maxExps[4] = MAX_EXP_5_V20;
			maxExps[5] = MAX_EXP_6_V20;
			maxExps[6] = MAX_EXP_7_V20;
			maxExps[7] = MAX_EXP_8_V20;
			maxExps[8] = MAX_EXP_9_V20;
			maxExps[9] = MAX_EXP_10_V20;
			maxExps[10] = MAX_EXP_11_V20;
			maxExps[11] = MAX_EXP_12_V20;
			maxExps[12] = MAX_EXP_13_V20;
			maxExps[13] = MAX_EXP_14_V20;
			maxExps[14] = MAX_EXP_15_V20;
			maxExps[15] = MAX_EXP_16_V20;
			maxExps[16] = MAX_EXP_17_V20;
			maxExps[17] = MAX_EXP_18_V20;
			maxExps[18] = MAX_EXP_19_V20;
			maxExps[19] = MAX_EXP_20_V20;
			break;
		}
		case 21: {
			maxExps[0] = MAX_EXP_1_V21;
			maxExps[1] = MAX_EXP_2_V21;
			maxExps[2] = MAX_EXP_3_V21;
			maxExps[3] = MAX_EXP_4_V21;
			maxExps[4] = MAX_EXP_5_V21;
			maxExps[5] = MAX_EXP_6_V21;
			maxExps[6] = MAX_EXP_7_V21;
			maxExps[7] = MAX_EXP_8_V21;
			maxExps[8] = MAX_EXP_9_V21;
			maxExps[9] = MAX_EXP_10_V21;
			maxExps[10] = MAX_EXP_11_V21;
			maxExps[11] = MAX_EXP_12_V21;
			maxExps[12] = MAX_EXP_13_V21;
			maxExps[13] = MAX_EXP_14_V21;
			maxExps[14] = MAX_EXP_15_V21;
			maxExps[15] = MAX_EXP_16_V21;
			maxExps[16] = MAX_EXP_17_V21;
			maxExps[17] = MAX_EXP_18_V21;
			maxExps[18] = MAX_EXP_19_V21;
			maxExps[19] = MAX_EXP_20_V21;
			maxExps[20] = MAX_EXP_21_V21;
			break;
		}
		case 22: {
			maxExps[0] = MAX_EXP_1_V22;
			maxExps[1] = MAX_EXP_2_V22;
			maxExps[2] = MAX_EXP_3_V22;
			maxExps[3] = MAX_EXP_4_V22;
			maxExps[4] = MAX_EXP_5_V22;
			maxExps[5] = MAX_EXP_6_V22;
			maxExps[6] = MAX_EXP_7_V22;
			maxExps[7] = MAX_EXP_8_V22;
			maxExps[8] = MAX_EXP_9_V22;
			maxExps[9] = MAX_EXP_10_V22;
			maxExps[10] = MAX_EXP_11_V22;
			maxExps[11] = MAX_EXP_12_V22;
			maxExps[12] = MAX_EXP_13_V22;
			maxExps[13] = MAX_EXP_14_V22;
			maxExps[14] = MAX_EXP_15_V22;
			maxExps[15] = MAX_EXP_16_V22;
			maxExps[16] = MAX_EXP_17_V22;
			maxExps[17] = MAX_EXP_18_V22;
			maxExps[18] = MAX_EXP_19_V22;
			maxExps[19] = MAX_EXP_20_V22;
			maxExps[20] = MAX_EXP_21_V22;
			maxExps[21] = MAX_EXP_22_V22;
			break;
		}
		case 23: {
			maxExps[0] = MAX_EXP_1_V23;
			maxExps[1] = MAX_EXP_2_V23;
			maxExps[2] = MAX_EXP_3_V23;
			maxExps[3] = MAX_EXP_4_V23;
			maxExps[4] = MAX_EXP_5_V23;
			maxExps[5] = MAX_EXP_6_V23;
			maxExps[6] = MAX_EXP_7_V23;
			maxExps[7] = MAX_EXP_8_V23;
			maxExps[8] = MAX_EXP_9_V23;
			maxExps[9] = MAX_EXP_10_V23;
			maxExps[10] = MAX_EXP_11_V23;
			maxExps[11] = MAX_EXP_12_V23;
			maxExps[12] = MAX_EXP_13_V23;
			maxExps[13] = MAX_EXP_14_V23;
			maxExps[14] = MAX_EXP_15_V23;
			maxExps[15] = MAX_EXP_16_V23;
			maxExps[16] = MAX_EXP_17_V23;
			maxExps[17] = MAX_EXP_18_V23;
			maxExps[18] = MAX_EXP_19_V23;
			maxExps[19] = MAX_EXP_20_V23;
			maxExps[20] = MAX_EXP_21_V23;
			maxExps[21] = MAX_EXP_22_V23;
			maxExps[22] = MAX_EXP_23_V23;
			break;
		}
		case 24: {
			maxExps[0] = MAX_EXP_1_V24;
			maxExps[1] = MAX_EXP_2_V24;
			maxExps[2] = MAX_EXP_3_V24;
			maxExps[3] = MAX_EXP_4_V24;
			maxExps[4] = MAX_EXP_5_V24;
			maxExps[5] = MAX_EXP_6_V24;
			maxExps[6] = MAX_EXP_7_V24;
			maxExps[7] = MAX_EXP_8_V24;
			maxExps[8] = MAX_EXP_9_V24;
			maxExps[9] = MAX_EXP_10_V24;
			maxExps[10] = MAX_EXP_11_V24;
			maxExps[11] = MAX_EXP_12_V24;
			maxExps[12] = MAX_EXP_13_V24;
			maxExps[13] = MAX_EXP_14_V24;
			maxExps[14] = MAX_EXP_15_V24;
			maxExps[15] = MAX_EXP_16_V24;
			maxExps[16] = MAX_EXP_17_V24;
			maxExps[17] = MAX_EXP_18_V24;
			maxExps[18] = MAX_EXP_19_V24;
			maxExps[19] = MAX_EXP_20_V24;
			maxExps[20] = MAX_EXP_21_V24;
			maxExps[21] = MAX_EXP_22_V24;
			maxExps[22] = MAX_EXP_23_V24;
			maxExps[23] = MAX_EXP_24_V24;
			break;
		}
		case 25: {
			maxExps[0] = MAX_EXP_1_V25;
			maxExps[1] = MAX_EXP_2_V25;
			maxExps[2] = MAX_EXP_3_V25;
			maxExps[3] = MAX_EXP_4_V25;
			maxExps[4] = MAX_EXP_5_V25;
			maxExps[5] = MAX_EXP_6_V25;
			maxExps[6] = MAX_EXP_7_V25;
			maxExps[7] = MAX_EXP_8_V25;
			maxExps[8] = MAX_EXP_9_V25;
			maxExps[9] = MAX_EXP_10_V25;
			maxExps[10] = MAX_EXP_11_V25;
			maxExps[11] = MAX_EXP_12_V25;
			maxExps[12] = MAX_EXP_13_V25;
			maxExps[13] = MAX_EXP_14_V25;
			maxExps[14] = MAX_EXP_15_V25;
			maxExps[15] = MAX_EXP_16_V25;
			maxExps[16] = MAX_EXP_17_V25;
			maxExps[17] = MAX_EXP_18_V25;
			maxExps[18] = MAX_EXP_19_V25;
			maxExps[19] = MAX_EXP_20_V25;
			maxExps[20] = MAX_EXP_21_V25;
			maxExps[21] = MAX_EXP_22_V25;
			maxExps[22] = MAX_EXP_23_V25;
			maxExps[23] = MAX_EXP_24_V25;
			maxExps[24] = MAX_EXP_25_V25;
			break;
		}
		case 26: {
			maxExps[0] = MAX_EXP_1_V26;
			maxExps[1] = MAX_EXP_2_V26;
			maxExps[2] = MAX_EXP_3_V26;
			maxExps[3] = MAX_EXP_4_V26;
			maxExps[4] = MAX_EXP_5_V26;
			maxExps[5] = MAX_EXP_6_V26;
			maxExps[6] = MAX_EXP_7_V26;
			maxExps[7] = MAX_EXP_8_V26;
			maxExps[8] = MAX_EXP_9_V26;
			maxExps[9] = MAX_EXP_10_V26;
			maxExps[10] = MAX_EXP_11_V26;
			maxExps[11] = MAX_EXP_12_V26;
			maxExps[12] = MAX_EXP_13_V26;
			maxExps[13] = MAX_EXP_14_V26;
			maxExps[14] = MAX_EXP_15_V26;
			maxExps[15] = MAX_EXP_16_V26;
			maxExps[16] = MAX_EXP_17_V26;
			maxExps[17] = MAX_EXP_18_V26;
			maxExps[18] = MAX_EXP_19_V26;
			maxExps[19] = MAX_EXP_20_V26;
			maxExps[20] = MAX_EXP_21_V26;
			maxExps[21] = MAX_EXP_22_V26;
			maxExps[22] = MAX_EXP_23_V26;
			maxExps[23] = MAX_EXP_24_V26;
			maxExps[24] = MAX_EXP_25_V26;
			maxExps[25] = MAX_EXP_26_V26;
			break;
		}
		case 27: {
			maxExps[0] = MAX_EXP_1_V27;
			maxExps[1] = MAX_EXP_2_V27;
			maxExps[2] = MAX_EXP_3_V27;
			maxExps[3] = MAX_EXP_4_V27;
			maxExps[4] = MAX_EXP_5_V27;
			maxExps[5] = MAX_EXP_6_V27;
			maxExps[6] = MAX_EXP_7_V27;
			maxExps[7] = MAX_EXP_8_V27;
			maxExps[8] = MAX_EXP_9_V27;
			maxExps[9] = MAX_EXP_10_V27;
			maxExps[10] = MAX_EXP_11_V27;
			maxExps[11] = MAX_EXP_12_V27;
			maxExps[12] = MAX_EXP_13_V27;
			maxExps[13] = MAX_EXP_14_V27;
			maxExps[14] = MAX_EXP_15_V27;
			maxExps[15] = MAX_EXP_16_V27;
			maxExps[16] = MAX_EXP_17_V27;
			maxExps[17] = MAX_EXP_18_V27;
			maxExps[18] = MAX_EXP_19_V27;
			maxExps[19] = MAX_EXP_20_V27;
			maxExps[20] = MAX_EXP_21_V27;
			maxExps[21] = MAX_EXP_22_V27;
			maxExps[22] = MAX_EXP_23_V27;
			maxExps[23] = MAX_EXP_24_V27;
			maxExps[24] = MAX_EXP_25_V27;
			maxExps[25] = MAX_EXP_26_V27;
			maxExps[26] = MAX_EXP_27_V27;
			break;
		}
		case 28: {
			maxExps[0] = MAX_EXP_1_V28;
			maxExps[1] = MAX_EXP_2_V28;
			maxExps[2] = MAX_EXP_3_V28;
			maxExps[3] = MAX_EXP_4_V28;
			maxExps[4] = MAX_EXP_5_V28;
			maxExps[5] = MAX_EXP_6_V28;
			maxExps[6] = MAX_EXP_7_V28;
			maxExps[7] = MAX_EXP_8_V28;
			maxExps[8] = MAX_EXP_9_V28;
			maxExps[9] = MAX_EXP_10_V28;
			maxExps[10] = MAX_EXP_11_V28;
			maxExps[11] = MAX_EXP_12_V28;
			maxExps[12] = MAX_EXP_13_V28;
			maxExps[13] = MAX_EXP_14_V28;
			maxExps[14] = MAX_EXP_15_V28;
			maxExps[15] = MAX_EXP_16_V28;
			maxExps[16] = MAX_EXP_17_V28;
			maxExps[17] = MAX_EXP_18_V28;
			maxExps[18] = MAX_EXP_19_V28;
			maxExps[19] = MAX_EXP_20_V28;
			maxExps[20] = MAX_EXP_21_V28;
			maxExps[21] = MAX_EXP_22_V28;
			maxExps[22] = MAX_EXP_23_V28;
			maxExps[23] = MAX_EXP_24_V28;
			maxExps[24] = MAX_EXP_25_V28;
			maxExps[25] = MAX_EXP_26_V28;
			maxExps[26] = MAX_EXP_27_V28;
			maxExps[27] = MAX_EXP_28_V28;
			break;
		}
		case 29: {
			maxExps[0] = MAX_EXP_1_V29;
			maxExps[1] = MAX_EXP_2_V29;
			maxExps[2] = MAX_EXP_3_V29;
			maxExps[3] = MAX_EXP_4_V29;
			maxExps[4] = MAX_EXP_5_V29;
			maxExps[5] = MAX_EXP_6_V29;
			maxExps[6] = MAX_EXP_7_V29;
			maxExps[7] = MAX_EXP_8_V29;
			maxExps[8] = MAX_EXP_9_V29;
			maxExps[9] = MAX_EXP_10_V29;
			maxExps[10] = MAX_EXP_11_V29;
			maxExps[11] = MAX_EXP_12_V29;
			maxExps[12] = MAX_EXP_13_V29;
			maxExps[13] = MAX_EXP_14_V29;
			maxExps[14] = MAX_EXP_15_V29;
			maxExps[15] = MAX_EXP_16_V29;
			maxExps[16] = MAX_EXP_17_V29;
			maxExps[17] = MAX_EXP_18_V29;
			maxExps[18] = MAX_EXP_19_V29;
			maxExps[19] = MAX_EXP_20_V29;
			maxExps[20] = MAX_EXP_21_V29;
			maxExps[21] = MAX_EXP_22_V29;
			maxExps[22] = MAX_EXP_23_V29;
			maxExps[23] = MAX_EXP_24_V29;
			maxExps[24] = MAX_EXP_25_V29;
			maxExps[25] = MAX_EXP_26_V29;
			maxExps[26] = MAX_EXP_27_V29;
			maxExps[27] = MAX_EXP_28_V29;
			maxExps[28] = MAX_EXP_29_V29;
			break;
		}
		case 30: {
			maxExps[0] = MAX_EXP_1_V30;
			maxExps[1] = MAX_EXP_2_V30;
			maxExps[2] = MAX_EXP_3_V30;
			maxExps[3] = MAX_EXP_4_V30;
			maxExps[4] = MAX_EXP_5_V30;
			maxExps[5] = MAX_EXP_6_V30;
			maxExps[6] = MAX_EXP_7_V30;
			maxExps[7] = MAX_EXP_8_V30;
			maxExps[8] = MAX_EXP_9_V30;
			maxExps[9] = MAX_EXP_10_V30;
			maxExps[10] = MAX_EXP_11_V30;
			maxExps[11] = MAX_EXP_12_V30;
			maxExps[12] = MAX_EXP_13_V30;
			maxExps[13] = MAX_EXP_14_V30;
			maxExps[14] = MAX_EXP_15_V30;
			maxExps[15] = MAX_EXP_16_V30;
			maxExps[16] = MAX_EXP_17_V30;
			maxExps[17] = MAX_EXP_18_V30;
			maxExps[18] = MAX_EXP_19_V30;
			maxExps[19] = MAX_EXP_20_V30;
			maxExps[20] = MAX_EXP_21_V30;
			maxExps[21] = MAX_EXP_22_V30;
			maxExps[22] = MAX_EXP_23_V30;
			maxExps[23] = MAX_EXP_24_V30;
			maxExps[24] = MAX_EXP_25_V30;
			maxExps[25] = MAX_EXP_26_V30;
			maxExps[26] = MAX_EXP_27_V30;
			maxExps[27] = MAX_EXP_28_V30;
			maxExps[28] = MAX_EXP_29_V30;
			maxExps[29] = MAX_EXP_30_V30;
			break;
		}
		case 31: {
			maxExps[0] = MAX_EXP_1_V31;
			maxExps[1] = MAX_EXP_2_V31;
			maxExps[2] = MAX_EXP_3_V31;
			maxExps[3] = MAX_EXP_4_V31;
			maxExps[4] = MAX_EXP_5_V31;
			maxExps[5] = MAX_EXP_6_V31;
			maxExps[6] = MAX_EXP_7_V31;
			maxExps[7] = MAX_EXP_8_V31;
			maxExps[8] = MAX_EXP_9_V31;
			maxExps[9] = MAX_EXP_10_V31;
			maxExps[10] = MAX_EXP_11_V31;
			maxExps[11] = MAX_EXP_12_V31;
			maxExps[12] = MAX_EXP_13_V31;
			maxExps[13] = MAX_EXP_14_V31;
			maxExps[14] = MAX_EXP_15_V31;
			maxExps[15] = MAX_EXP_16_V31;
			maxExps[16] = MAX_EXP_17_V31;
			maxExps[17] = MAX_EXP_18_V31;
			maxExps[18] = MAX_EXP_19_V31;
			maxExps[19] = MAX_EXP_20_V31;
			maxExps[20] = MAX_EXP_21_V31;
			maxExps[21] = MAX_EXP_22_V31;
			maxExps[22] = MAX_EXP_23_V31;
			maxExps[23] = MAX_EXP_24_V31;
			maxExps[24] = MAX_EXP_25_V31;
			maxExps[25] = MAX_EXP_26_V31;
			maxExps[26] = MAX_EXP_27_V31;
			maxExps[27] = MAX_EXP_28_V31;
			maxExps[28] = MAX_EXP_29_V31;
			maxExps[29] = MAX_EXP_30_V31;
			maxExps[30] = MAX_EXP_31_V31;
			break;
		}
		case 32: {
			maxExps[0] = MAX_EXP_1_V32;
			maxExps[1] = MAX_EXP_2_V32;
			maxExps[2] = MAX_EXP_3_V32;
			maxExps[3] = MAX_EXP_4_V32;
			maxExps[4] = MAX_EXP_5_V32;
			maxExps[5] = MAX_EXP_6_V32;
			maxExps[6] = MAX_EXP_7_V32;
			maxExps[7] = MAX_EXP_8_V32;
			maxExps[8] = MAX_EXP_9_V32;
			maxExps[9] = MAX_EXP_10_V32;
			maxExps[10] = MAX_EXP_11_V32;
			maxExps[11] = MAX_EXP_12_V32;
			maxExps[12] = MAX_EXP_13_V32;
			maxExps[13] = MAX_EXP_14_V32;
			maxExps[14] = MAX_EXP_15_V32;
			maxExps[15] = MAX_EXP_16_V32;
			maxExps[16] = MAX_EXP_17_V32;
			maxExps[17] = MAX_EXP_18_V32;
			maxExps[18] = MAX_EXP_19_V32;
			maxExps[19] = MAX_EXP_20_V32;
			maxExps[20] = MAX_EXP_21_V32;
			maxExps[21] = MAX_EXP_22_V32;
			maxExps[22] = MAX_EXP_23_V32;
			maxExps[23] = MAX_EXP_24_V32;
			maxExps[24] = MAX_EXP_25_V32;
			maxExps[25] = MAX_EXP_26_V32;
			maxExps[26] = MAX_EXP_27_V32;
			maxExps[27] = MAX_EXP_28_V32;
			maxExps[28] = MAX_EXP_29_V32;
			maxExps[29] = MAX_EXP_30_V32;
			maxExps[30] = MAX_EXP_31_V32;
			maxExps[31] = MAX_EXP_32_V32;
			break;
		}
	}
	
	return maxExps;
}


static int checkValidMonomialMult(degrees_t maxA, degrees_t maxB, int nvar) {
	if (nvar <= 0) {
		return 1;
	}

	degrees_t* masks = getExpMaskArray(nvar);
	int* sizes = getExpOffsetArray(nvar);
	degrees_t* maxExps = getMaxExpArray(nvar);

	degree_t a, b;
	for (int j = 0; j < nvar; ++j) {
		a = GET_NTH_EXP(maxA, masks[j], sizes[j]);
		b = GET_NTH_EXP(maxB, masks[j], sizes[j]);
		if (a + b > maxExps[j]) {
			fprintf(stderr, "SMQP ERROR: Overflow in exponent packing for mult at index %d; %d + %d.\n", j, a, b);
			exit(1); //TODO
		}
	}
	return 1;
}


#endif/* This file is part of the BPAS library http://www.bpaslib.org

    BPAS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BPAS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BPAS.  If not, see <http://www.gnu.org/licenses/>.

    Copyright:
        Mohammadali Asadi <masadi4@uwo.ca>
        Alexander Brandt <abrandt5@uwo.ca>
        Changbo Chen <changbo.chen@hotmail.com>
        Svyatoslav Covanov <svyatoslav.covanov@loria.fr>
        Farnam Mansouri <mansouri.farnam@gmail.com>
        Davood Mohajerani <mohajerani.d@gmail.com>
        Robert Moir <robert@moir.net>
        Marc Moreno Maza  <moreno@csd.uwo.ca>
        Delaram Talaashrafi <dtalaash@uwo.ca>
        Amha Tsegaye <atsegaye@uwo.ca>
        Linxiao Wang <lwang739@uwo.ca>
        Ning Xie <nxie6@csd.uwo.ca>
        Yuzhen Xie <yuzhenxie@yahoo.ca>

*/


